============================================================================ 
This data file shows one normal mode in the LiOH.H2O crystal, resulting from
an ab initio force field (Ref. Acta Cryst. B50 (1994) 268-279).
The data file contains atoms with Z=8 (water oxygen), Z=108 (OH- oxygen),
Z=1 (water hydrogen), Z=101 (OH- hydrogen) and Z=3 (Li). This was done to be 
able to give different colors to different oxygens and hydrogens. The
following changes are here made compared to the default setting of the program:
      
      An introductory text is displayed.
      
      The 1, 8, 101 and 108 atoms are given user-specified colors.
      
      The bonding scheme:
      A Moviemol run WITH DEFAULT SETTINGS will give the following 
      undesired (for our purpose, right now) features:
      a) Black covalent Li-O and Li-Li bonds will be drawn by default. 
         This we adjust with the parameters 'nremovecov','nocov1' and 'nocov2'
      b) The intramolecular O-H bonds will break when the vibrating bonds are 
         the longest. 
         This can be fixed in two ways: either by setting 'ikeepbonds=1' or by 
         increasing 'flex' to an appropriate value. Here, changing 'ikeepbonds' 
         seems the simplest, i.e. the bonding scheme is determined in the 
         first frame and then kept throughout the movie. 
      c) No H-bonds are drawn.
         Although the program by default draws H-bonds for all H...O distances
         between 1.6 and 2.2 A, it doesn't do so here because it is the 
         108-oxygen which participates in H-bonds. 
         We fix this by defining an H-bond as a bond between 108 and 1
         or 108 and 101 ('bonddonor(1)' and 'bonddonor(2)', etc.)
      d) Cation-O bonds are not automatically drawn.
         We fix this by defining a third and a fourth non-covalent bond type
         ('bonddonor(3)', etc.).

=============================================================================
 $CNTRL                                         
  introtext = 1, text(5) = 'NCA analysis for LiOH.H2O ',
  atomcolor(1) = 'lightblue', atomcolor(8) = 'turquoise',
  atomcolor(101) = 'magenta', atomcolor(108) = 'purple',
  ikeepbonds = 1,   
  nremovecov=3, nocov1(1)=3, nocov2(1)=8, nocov1(2)=3, nocov2(2)=108,
                nocov1(3)=3, nocov2(3)=3,
  bonddonor =      1,101, 3,  3,
  bondacceptor = 108,108, 8,108,
  bonddistmin = 1.6,1.6,1.8,1.8, bonddistmax = 2.4,2.4,2.2,2.2,
  bondcolor = 'white','white','green','green',
 $END                                                                      

