// xygrf.c
//
// version 0.1b
//
//	A general use program which reads data files in column format and then
//	plots selected columns.  Video type is set in the xygrf.cfg
//	configuration file.
//
//	Maximum array size for the data set is now 1000 points, but it is
//	obvious how to change this.
//
//	This program is PostCardWare.  Send postcards to:
//
//				T W Francisco
//				CB3290 Venable Hall
//				Department of Chemistry
//				UNC - Chapel Hill
//				Chapel Hill, NC  27599-3290
//
//	17Jul93,TWF
//	Modified:  19Nov93,TWF

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <graphics.h>
#include <math.h>

double findmax(double far m[1000][6],int col,int indmax);
double findmin(double far m[1000][6],int col,int indmax);

FILE *fil,*cfgfil;
int i,j,m,n,rowmax,colmax,DRV=DETECT,MOD=0,col1,col2,
	hxr=160,hxrM20=140,hyr=100,hyrM20=80,viddrv,vidmod;
int far ix[1000],iy[1000];
double far c[1000][6],x[1000],y[1000];
double xmax,ymax,xmin,ymin;
char *f[6],*cp[80],lin[80],s[6][80],cparm[6][80],*endptr;

void main(int argc, char *argv[])
{
	if (argc!=4) { printf("\nxygrf error:  # params wrong!\n"); exit(0); }

	if ((cfgfil=fopen("xygrf.cfg","rt"))==NULL)
		{ printf("\nxygrf error:  configuration file not found!\n"); exit(0); }

	i=0;
	fgets(lin,80,cfgfil);
	cp[i]=strtok(lin," ,");
	strcpy(cparm[i],cp[i]);
	do
	{
		i++;
		cp[i]=strtok('\0'," ,");
		strcpy(cparm[i],cp[i]);
	} while(cp[i]);

	fclose(cfgfil);

	viddrv=atoi(cparm[0]);
	vidmod=atoi(cparm[1]);

	switch (viddrv)
	{
		case 4  :	DRV=VGA; break;
		case 3 	:	DRV=HERCMONO; break;
		case 2  :	DRV=EGA; break;
		case 1 	:	DRV=MCGA; break;
		case 0  :	DRV=CGA; break;
	}

	switch (vidmod)
	{
		case 9		:	{ 	MOD=VGALO;
							hxr=320;
							hxrM20=hxr-20;
							hyr=100;
							hyrM20=hyr-20;
							break;
						}
		case 8		:	{	MOD=VGAMED;
							hxr=320;
							hxrM20=hxr-20;
							hyr=175;
							hyrM20=hyr-20;
							break;
						}
		case 7		:	{	MOD=VGAHI;
							hxr=320;
							hxrM20=hxr-20;
							hyr=240;
							hyrM20=hyr-20;
							break;
					}
		case 6		:	{	MOD=HERCMONOHI;
							hxr=360;
							hxrM20=hxr-20;
							hyr=174;
							hyrM20=hyr-20;
							break;
						}
		case 5		:	{	MOD=EGAHI;
							hxr=320;
							hxrM20=hxr-20;
							hyr=175;
							hyrM20=hyr-20;
							break;
						}
		case 4		:	{	MOD=EGALO;
							hxr=320;
							hxrM20=hxr-20;
							hyr=100;
							hyrM20=hyr-20;
							break;
						}
		case 3		:	{	MOD=MCGAMED;
							hxr=320;
							hxrM20=hxr-20;
							hyr=100;
							hyrM20=hyr-20;
							break;
						}
		case 2		:	{	MOD=MCGAHI;
							hxr=320;
							hxrM20=hxr-20;
							hyr=240;
							hyrM20=hyr-20;
							break;
						}
		case 1		:	{	MOD=CGAC0;
							hxr=160;
							hxrM20=hxr-20;
							hyr=100;
							hyrM20=hyr-20;
							break;
						}
		case 0		:	{	MOD=CGAHI;
							hxr=320;
							hxrM20=hxr-20;
							hyr=100;
							hyrM20=hyr-20;
							break;
						}
	}

	if ((fil=fopen(argv[1],"rt"))==NULL)
		{ printf("\nxygrf error:  fopen failed!\n"); exit(0); }

	rowmax=colmax=0;

	j=0;
	while(!feof(fil))
	{
		i=0;
		fgets(lin,80,fil);
		f[i]=strtok(lin," ,");
		strcpy(s[i],f[i]);
		do
		{
			i++;
			if (i>colmax) colmax=i;
			f[i]=strtok('\0'," ,");
			strcpy(s[i],f[i]);
		} while(f[i]);
		for (n=0;n<colmax;n++) c[j][n]=strtod(s[n],&endptr);
		j++;
		if (j>rowmax) rowmax=j;
	}

	fclose(fil);

	xmax=findmax(c,0,rowmax);
	ymax=findmax(c,1,rowmax);
	xmin=findmin(c,0,rowmax);
	ymin=findmin(c,1,rowmax);

	col1=atoi(argv[2]);
	col2=atoi(argv[3]);

	for(m=0;m<rowmax;m++)
	{
		if (abs(xmax)>abs(xmin))
		{
			if(xmax) x[m]=c[m][col1]/xmax;
				else x[m]=0.0;
		}
		else
		{
			if(xmin) x[m]=c[m][col1]/abs(xmin);
				else x[m]=0.0;
		}

		if (abs(ymax)>abs(ymin))
		{
			if(ymax) y[m]=c[m][col2]/ymax;
				else y[m]=0.0;
		}
		else
		{
			if(ymin) y[m]=c[m][col2]/abs(ymin);
				else y[m]=0.0;
		}
	}

	for(m=0;m<rowmax;m++)
	{
		ix[m]=floor(x[m]*hxrM20)+hxr;
		iy[m]=floor(hyr-y[m]*hyrM20);
	}

	initgraph(&DRV,&MOD,"");

	setpalette(0,1); setpalette(1,1);
	for (m=0;m<rowmax-1;m++) //circle(ix[m],iy[m],2);
	for (m=1;m<rowmax-1;m++) line(ix[m-1],iy[m-1],ix[m],iy[m]);
	while(!kbhit());
    getch();

	restorecrtmode();
} // xygrf.c


// function findmax
double findmax(double far m[1000][6],int col,int indmax)
{
	int l;
	double valmax;

	valmax=0.0;
	for (l=0;l<indmax;l++) if (m[l][col]>valmax) valmax=m[l][col];
	return(valmax);
}

// function findmin
double findmin(double far m[1000][6],int col,int indmax)
{
	int l;
	double valmin;

	valmin=1e6;
	for (l=0;l<indmax;l++) if (m[l][col]<valmin) valmin=m[l][col];
	return(valmin);
}
