/*****
This file is part of the Babel Program
Copyright (C) 1992-94 W. Patrick Walters and Matthew T. Stahl
The Babel Program is a product of the Dolata Research Group
Dept. of Chemistry
University of Arizona
Tucson, AZ 85721

For more information please contact :

babel@mercury.aichem.arizona.edu
--------------------------------------------------------------------------------

FILE : wrmacmod.c
AUTHOR(S) : Pat Walters
DATE : 2-93
PURPOSE : Routines to write a Macromodel file
******/


#include "bbltyp.h"

int 
  write_macromodel(FILE *file1, ums_type *mol)
{ 
  int i,j;
  int type_name;
  char temp_type[5];
  int result;

  fprintf(file1," %5d %6s      E = %7.3f KJ/mol\n",Atoms,Title,4.184*Energy);
  
  for(i = 1;i <= Atoms; i++)
  {
    if EQ(Type(i),"H")
      switch(Type(Connection(i,0))[0])
      {
      case 'N' :
	type_name = 43;
	break;
      case 'O' :
	type_name = 42;
	break;
	default :
	type_name = 41;
      }
    else
    {    
      result = get_output_type(i,"MMD",Type(i),temp_type,dummy);    
      type_name = atoi(temp_type);
    }
    fprintf(file1,"%4d",type_name);
    for (j = 0; j < 6; j ++)
    {
      fprintf(file1," %5d %1d",
	      Connection(i,j),BO(i,j));
    }
    fprintf(file1,"%10.4f %11.4f %11.4f\n",
	    X(i),
	    Y(i),
	    Z(i));
  }
  return(TRUE);
}

int 
get_bond_order(ums_type *mol, int start,int end)
{
  int i;
  
  if ((start == 0) || (end == 0))
    return(0);
  for (i = 0; i < Bonds; i++)
    if (((start == Start(i)) && (end == End(i))) ||
	((start == End(i)) && (end == Start(i))))
      return(Bond_order(i));
  return(0);
}
  
  
  
      









