/*****
This file is part of the Babel Program
Copyright (C) 1992-93 Arizona Board of Regents for the AI in Chemistry Lab
The Babel Program is a product of the Dolata Research Group
Dept. of Chemistry
University of Arizona
Tucson, AZ 85721

For more information please contact :

babel@mercury.aichem.arizona.edu
------------------------------------------------------------------------------

FILE : wrunichm.c
AUTHOR(S) : Pat Walters
DATE : 2-95
PURPOSE : Routines to write an Cray UniChem file
******/

#include "bbltyp.h"

int 
write_unichem(FILE *file1, ums_type *mol)
{ 
  int i;
  char type_name[5];
  int result;
  int num;

  fprintf(file1,"%s\n",Title);
  fprintf(file1,"%d\n",Atoms);
  for(i = 1;i <= Atoms; i++)
  {
    result = get_output_type(i,"XYZ",Type(i),type_name,all_caps);
    num = get_atomic_number(type_name);
    fprintf(file1,"%3d%15.5f%15.5f%15.5f\n",
	    num,
	    X(i),
	    Y(i),
	    Z(i));
  }
  return(TRUE);
}

  
      









