/*****
This file is part of the Babel Program
Copyright (C) 1992-94 W. Patrick Walters and Matthew T. Stahl
The Babel Program is a product of the Dolata Research Group
Dept. of Chemistry
University of Arizona
Tucson, AZ 85721

For more information please contact :

babel@mercury.aichem.arizona.edu
-------------------------------------------------------------------------------

FILE : rdmaccs.c
AUTHOR(S) : Matthew Stahl
DATE : 10-92
PURPOSE : routines to read the MACCS format
******/


#include "bbltyp.h"

static warning wstr;

int 
read_maccs3d(FILE *file1, ums_type *mol)
{
  char the_line[BUFF_SIZE];
  int i;
  int charge;
  long int prev,pos;
  double dummyd;
  int dummyi;
  char dummyc[100];

  prev = ftell(file1);
  do
  {
    fgets(the_line,sizeof(the_line),file1);
    if  (sscanf(the_line,"%lf%lf%lf%s%d%d%d%d%d%d",
	   &dummyd,&dummyd,&dummyd,dummyc,
	   &dummyi,&dummyi,&dummyi,&dummyi,&dummyi,&dummyi) == 10)
      break;
    prev = pos;
    pos = ftell(file1);
  } while (!check_for_eof(file1));

  if (check_for_eof(file1))
    fatal_error("Unable to find beginning of file");

  fseek(file1,prev,0);
  fgets(the_line,sizeof(the_line),file1);
  if (sscanf(the_line,"%d %d",&Atoms,&Bonds) != 2)
    fatal_error("Unable to find beginning of file");

  ShowProgress(Atoms,"Reading Atoms");
  initialize_ums(&mol);

  for (i = MIN_ATOM; i <= Atoms; i++)
  {
    UpdateProgress();
    fgets(the_line,sizeof(the_line), file1);
    sscanf(the_line,"%lf %lf %lf %s %*d %d",
	   &X(i),
	   &Y(i),
	   &Z(i),
	   Type(i),&charge);
    Charge(i) = (int) charge;
    clean_atom_type(Type(i));
  }

  for (i = MIN_ATOM; i <= Atoms; i++)
    switch ((int) Charge(i))
    {
    case 1:
      Charge(i) = 3.0;
      break;
    case 2:
      Charge(i) = 2.0;
      break;
    case 3:
      Charge(i) = 1.0;
      break;
    case 5:
      Charge(i) = -1.0;
      break;
    case 6:
      Charge(i) = -2.0;
      break;
    case 7:
      Charge(i) = -3.0;
      break;
    }
  
  for(i = 0;i < Bonds;i++)
  {
    fgets(the_line,sizeof(the_line), file1);
    sscanf(the_line,"%d %d %d",&Start(i),&End(i),&Bond_order(i));
  }

  dissect_connection_table(mol); 
  assign_types(mol);
  return(TRUE);
}
















