/*****
This file is part of the Babel Program
Copyright (C) 1992-94 W. Patrick Walters and Matthew T. Stahl
The Babel Program is a product of the Dolata Research Group
Dept. of Chemistry
University of Arizona
Tucson, AZ 85721

For more information please contact :

babel@mercury.aichem.arizona.edu
--------------------------------------------------------------------------------

FILE : rdpdb.c
AUTHOR(S) : Pat Walters
DATE : 10-92
PURPOSE : Routines to read a Brookhave Protien Data Bank file

******/
#include "bbltyp.h"

#define DELIMS "\t\n "

int 
read_pdb(FILE *file1, ums_type *mol)
{
  char pdb_line[BUFF_SIZE];
  int i = 0;
  int result;
  char temp_char;
  long int pos;
  int chain_num = 1;
  char res_num_str[5];
  char the_atm_id[5],the_res_name[5];
  
  pos = ftell(file1);
  while ((fgets(pdb_line,sizeof(pdb_line), file1) != NULL) && NOTEQn(pdb_line,"END",3))
  { 
    if (EQn(pdb_line,"ATOM",4) || EQn(pdb_line,"HETATM",6))
    {
      i++;
    }
  }
  fseek(file1,pos,0);
  Atoms = i;
  initialize_ums(&mol);
  initialize_residues(&mol);
  ShowProgress(Atoms,"Reading Atoms");
	 
  i = MIN_ATOM;
  while ((fgets(pdb_line,sizeof(pdb_line), file1) != NULL) && NOTEQn(pdb_line,"END",3))
  {
    if (EQn(pdb_line,"TER",3))
      chain_num++;
    if (EQn(pdb_line,"ATOM",4) || EQn(pdb_line,"HETATM",6))
    {
      UpdateProgress();
      Type(i)[0] = pdb_line[12];
      Type(i)[1] = pdb_line[13];
      if ((isspace(pdb_line[12])) || (isdigit(pdb_line[12])) || (pdb_line[12] == 'A') ||
	  (pdb_line[12] == 'N'))
      {
	Type(i)[0] = Type(i)[1];
	Type(i)[1] = '\0';
      }
      if (EQn(pdb_line,"ATOM",4) && (Type(i)[0] == 'H'))
	Type(i)[1] = '\0';
      if (EQn(pdb_line,"ATOM",4) && (Type(i)[0] == 'O'))
      {
	temp_char = toupper(Type(i)[1]);
	if (temp_char != 'S')
	  Type(i)[1] = '\0';
      }
      if (EQn(pdb_line,"ATOM",4) && (Type(i)[0] == 'C'))
      {
	temp_char = toupper(Type(i)[1]);
	if (strchr("ADEFLORSU",temp_char) == NULL)
	  Type(i)[1] = '\0';
      }
      clean_atom_type(Type(i));
      if (((Type(i)[0]) == 'U') && (EQn(&pdb_line[14],"NK",2)))
      {
	strcpy(Type(i),"UNK");
      }
      ChainNum(i) = chain_num;
      my_strncpy(AtmId(i),&pdb_line[12],4);
      strcpy(the_atm_id,gettoken(AtmId(i),DELIMS,1));
      my_strncpy(ResName(i),&pdb_line[17],3);
      if (count_tokens(ResName(i),DELIMS) > 0)
	strcpy(the_res_name,gettoken(ResName(i),DELIMS,1));
      else
	strcpy(the_res_name,"UNK");
      if (isdigit(pdb_line[25]))
	my_strncpy(res_num_str,&pdb_line[23],3);
      else
	strcpy(res_num_str,"1");
      if (Type(i)[0] == 'A')
      {
	fix_A_type(Type(i),the_atm_id,the_res_name);
      }
      ResNum(i) = my_atoi(res_num_str);
      sscanf(&pdb_line[30],"%lf",&X(i));
      sscanf(&pdb_line[38],"%lf",&Y(i));
      sscanf(&pdb_line[46],"%lf",&Z(i));
      i ++;
    }
  }

  result = assign_radii(mol);  
  result = assign_pdb_bonds(mol);
  pos = ftell(file1);
  dissect_connection_table(mol);
  process_connect_records(file1,mol); 
  fseek(file1,pos,0);
  check_bonds(mol);
  result = assign_types(mol);
  result = build_connection_table(mol);
  assign_bond_order(mol);
  return(TRUE);  
}

void fix_A_type(char *type, char *id, char *res_type)
{
  if (EQn(id,"AD1",3) && (EQn(res_type,"ASN",3) || EQn(res_type,"N",1)))
    strcpy(type,"O");
  else
    if (EQn(id,"AD2",3) && (EQn(res_type,"ASN",3) || EQn(res_type,"N",1)))
      strcpy(type,"N");
  else
    if (EQn(id,"AE1",3) && (EQn(res_type,"GLN",3) || EQn(res_type,"Q",1)))
      strcpy(type,"O");
  else
    if (EQn(id,"AE2",3) && (EQn(res_type,"GLN",3) || EQn(res_type,"Q",1)))
      strcpy(type,"N");
  else
    if (EQn(id,"AD1",3) && (EQn(res_type,"HIS",3) || EQn(res_type,"H",1)))
      strcpy(type,"N");
  else
    if (EQn(id,"AE1",3) && (EQn(res_type,"HIS",3) || EQn(res_type,"H",1)))
      strcpy(type,"C");
  else
    if (EQn(id,"AE2",3) && (EQn(res_type,"HIS",3) || EQn(res_type,"H",1)))
      strcpy(type,"N");
  else
    if (EQn(id,"AD2",3) && (EQn(res_type,"HIS",3) || EQn(res_type,"H",1)))
      strcpy(type,"C");
}

void process_connect_records(FILE *file1, ums_type *mol)
{
  char pdb_line[BUFF_SIZE];  
  int con_atm;
  int tokens;
  int i,j;

  while (fgets(pdb_line,sizeof(pdb_line), file1) != NULL)
  {
    if EQn(pdb_line,"CONECT",6)
    {
      pdb_line[61] = '\0';
       tokens = count_tokens(pdb_line," ");
      sscanf(&pdb_line[7],"%d",&i);
      for (j = 0; j < (tokens - 2); j++)
      {
	sscanf(&pdb_line[12 + j * 5],"%d",&con_atm);
	if  ((i <= Atoms) && (!bonded(mol,i,con_atm)))
	{
	  add_bond(mol,i,con_atm);
	}
      }
    }
  }
}

void add_bond(ums_type *mol, int i, int j)
{
  Connection(i,Valence(i)) = j;
  Connection(j,Valence(j)) = i;
  Valence(i)++;
  Valence(j)++;
}


  


