/*****
This file is part of the Babel Program
Copyright (C) 1992-94 W. Patrick Walters and Matthew T. Stahl
The Babel Program is a product of the Dolata Research Group
Dept. of Chemistry
University of Arizona
Tucson, AZ 85721

For more information please contact :

babel@mercury.aichem.arizona.edu
-----------------------------------------------------------------------------
*/
#include "bbltyp.h"

void
  get_vectors(ums_type *start,ums_type *end,vect_type *vect[],int increment)
{
  int i;
  
  if (increment == 0)
    increment = 1;
    
  for (i = 1;i <= start->num_atoms;i++)
  {
    (*vect[i]).x = start->atoms[i].point.x - end->atoms[i].point.x;
    (*vect[i]).y = start->atoms[i].point.y - end->atoms[i].point.y;
    (*vect[i]).z = start->atoms[i].point.z - end->atoms[i].point.z;
  }

  for (i = 1;i <= start->num_atoms;i++)
  {
    (*vect[i]).x  = (*vect[i]).x/(double) increment;
    (*vect[i]).y  = (*vect[i]).y/(double) increment;
    (*vect[i]).z  = (*vect[i]).z/(double) increment;
  }
}

void
  add_step(ums_type *mol,vect_type *vect[])
{
  int i;
  
  for (i = 1;i <= Atoms;i++)
  {
    X(i) += -(*vect[i]).x;
    Y(i) += -(*vect[i]).y;
    Z(i) += -(*vect[i]).z;
  }
}
