/*****
This file is part of the Babel Program
Copyright (C) 1992-94 W. Patrick Walters and Matthew T. Stahl
The Babel Program is a product of the Dolata Research Group
Dept. of Chemistry
University of Arizona
Tucson, AZ 85721

For more information please contact :

babel@mercury.aichem.arizona.edu
--------------------------------------------------------------------------------

FILE : wrsybyl.c
AUTHOR(S) : Jussi Eloranta <eloranta@tukki.jyu.fi>
	    University of Jyvdskyld, Finland
DATE : 12-93
PURPOSE : Write a SYBYL mol2 file
******/

#include "bbltyp.h"

int write_sybyl(FILE *file1, ums_type *mol)
{
  int i;
  char temp_type[5];
  char ele[5];
  char bond_ord[3];
  pdb_type_rec *pdb_types;

  pdb_types = (pdb_type_rec *)malloc((Atoms + 1) * sizeof(pdb_type_rec));

  fprintf(file1, "@<TRIPOS>MOLECULE\n");
  fprintf(file1, "****\n");
  fprintf(file1, " %d %d 0 0 0\n", Atoms, Bonds);
  fprintf(file1, "SMALL\n");
  fprintf(file1, "NO_CHARGES\n");
  fprintf(file1, "\n\n");

  fprintf(file1, "@<TRIPOS>ATOM\n");
  for(i = 1; i <= Atoms; i++) {
    get_output_type(i,"SYB",Type(i),temp_type,dummy);
    get_element_type(mol,i,ele);

    strcpy(pdb_types[i].name,ele);
    assign_pdb_number(pdb_types,i);

    fprintf(file1,"%4d%4s%2s%-3d%9.3f%9.3f%9.3f%2s%-5s\n",
	    i,"",ele,pdb_types[i].number, X(i), Y(i), Z(i),"",temp_type);
  }
  fprintf(file1, "@<TRIPOS>BOND\n");
  for(i = 0; i < Bonds; i++)
  {
    if (Bond_order(i) != 5)
      sprintf(bond_ord,"%d",Bond_order(i));
    else
      strcpy(bond_ord,"ar");
    fprintf(file1, "%4d%4d%4d%3s%2s\n", i+1, Start(i), End(i),"",bond_ord);
  }
  return(TRUE);
}










