#Filter to select HIV protease inhibitors from the WDI database

##################################
sub is_sdf_record_kept
{
	my $sdf_entry = shift ;
	my $record_number = shift ;
	
	defined $sdf_entry || die "Assertion failed" ;
	
	#First, filter out all the entries for which the number of atoms is 0
	my $n_atom = $sdf_entry->{'molecule'}->{'number_of_atoms'} ;
	defined $n_atom || die "Assertion failed: number_of_atoms is not defined" ;
	if ( $n_atom <= 0 ) { return 0; }
	
	my $value_pt = $sdf_entry->data_for_field_name("PT");
	my $value_ma = $sdf_entry->data_for_field_name("MA");
	return
		($value_pt =~ /HIV.*protease/i) || ($value_ma =~ /HIV.*protease/i) ; 
}
1;
##################################
