require Table ;
require bb_misc ;

# HISTORY :
# Creation BB Dec 15 1998
#Note : don't use this file as an example to make your own table subclass.
#It hasn't been refactored yet.
#It is better to have a look at CSV.pm and SSV.pm



#Example of an input file:

my $__example_input =q{
SMILES : C12(O)CC(CNC(=S)NCc3ccc(O)c(OC)c3)=CC4C5OC7(Cc6ccccc6)OC4(C1C=C(C)C2(
         =O))CCC5(O7)C(=C)C
CHEM   : 81
MOL FOR: C36 H40 N2 O7 S1 
MOL WT : 644.79
-------+-----+--------------------------------------------+---------+--------
 TYPE  | NUM |        LOGKOW FRAGMENT DESCRIPTION         |  COEFF  |  VALUE 
-------+-----+--------------------------------------------+---------+--------
 Frag  |  3  |  -CH3    [aliphatic carbon]                | 0.5473  |  1.6419
 Frag  |  6  |  -CH2-   [aliphatic carbon]                | 0.4911  |  2.9466
 Frag  |  3  |  -CH     [aliphatic carbon]                | 0.3614  |  1.0842
 Frag  |  1  |  C     [aliphatic carbon - No H, not tert] | 0.9723  |  0.9723
 Frag  |  1  |  =CH2    [olefinic carbon]                 | 0.5184  |  0.5184
 Frag  |  5  |  =CH- or =C<  [olefinc carbon]             | 0.3836  |  1.9180
 Frag  |  1  |  -OH     [hydroxy, aliphatic attach]       |-1.4086  | -1.4086
 Frag  |  3  |  -O-     [oxygen, aliphatic attach]        |-1.2566  | -3.7698
 Frag  |  2  |  -NH-    [aliphatic attach]                |-1.4962  | -2.9924
 Frag  | 12  |  Aromatic Carbon                           | 0.2940  |  3.5280
 Frag  |  1  |  -OH     [hydroxy, aromatic attach]        |-0.4802  | -0.4802
 Frag  |  1  |  -O-   [oxygen, one aromatic attach]       |-0.4664  | -0.4664
 Frag  |  1  |  -NC(=S)N-  [thiourea]                     | 1.2905  |  1.2905
 Frag  |  3  |  -tert Carbon  [3 or more carbon attach]   | 0.2676  |  0.8028
 Frag  |  1  |  -C(=O)-   [carbonyl, olefinic attach]     |-1.2700  | -1.2700
 Factor|  3  |  C-O-C-O-C  structure  correction          | 0.5036  |  1.5108
 Factor|  2  |  Fused aliphatic ring unit correction      |-0.3421  | -0.6842
 Factor|  1  |  -C-C(=O)-C-OH  structure correction       | 0.9178  |  0.9178
 Factor|  1  |  Ring reaction ->  alkyloxy ortho to -OH   |-0.2560  | -0.2560
 Const |     |  Equation Constant                         |         |  0.2290
-------+-----+--------------------------------------------+---------+--------
                                                         Log Kow   =   6.0327

};



#**************************************************************************#
package LogKow_line ;
#**************************************************************************#
	@ISA = qw( AbstractLineFields );

	#@fields_names = ('fields') ;
	@fields_names = () ;

	eval( ${HashObject'new_SubClass_String} ) ;

#--------------------------------------------------------------------------#

sub readFromInput {
	my $class = shift ;
	my $self = new($class) ;
	
	my @fields = () ;

	
	local $_ = <STDIN> ;
	
	if(! /SMILES :\s*(.+)$/ )
	{
		return undef ;
	}
	
	my $smiles = $1 ;
	my $chem ;
	my $log_kow ;
	my $details ;
		
	CHEM: while( <STDIN>)
	{
		if(/^\n$/) {return undef ;}
		if(/^   +(\S+)/) # more smiles string?      
		{
			$smiles = $smiles . "\n". $1 ;
			next ;
		}
		if( /^CHEM   :(.+)\n$/ )
		{
			$_ = $1 ;
			s/^\s+//;
			s/\s+$//;
			$chem = $_ ;
			last CHEM;
		}
	}
	
	DETAILS:while( <STDIN>)
	{	
		if(/^\n$/) {return undef ;}
		if(/Log Kow   =(.+)\n$/)
		{
			$_ = $1 ;
			s/^\s+//;
			s/\s+$//;
			$log_kow = $_ ;
			last DETAILS;
		}
		
		$details .= $_ ;
	}
	
	$_ =<STDIN> ; #remove extra line
	$_ =<STDIN> ; #remove extra line
					 
	
	$self->{'fields'} = [$smiles, $chem, $log_kow, $details]  ;
	
	$self ;
}


			

#**************************************************************************#
package LogKow_table ;

# The first line contains the labels
#**************************************************************************#
	@ISA = qw( AbstractTable );

#	@fields_names = (
#		'lines',  #	\@array of LogKow_line
#		'labels', # predefined hard coded labels
#		'ids') ;
	@fields_names = ();

	eval( ${HashObject'new_SubClass_String} ) ;

#--------------------------------------------------------------------------#
sub readFromInput
{

	my $class = shift ;
	my $self = new($class) ;
	
	my $n_lines = 0 ;

	
	my $row =  LogKow_line->readFromInput();
	
	if( !defined $row ){
		warn "Can't read input";
		return undef ;
	}
	push(@lines, $row) ;
	$n_lines ++ ;
	
	while(1)
	{
		my $row = LogKow_line->readFromInput();
		$n_lines ++ ;
		if( !defined $row)
		{
			last;
		}
				
		push(@lines, $row);
	}
		
	$self->{'lines'} = \@lines ;
	$self->{'labels'} = new AbstractLineFields ;
	$self->{'labels'}->{'fields'} = ['smiles', 'chem', 'log_kow', 'details'] ;
	
	$self ;
	

}	

#--------------------------------------------------------------------------#

	

1;

	
