#!/usr/bin/perl 
#!/usr/bin/perl -I~/lib/perl

$Mylibs = "/home/brunob/lib/perl /home/bruno/lib/perl";
push(@INC, split(/\s+/, $Mylibs));



use Getopt::Long ;
use File::Basename ;
$me = basename( $0, ".perl") ;

$ret = GetOptions('help', 'match_key=s', 'table_file=s', 'multi');
$ret || die "Options are not correct. Try $me -help\n" ;

if( defined($opt_help)  ) {
	usage() ;
} 



################################################################################
#Options:
#	$match_key : the label used to match the entries of the SDF files and the properties table

my $match_key = $opt_match_key ;
defined $match_key || die "Undefined option. Try $me -help\n";

my $table_file_name = $opt_table_file ;
defined $table_file_name || die "Undefined option. Try $me -help\n";

################################################################################
#Librairies:

require 5.000 ;	# This is a perl 5.0 script

require MDL_sdf ;
require LogKow ;


################################################################################


#read the whole table
$table = LogKow_table->readFromInputFile($table_file_name) ;

$table->renameLabel( 'chem', $match_key) || die "Assertion failed";
$table->renameLabel( 'details', 'LogKow_details') || die "Assertion failed";

################################################################################


$record = 0 ;

#foreach $sdf_entry read from from STDIN
FOR_EACH_SDF_ENTRY: while( 1 )
{ 

	my $sdf_entry = MDL_sdf->readFromInput() ;
	defined $sdf_entry || last FOR_EACH_SDF_ENTRY ;  #end of the loop

	$record ++ ; #just to keep track of the record number
	
	
	#get the value of its key ($match_key)
	my $sdf_id = $sdf_entry->data_for_field_name($match_key) ;
	if( ! defined $sdf_id )
	{
		warn "The key $match_key is not defined for entry $record. Skipping\n";
		next FOR_EACH_SDF_ENTRY;
	}else
	{
		printf STDERR "%4d %s => %s\n", $record, $match_key, $sdf_id ;
		#get the list of new properties from table using the SDF entry's key
		
		$propertiesDict = $table->getProperties( $match_key , $sdf_id) ;
		#$propertiesDict is a ref to a hash table.

		if( ! defined %$propertiesDict )
		{
			warn "$match_key => $sdf_id: data not available in the table. Skipping\n";
			next FOR_EACH_SDF_ENTRY;
		}
		
		if(defined $opt_multi) 
		{	
			my $props = $table->get_multi_Properties( $match_key , $sdf_id) ;
			my $i = 0 ;
			foreach $propertiesDict (@$props)
			{
				$i++ ;
				#add all the new properties
				$sdf_entry->addReplaceProperties( $propertiesDict);
				#write the sdf entry
				$sdf_entry->write();
				printf STDERR "%d ", $i ;
				
			}
			print STDERR "\n";	
				
		
		}else #No option #single property row
		{	

			#add all the new properties
			$sdf_entry->addReplaceProperties( $propertiesDict);
			#write the sdf entry
			$sdf_entry->write();
	
		}
	}
	

	
}

################################################################################

sub usage()
{
	die( 
	"Example usage : $me [-help] -match_key NSC -table_file logP.logkow < input.sdf > output.sdf
$me reads a SDF file (MDL format), adds properties from a logkow file and print out the new SDF file. The logkow input file is an output file from KOWIN 1.63

Options:
	-match_key: the label used to match the entries of the SDF files and the properties table

	-table_file: the file name of the properties table

    -multi: if the table contains more than one entry for the match key, 
    the output will contain several entries (with the same the chemical structure)

Notes : 
	- Options can be abbreviated as long as they are unambiguous.
	- $me needs librairies from $Mylibs
	- The output file is compatible with ChemFinder, Cactus's csbr, ...
\n") ;
}
