#!/usr/local/bin/perl

#This is a filter to preprocess NCI 
	use strict ;
	my $N_values = 6 ;

	my @lines = () ;
	
	my $n_lines = 0 ;

	local $_ = <STDIN> ;
	chomp ; #remove new line char
	s/\s+,/,/g; #remove padding space
	my @header =  split(",", $_ );
	
	if( !defined @header ){
		warn "Can't read input";
		return undef ;
	}
#NSC,HiConc,ConcUnit,Flag,EC50,NumExp
	if( $header[ $[ ] ne 'NSC' || $#header  !=  $N_values - 1 + $[)
	{
		die "Wrong input";
	}
	
	#Print the header:
	printf("%s,%s\n", $header[ $[ ], $header[ 4 + $[ ]) ;
	
	my $current_nsc = undef ;
	my $first = 1 ;
	my $data = '' ;
	
#Note this code is not as clean as I would like it to be
	
	while(<STDIN>)
	{
		s/\s+,/,/g; #remove padding space
		my ($nsc) =/^\s*(\d+)\b/ ; #get NSC
		s/^\s*(\d+)\s*,// ; #remove NSC from line
		
		if( $first )
		{
			$first = 0 ;
			$current_nsc = $nsc ; #init $current_nsc for the first time
		}
		if( $nsc == $current_nsc )
		{
			$data .= $_ ; #append the data
		} else
		{	
			print_transformed_line($current_nsc, $data) ; 
		
			$n_lines ++ ;			
			
			#Create a new entry
			$data = $_ ;
			$current_nsc = $nsc ;

		}

			
	}
#Save last entry:
	if( $n_lines > 1 )		
	{
		print_transformed_line($current_nsc, $data) ; 
	}
		


	
#-----------------------------------------------------------------#
sub print_transformed_line
{
	my $nsc = shift ;
	my $data = shift ;
	
	defined( $nsc ) && defined($data) || die "Undefined arguments";
	
	chomp( $data) ;
	$data =~ s/\n/##/g;
	$data =~ s/\,/\t/g;
	printf("%s,%s\n", $current_nsc, $data) || die "Write error" ;
}		
