#!/usr/bin/perl

require 5.000 ;	# This is a perl 5.0 script

use Getopt::Long ;
use File::Basename ;
$me = basename( $0, ".perl") ;

$ret = GetOptions('help', 'prop1=s', 'prop2=s');
$ret || die "Options are not correct. Try $me -help\n" ;

if( defined($opt_help)  ) { 
	die( "Example usage : $me [-help] -prop1 page -prop2 MOL_ID < input.sdf > out_put.sdf
$me copy the selected property (e.g page ) to the dest property (e.g prop2).

Note : Options can be abbreviated as long as they are unambiguous.
\n") ;

}

require MDL_sdf ;

defined $opt_prop1 && defined $opt_prop2 || die "Undefined option\n";

#-----------------------------------------------------#

$RecordsRead = 0 ;
$RecordsWritten = 0 ;
FOR_EACH_SDF_ENTRY: while( 1 )
{ 

	my $sdf_entry = MDL_sdf->readFromInput() ;
	defined $sdf_entry || last FOR_EACH_SDF_ENTRY ;  #end of the loop

	$RecordsRead ++ ;
	
	my $data = $sdf_entry->data_for_field_name($opt_prop1) ;
	
	if( !defined $data)
	{
		 warn "Undefined data for record no.$Record. Skipping\n" ;
	}else
	{
		$propertiesDict = {$opt_prop2 => $data} ;
		$sdf_entry->addReplaceProperties( $propertiesDict);
	}
	
	$sdf_entry->write();
	$RecordsWritten++;
		 	
}

printf STDERR "%d records read; %d records written\n", $RecordsRead, $RecordsWritten;

