#!/usr/local/bin/perl


require 5.000 ;	# This is a perl 5.0 script

use Getopt::Long ;
use File::Basename ;
$me = basename( $0, ".perl") ;

$ret = GetOptions('help', 'property_name=s');
$ret || die "Options are not correct. Try $me -help\n" ;

if( defined($opt_help)  ) { 
	die( "Example usage : $me [-help] -property_name NSC < input.sdf > list.txt
$me reads an MDL SDF file and extracts one or more properties.
-property_name option can also be a string, e.g. 'compound nickname KI log_kow' , where all property names are separated by one or more blank space.

Thus, for this script, property names may not contain blank spaces.

Note : Options can be abbreviated as long as they are unambiguous.
\n") ;

}


require MDL_sdf ;

defined $opt_property_name || die "Undefined option\n";
$opt_property_name =~ s/^\s+// ;
$opt_property_name =~ s/s+$// ;

@properties = split( /\s+/, $opt_property_name) ;
$#properties >= 0 || die "Incorrect properties";

#-----------------------------------------------------#

FOR_EACH_SDF_ENTRY: while( 1 )
{ 
	my @line =() ;
	#Read data from STDIN and create one object of type MDL_sdf
	my $sdf_entry = MDL_sdf_non_parsed_molecule->readFromInput() ;
	defined $sdf_entry || last FOR_EACH_SDF_ENTRY ;  #end of the loop

	foreach $prop (@properties)
	{
		my $data = $sdf_entry->data_for_field_name($prop) ;
	
		if( !defined $data)
		{	
			 warn "Undefined data for $prop\n" ;
		 	$data = "undef" ;
		}
		push(@line , $data) ;
	}
	
	print( join( "\t", @line), "\n") || die "Write error";

}


