#!/usr/local/bin/perl


require 5.000 ;	# This is a perl 5.0 script

use Getopt::Long ;
use File::Basename ;
my $me = basename( $0, ".perl") ;

#my($opt_help, $opt_min, $opt_max, $opt_n,$opt_seed);

my $ret = GetOptions('help', 'min:i', 'max:i', 'n:i' , 'seed:i');
$ret || die "Options are not correct. Try $me -help\n" ;


my $Min = 1 ;
my $Max = 100 ;
my $N = 10 ;


if( defined($opt_help)  ) { 
	die( "Usage : $me [-help] [-min $Min] [-max $Max] [-n $N] [-seed timenumber]
$me generates a list of n random number (integer) ranging from min to max.
Useful to select random entries from a SDF file with the help of select_sdf.

Note : Options can be abbreviated as long as they are unambiguous.
\n") ;

}

if( ! defined $opt_min )
{
	$opt_min = $Min;
}
if( ! defined $opt_max )
{
	$opt_max = $Max;
}
if( ! defined $opt_n )
{
	$opt_n = $N;
}


if( defined $opt_seed )
{
	srand(  $opt_seed );
}


$opt_min < $opt_max || die "The min value must be smaller than the max value";
$opt_n > 0 || die "The number of random values must be > 0" ;

for( 1.. $opt_n)
{
	my $new_val =  rand() *( $opt_max - $opt_min)+ $opt_min ;
	
	($new_val >= $opt_min && $new_val <= $opt_max) || die "Assertion failed";
	
	printf( "%d\n", $new_val  ) || die "Write error";

}
