PERL = perl

all:

	cat version
	uname -a ; date
	$(PERL) -v
	#______________________________________
	
	$(PERL) test_stdin_csv  < sample.csv
	$(PERL) test_csv > temp
	diff test_csv.out temp
	$(PERL) test_quick_csv > temp
	diff test_csv.out temp
	$(PERL) add_prop_sdf -match NSC -table sample.csv < sample.sdf > temp
	diff temp new.sdf
	$(PERL) add_prop_sdf -match NSC -table sample2.csv < sample.sdf > temp
	diff temp new.sdf	
	$(PERL) add_prop_sdf -multi -match NSC -table sample2.csv < sample.sdf > temp
	diff temp new.sdf

	$(PERL) test_ssv > temp
	diff temp test_ssv.out 
	$(PERL) test_atom_list_line > temp
	diff temp test_atom_list_line.out
	
	$(PERL) test_molecule  > temp
	diff temp test_molecule.out
	
	$(PERL)  test_3d_query > temp
	diff temp test_3d_query.out
	
	$(PERL) test_sdf_fields < sdf_fields.txt > temp
	diff temp sdf_fields.txt

	$(PERL) test_remove_sdf_fields < sdf_fields.txt > temp
	diff temp remove_sdf_fields.txt

	$(PERL) test_sdf < v2000.sdf > temp
	diff temp v2000.sdf
	
	time $(PERL) test_sdf < nci_demo.sdf > temp
	diff temp nci_demo_2.sdf
	
	time $(PERL) test_fast_sdf < nci_demo.sdf > temp
	diff temp nci_demo.sdf
	
	
	$(PERL) test_sdf < nci_test.sdf > temp 
	diff temp nci_test_2.sdf
	
	$(PERL) test_remove_sdf_fields2 < sample.sdf > temp 
	diff temp test_remove_sdf_fields2.out
	
	$(PERL) test_sdf < sample_pkc.sdf > temp
	diff temp sample_pkc_2.sdf

	$(PERL) test_sdf < sample_atom_list_block.sdf > temp
	diff temp sample_atom_list_block_2.sdf

	$(PERL) test_fast_sdf < sample_atom_list_block.sdf > temp
	diff temp sample_atom_list_block_2.sdf

	$(PERL) zero_sdf < 348696.sdf > temp
	diff temp 348696_0d.sdf


	$(PERL) extract_prop_sdf -prop NSC < sample_nci_demo.sdf > temp
	diff temp sample_nci_demo_nsc.txt

	$(PERL) rem_nph < sample_pkc.sdf > temp
	diff temp sample_pkc_no_h.sdf
	
	$(PERL) copy_prop_sdf -prop1 page -prop2 MOL_ID < sample_extra1.sdf > temp
	diff copy_prop_sdf.out temp
	
	$(PERL) select_sdf -start 3 -end 10 < sample_nci_demo.sdf > temp
	diff select_sdf_test1.out temp
	
	$(PERL) select_sdf -start 3 -end 10 -not < sample_nci_demo.sdf > temp
	diff select_sdf_test1_not.out temp

	$(PERL) select_sdf -seqfile select_sdf_test.seq < sample_nci_demo.sdf > temp
	diff select_sdf_test1.out temp

	$(PERL) select_sdf -seqfile select_sdf_test.seq -not < sample_nci_demo.sdf > temp
	diff select_sdf_test1_not.out temp


	$(PERL) select_sdf -labelfile select_nsc.labels < nci_test.sdf > temp
	diff select_sdf_test2.out temp

	$(PERL) select_sdf -labelfile select_nsc.labels -not < nci_test.sdf > temp
	diff select_sdf_test2_not.out temp


	$(PERL) select_sdf -labelfile select_nsc.labels -property_name NSC < nci_test.sdf > temp
	diff select_sdf_test2.out temp

	$(PERL) select_sdf -labelfile select_nsc.labels -property_name NSC -not < nci_test.sdf > temp
	diff select_sdf_test2_not.out temp

	$(PERL) select_sdf -perlfile sel_3_10.pl < sample_nci_demo.sdf > temp
	diff select_sdf_test1.out temp
	
	$(PERL) select_sdf -perlfile sel_3_10.pl -not < sample_nci_demo.sdf > temp
	diff select_sdf_test1_not.out temp
	
	$(PERL) shuffle_ct -seed 1 -n 2 < nci_test_2.sdf > temp
	#diff temp nci_test_2_shuffle.sdf

	$(PERL) append_sdf -prop NSC sample.sdf sample.sdf sample.sdf > temp
	diff temp append_sdf_test1.out
	
	$(PERL) append_sdf -prop NSC sample.sdf sample.sdf sample.sdf > temp
	diff temp append_sdf_test1.out
	
	$(PERL) sort_sdf -prop MolWeight <nci_demo.sdf  > temp
	diff temp sort_sdf_test1.out
	#Note: on some machine, the sort is different, but still valid 
	#This happens for equal values

	$(PERL) gen_rnd -seed 10


	$(PERL) test_logkow > temp
	diff temp sample_logkow.out

	

	$(PERL) test_logkow > temp
	diff temp sample_logkow.out


	$(PERL)  nciscreen2csv < sample_nci_lc50.txt >sample_nci_lc50.csv
	$(PERL)  test_nci_screen > temp
	diff temp test_nci_screen.out
	
	$(PERL)  nciscreen2csv < sample_nci_lc50.txt >sample_nci_lc50.csv
	$(PERL) add_prop_sdf -match NSC -table sample_nci_lc50.csv -perlclass NCI_screen< sample_nci_demo.sdf > temp
	diff temp add_prop_sdf_nci.out
	
	$(PERL) add_prop_sdf -match NSC -table sample_nci_lc50.csv -perlclass NCI_screen.pm < sample_nci_demo.sdf > temp
	diff temp add_prop_sdf_nci.out
	
	$(PERL) add_prop_sdf -match NSC -table sample_nci_lc50.csv -perlclass NCI_screen -noskip -silent < sample_nci_demo.sdf > temp
	diff temp add_prop_sdf_nci_noskip.out
	
	
clean:
	rm -f *.copy *.bak *.bck *~ */*.copy */*.bak */*.bck */*~ temp

dist:
	make clean
	(cd .. ; tar cf - SDF_toolkit | compress -v > `cat SDF_toolkit/version`.tar.Z )
	
