#!/usr/local/bin/perl

use Getopt::Long ;
use File::Basename ;
$me = basename( $0, ".perl") ;

$ret = GetOptions('help', 'match_key=s',  'noskip', 'perlclass:s', 'table_file=s', 'multi');
$ret || die "Options are not correct. Try $me -help\n" ;

if( defined($opt_help)  ) {
	die( "Example usage : $me [-help]  < cancer_screened_tgi_a99 > cancer_screened_tgi_a99.csv
$me read a NCI screen cell data and transforms it into a CSV file with one line per molecular structure.

If this file is modified, one should also change the package NCI_screen.pm

Note : Options can be abbreviated as long as they are unambiguous.
\n") ;
} 

################################################################################


#This is a filter to preprocess NCI 
	use strict ;
	my $N_values = 10 ;

	my @lines = () ;
	
	my $n_lines = 0 ;

	local $_ = <STDIN> ;
	chomp ; #remove new line char
	s/\s+,/,/g; #remove padding space
	my @header =  split(",", $_ );
	
	if( !defined @header ){
		warn "Can't read input";
		return undef ;
	}
#NSC,CONCUNIT,LCONC,PANEL,CELL,PANELNBR,CELLNBR,NLOGGI50,INDN,TOTN	
	if( $header[ $[ ] ne 'NSC' || $#header  !=  $N_values - 1 + $[)
	{
		warn "Wrong input";
		return undef ;
	}
	
	#Print the header:
	printf("%s,%s\n", $header[ $[ ], $header[ 7 + $[ ]) ;
	
	my $current_nsc = undef ;
	my $first = 1 ;
	my $data = '' ;
	
	
	while(<STDIN>)
	{
		s/\s+,/,/g; #remove padding space
		my ($nsc) =/^\s*(\d+)\b/ ; #get NSC
		s/^\s*(\d+)\s*,// ; #remove NSC from line
		
		if( $first )
		{
			$first = 0 ;
			$current_nsc = $nsc ; #init $current_nsc for the first time
		}
		if( $nsc == $current_nsc )
		{
			$data .= $_ ; #append the data
		} else
		{	
			print_transformed_line($current_nsc, $data) ; 
		
			$n_lines ++ ;			
			
			#Create a new entry
			$data = $_ ;
			$current_nsc = $nsc ;

		}

			
	}
#Save last entry:
	if( $n_lines > 1 )		
	{
		print_transformed_line($current_nsc, $data) ; 
	}
		


	
#-----------------------------------------------------------------#
sub print_transformed_line
{
	my $nsc = shift ;
	my $data = shift ;
	
	defined( $nsc ) && defined($data) || die ;
	
	chomp( $data) ;
	$data =~ s/\n/##/g;
	$data =~ s/\,/\t/g;
	printf("%s,%s\n", $current_nsc, $data) || die "Write error" ;
}		
