#!/usr/bin/perl

require 5.000 ;	# This is a perl 5.0 script

use Getopt::Long ;
use File::Basename ;
$me = basename( $0, ".perl") ;

$ret = GetOptions('help');
$ret || die "Options are not correct. Try $me -help\n" ;

if( defined($opt_help)  ) { 
	die( "Usage : $me [-help] ...
$me remove non polar hydrogens (connected to a C) from an MDL SDF file.
Stereo bond hydrogens are not removed.

Note : Options can be abbreviated as long as they are unambiguous.
\n") ;

}

require MDL_sdf ;


#-----------------------------------------------------#

FOR_EACH_SDF_ENTRY: while( 1 )
{ 

	my $sdf_entry = MDL_sdf->readFromInput() ;
	defined $sdf_entry || last FOR_EACH_SDF_ENTRY ;  #end of the loop

	my $mol = $sdf_entry->{'molecule'};

	$mol->remove_non_polar_hydrogens() ;
	#$mol->inspect();
	$sdf_entry->write() ;
	

}


