#!/usr/local/bin/perl

require 5.000 ;	# This is a perl 5.0 script
use Getopt::Long ;
use File::Basename ;
$me = basename( $0, ".perl") ;

$ret = GetOptions('help');
$ret || die "Options are not correct. Try $me -help\n" ;

if( defined($opt_help)  ) {
		die( 
	"Example usage : $me [-help]  < input.sdf > output.sdf
$me reads a SDF file (MDL format),  remove charges (make them 0) from the connection table only (M  CHG  is not changed).
" );
} 

require MDL_sdf ;

my $record = 0 ;

while( 1 )
{
	my $sdf = MDL_sdf->readFromInput() ;
	defined $sdf || last ;
	
	my $mol = $sdf->{'molecule'} ;
	
	$mol->zeroing_atom_charges() ;
	
	$sdf->write() ;
	
	$record ++ ;
}

printf STDERR "rec. %4d\n", $record ;
