#!/usr/local/bin/perl -I/home/brunob/lib/perl

################################################################################

require 5.000 ;	# This is a perl 5.0 script
require MDL_sdf ;


use Getopt::Long ;
use File::Basename ;
$me = basename( $0, ".perl") ;

GetOptions('help', 'seed:n' , 'n:n');

if( defined($opt_help)  ) { 
	die( 
"Example usage: $me [-seed 4] [-n 10] < input.sdf > output.sdf

$me read a MDL SDFILE data file, changes randomly the order of the atoms and bonds while the chemical information is retained.

$me is useful to check if properties calculated by some program do not depend on the atoms ordering. 


Options:
-seed : a seed for the random number generator.
-n     : the number of new connection tables to be generated per entry


\n") ;

}

if( !defined $opt_n)
{
	$opt_n =1 ;
}

$opt_n > 0 || die "Invalid option\n";


my $record = 0 ;
my $records_written = 0 ;

while( 1 )
{
	if( defined $opt_seed )
	{
		srand( opt_seed) ;
	}
	
	my $sdf = MDL_sdf->readFromInput() ;
	
	defined $sdf || last ;
	$record ++ ;
	
	for( 1 .. $opt_n)
	{
		$sdf->{'molecule'}->randomize_atoms_order();
		$sdf->{'molecule'}->randomize_bonds_order();
	
		$sdf->write() ;
		$records_written ++ ;
	}

}

printf STDERR "%4d records read %4d record(s) written\n", $record, $records_written ;

