SHELL=/bin/sh
#
#  Compilation Options  - choose a suitable set for your machine
#     
#
#  USE_XDR.  Uncomment this line to enable XDR support.
#XDR=-DUSE_XDR
#
#  Parallel library support.  Uncomment as needed, and set paths to
#  include directories and library paths.
#
# TCGMSG library
#PARLIBC=-DSPMD -DTCGMSG -I/usr/local/include/tcgmsg
#PARLIBL=-L/usr/local/lib -ltcgmsg
# BSP library
#CC=bspcc
#PARLIBC=-DSPMD -DBSP
#PARLIBL=-L/usr/local/lib -lbsp
# MPI library
#CC=mpicc
#PARLIBC=-DSPMD -DMPI -I/usr/local/include/mpi
#PARLIBL=-L/usr/local/lib -lmpi
# MPI library on Edinburgh T3D
#PARLIBC=-DSPMD -DMPI
#PARLIBL=-lmpi
# SHMEM library on Edinburgh T3D
#PARLIBC=-DSPMD -DSHMEM #-DMPPMANY
#PARLIBL=
#  **** MSDOS with Turbo C ****
CC=tcc
CFLAGS= -A -DANSI_LIBS -f287 -mh -O -Z -G $(CFLAGS0)
GETOPT=getopt.obj
LDFLAGS1= -mh $(LDFLAGS0)
#  **** Scalar machines using default C compiler ****
#CFLAGS=	-O  $(XDR) $(PARLIBC) $(CFLAGS0)
LDFLAGS= $(LDFLAGS0) $(PARLIBL)
#INLINE=
#  **** Scalar machines using gcc - can compile with -g ****
#CC=	gcc
#CFLAGS= -O2 -ffast-math $(XDR) $(PARLIBC) $(CFLAGS0)
#CFLAGSAUX=-funroll-loops
#LDFLAGS= $(PARLIBL) $(LDFLAGS0)
#INLINE=
#  **** IBM RS6000 ****
#CC=cc
#CFLAGS=   -DRS6000 -qansialias -O3 $(XDR) $(PARLIBC) $(CFLAGS0)
#LDFLAGS= $(PARLIBL) $(LDFLAGS0)
#INLINE=
#  **** MIPS for SGI, IRIX 5 ****
#CFLAGS=	-O2 -mips2  $(XDR) $(PARLIBC) $(CFLAGS0)
#LDFLAGS= $(PARLIBL) $(LDFLAGS0) -lsun -lmalloc -lfastm
#INLINE=
##  **** MIPS for SGI, IRIX 6/R8000 ****
#CFLAGS= -DANSI_LIBS -O3 -mips4 -woff 1174 $(XDR) $(PARLIBC) $(CFLAGS0)
#LDFLAGS= $(PARLIBL) $(LDFLAGS0)
#CFLAGS2=-OPT:alias=restrict:fast_sqrt=on
#INLINE=
#  **** Sun C 3.0.1
#CC=acc
#CFLAGS= -fast -xO4 $(PARLIBC) $(XDR) $(CFLAGS0)
#CFLAGS2= -fsimple
#LDFLAGS= $(PARLIBL) $(LDFLAGS0) -fast 
#INLINE=
#  **** Sun Solaris 2
#CFLAGS= -fast -xO4 $(PARLIBC) $(XDR) $(CFLAGS0)
#CFLAGS2= -fsimple -xrestrict=%all
#LDFLAGS= $(PARLIBL) $(LDFLAGS0) -fast -lnsl
#INLINE=
#  **** Solaris 2 using gcc  ****
#CC=	gcc
#CFLAGS= -O2 -ffast-math $(PARLIBC) $(XDR) $(CFLAGS0)
#CFLAGSAUX=-funroll-loops
#LDFLAGS= $(PARLIBL) $(LDFLAGS0) -lnsl
#INLINE=
#  **** DEC Alpha ****
#CC=cc -migrate
#CFLAGS= -tune host -O4 $(XDR) $(PARLIBC) $(CFLAGS0) -D_FASTMATH
#CFLAGS2=-ansi_alias -O5
#LDFLAGS= $(PARLIBL) $(LDFLAGS0)
#  **** HP 700 and Convex SPP ****
#CC=c89
##CC=mpicc
#CFLAGS=	+O3  +Olibcalls $(XDR) $(PARLIBC) $(CFLAGS0)
#CFLAGS2=       +Onoparmsoverlap 
#LDFLAGS= $(PARLIBL) $(LDFLAGS0)
#  **** Stellar ****
#CFLAGS= -g -O2 -va -na -nv $(XDR) $(CFLAGS0)
#CFLAGS2= +CaliasFreePointers
#LDFLAGS= $(LDFLAGS0) -g -z 
#INLINE=
#  **** Titan ****
#CFLAGS= -O2 -vector_c -vreport $(XDR) $(PARLIBC) $(CFLAGS0)
#CFLAGS2=  -safe=ptrs
#LDFLAGS= $(PARLIBL) $(LDFLAGS0) 
#CFLAGSAUX=-catalog=auxil.in 
#INLINE= -inline -Npaths=auxil.in
#  **** convex ****
#CFLAGS= -O2 -na -nv -fi $(XDR) $(PARLIBC) $(CFLAGS0)
#CFLAGS2= -alias standard -alias ptr_args -alias array_args
##CFLAGSP= -O3 -re  # force,ewald_parallel versions only
#LDFLAGS= $(PARLIBL) $(LDFLAGS0) -fi -lveclib 
#INLINE=
#  **** Cray **** (SCC 3.0)
#CFLAGS= -h nostdc,vector3,scalar3,ivdep,fastaddr $(XDR) $(PARLIBC) $(CFLAGS0)
#LDFLAGS= $(LDFLAGS0) -Wl,-D,"HEAP=50000+50000;STACK=10000+10000" -lsci
#INLINE=
#  **** Cray T3D ****
#CC=TARGET=cray-t3d cc
#CFLAGS= -O2 $(XDR) $(PARLIBC) $(CFLAGS0)
#CFLAGS2=-hrestrict=a
#LDFLAGS=$(PARLIBL) $(LDFLAGS0) -L/usr/local/lib/bnchlib -lbnch
#  ***** End *****
LINT=		lint
TAR=		tar
DCLAR=		dclar
PFLAGS=		-P
EPFLAGS=	-2r
A2FLAGS=
SHFILE=		$$file
FILES = accel algorith alloc ansi auxil beeman convert dump ewald force input \
	eigens kernel main matrix output quaterns rdf restart startup \
	values xdr parallel

CFILES= accel.c algorith.c alloc.c ansi.c auxil.c beeman.c convert.c dump.c ewald.c force.c input.c eigens.c kernel.c main.c matrix.c output.c quaterns.c rdf.c restart.c startup.c values.c xdr.c parallel.c 

OFILES= accel.o algorith.o alloc.o ansi.o auxil.o beeman.o convert.o dump.o ewald.o force.o input.o eigens.o kernel.o main.o matrix.o output.o quaterns.o rdf.o restart.o startup.o values.o xdr.o parallel.o 

LFILES= accel.ln algorith.ln alloc.ln ansi.ln auxil.ln beeman.ln convert.ln dump.ln ewald.ln force.ln input.ln eigens.ln kernel.ln main.ln matrix.ln output.ln quaterns.ln rdf.ln restart.ln startup.ln values.ln xdr.ln parallel.ln 

INFILES = 	control.water control.tip4p control.mgclh2o control.clay \
                control.argon control.tips2 control.quartz \
		tips2.in tip4p.in mgclh2o.in \
		argon.in quartz-vbst.in methane.in mcy.in \
		water-example.out tip4p-example.out \
		mgclh2o-example.out clay-example.out \
		argon-example.out tips2-example.out \
		quartz-example.out

SHAKS=	algorith alloc auxil ansi eigens kernel input matrix\
		quaterns restart startup values xdr

SHAKC= algorith.c alloc.c auxil.c ansi.c eigens.c kernel.c input.c matrix.c quaterns.c restart.c startup.c values.c xdr.c 

SHAKOBJS=algorith.o alloc.o auxil.o ansi.o eigens.o kernel.o input.o matrix.o quaterns.o restart.o startup.o values.o xdr.o 

UTILS = moldyext dumpanal dumpconv dumpext  manalyze

EXTRA0= moldyext.c dumpanal.c dumpconv.c dumpext.c manalyze.c mdshak.c ewald_parallel.c force_parallel.c 

EXTRAS= moldyext.c dumpanal.c dumpconv.c dumpext.c manalyze.c mdshak.c ewald_parallel.c force_parallel.c ewald-RIL.c 

HFILES=		structs.h defs.h string.h time.h stddef.h stdlib.h messages.h xdr.h

FIGTEXPS=	fig_arralloc.tex fig_dostep-a.tex fig_dostep-b.tex \
                fig_ewald.tex fig_link-cell.tex fig_main.tex \
                fig_skewstart.tex fig_startup-a.tex fig_startup-b.tex \
		fig_arralloc.ps fig_dostep-a.ps fig_dostep-b.ps \
                fig_ewald.ps fig_link-cell.ps fig_main.ps \
                fig_skewstart.ps fig_startup-a.ps fig_startup-b.ps    \
		fig_arralloc-eepic.tex fig_dostep-a-eepic.tex \
		fig_dostep-b-eepic.tex fig_ewald-eepic.tex \
		fig_link-cell-eepic.tex fig_main-eepic.tex \
                fig_skewstart-eepic.tex fig_startup-a-eepic.tex \
		fig_startup-b-eepic.tex

DOC=		READ.ME BENCHMARK COPYING RELNOTES moldy.tex moldy.bbl \
		$(FIGTEXPS)

VMSBUILD=	compile_moldy.com link_moldy.com defcomm.com\
		compile_utils.com link_utils.com compile.com

DOSBUILD=	Makefile.mak OFILES.RSP SHAKOBJS.RSP

moldy:		$(OFILES) $(EXTRA_OBJ) $(HFILES)
		$(CC) -o moldy $(LDFLAGS1) @OFILES.RSP $(EXTRA_OBJ) $(LDFLAGS) -lm 

moldyext:	moldyext.c $(GETOPT) $(HFILES)
		$(CC) $(CFLAGS) -o moldyext $(LDFLAGS1) moldyext.c $(GETOPT) $(LDFLAGS)

manalyze:	manalyze.c $(HFILES)
		$(CC) $(CFLAGS)  -o manalyze $(LDFLAGS1) manalyze.c $(LDFLAGS)

dumpanal:	dumpanal.c xdr.o $(HFILES)
		$(CC) $(CFLAGS) -o dumpanal $(LDFLAGS1) dumpanal.c xdr.o  $(LDFLAGS)

dumpext:	dumpext.c xdr.o $(GETOPT) $(HFILES)
		$(CC) $(CFLAGS) -o dumpext $(LDFLAGS1) dumpext.c xdr.o $(GETOPT) $(LDFLAGS)

dumpconv:	dumpconv.c xdr.o $(HFILES)
		$(CC) $(CFLAGS) -o dumpconv $(LDFLAGS1) dumpconv.c xdr.o $(LDFLAGS)

mdshak:		mdshak.o $(SHAKOBJS) $(GETOPT) 
		$(CC) -o mdshak $(LDFLAGS1) mdshak.o @SHAKOBJS.RSP $(GETOPT) $(LDFLAGS) -lm

utilities:	$(UTILS) mdshak

$(FIGTEXPS):	
		(cd figures; \
		 transfig -L pstex -m 0.66; \
		 $(MAKE); \
		 mv *.ps *.tex ..;\
		 transfig -L eepic -m 0.66;\
		 $(MAKE); \
		 rename 's/\.tex/-eepic.tex/' *.tex;\
		 mv *.tex ..)

protoize:	$(CFILES) $(HFILES)
		protoize -k $(CFILES)

proto-mdshak:	mdshak.c $(SHAKC)
		protoize mdshak.c $(SHAKC)

install:	moldy $(UTILS) mdshak
		for file in $?; do install $$file $$HOME/bin/; done

install2:	moldy $(UTILS) mdshak
		for file in $?; do install $$file $$HOME/bin.$$HOSTTYPE/; done

Makefile:	xmakefile
		@PATH=/usr/5bin:${PATH};\
		echo		'{{{{{{{\n/^CFILES *=/  c\\\nCFILES=' $(CFILES)\
				'\n}\n/^OFILES *=/  c\\\nOFILES=' @OFILES.RSP\
				'\n}\n/^LFILES *=/  c\\\nLFILES=' $(LFILES)\
				'\n}\n/^EXTRA0 *=/  c\\\nEXTRA0=' $(EXTRA0)\
				'\n}\n/^EXTRAS *=/  c\\\nEXTRAS=' $(EXTRAS)\
				'\n}\n/^SHAKC *=/   c\\\nSHAKC='  $(SHAKC)\
				'\n}\n/^SHAKOBJS *=/  c\\\nSHAKOBJS='@SHAKOBJS.RSP\
				'\n}\n/^%\.[a-z][a-z]*:	/,/^$$/ d\n'\
				'/^moldy.bbl:	/,/^$$/ d\n' \
				'/^moldy.aux:	/,/^$$/ d\n' \
				 > make.sed 
		sed -f make.sed ./xmakefile > Makefile

Makefile.mak:	Makefile
		@PATH=/usr/5bin:${PATH};\
		echo	's/^\([ 	].*\)$@OFILES.RSP/\1@OFILES.RSP/g\n'\
			's/^\([ 	].*\)$@SHAKOBJS.RSP/\1@SHAKOBJS.RSP/g\n'\
			's/\.\<o\>/.obj/g\n'\
			's/\.o$$/.obj/g\n'\
			's/ -\<o\> *\(\<[a-z]*\>\)/ -e\1 /\n'\
			's/ -\<lm\>//\n'\
			'/^#  \*\*\*\* MSDOS/,/^#  \*/ s/^#\([A-Z]\)/\1/\n'\
			's/#XDR=/#XDR=/\n'\
			's/^\(CFLAGS=.*$$(XDR)\)/#\1/\n'\

moldy.tar.gz:	moldy.tar
		gzip moldy.tar

moldy.shar:	$(CFILES) $(HFILES)  Makefile \
		$(EXTRAS) $(INFILES) $(DOC) getopt.c $(VMSBUILD) $(DOSBUILD)
		shar $(CFILES)  $(HFILES) Makefile \
		$(EXTRAS) $(INFILES) $(DOC) getopt.c $(VMSBUILD) $(DOSBUILD)\
			 > moldy.shar

moldy.shar.Z:	moldy.shar
		compress moldy.shar

cray:		$(CFILES) $(HFILES)  
		./cray_make $(CFILES)  $(HFILES) > cray.job

moldy.job:	$(CFILES) $(HFILES)  
		./make_cray $(CFILES)  $(HFILES) > moldy.job

compile_moldy.com:	Makefile
		./make_vms_compile $(FILES) > compile_moldy.com

link_moldy.com:		Makefile
		./make_vms_link moldy $(FILES) > link_moldy.com

compile_utils.com:	Makefile
		./make_vms_compile mdshak getopt $(UTILS) > compile_utils.com

link_utils.com:	Makefile
		./make_vms_link mdshak mdshak getopt $(SHAKS) > link_utils.com
		for file in $(UTILS); do ./make_vms_link $$file $$file getopt>> \
			link_utils.com; done

moldy.com:	$(CFILES) $(HFILES) $(EXTRAS)\
		$(INFILES) Aaaa_Read.Me $(DOC) $(VMSBUILD) $(DOSBUILD)
		$(DCLAR) Aaaa_Read.Me compile.com $(CFILES) $(HFILES)\
		$(INFILES) $(EXTRAS) getopt.c $(DOC) $(VMSBUILD)  $(DOSBUILD)\
			> moldy.com

moldy.com.Z:	moldy.com
		compress moldy.com

moldy.ps:	moldy.dvi
		dvips -t a4 moldy -o moldy.ps

moldy.dvi:	moldy.tex moldy.bbl
		latex moldy
		latex moldy
		@touch moldy.bbl

$(LFILES):	$(HFILES)

#
#  Dependencies of objects on headers.
#
eigens.o quaterns.o:	defs.h

accel.o beeman.o convert.o input.o main.o output.o startup.o values.o parallel.o:	\
	structs.h defs.h messages.h

algorith.o alloc.o matrix.o:	defs.h messages.h

xdr.o restart.o dump.o:	structs.h defs.h messages.h xdr.h

#
#  Special options for performance-critical modules
#
auxil.o:	auxil.c defs.h
	$(CC) $(CFLAGS) $(CFLAGS2) $(CFLAGSAUX) -c  $<

ewald.o:	ewald.c structs.h defs.h
	$(CC) $(CFLAGS) $(CFLAGS2) $(CFLAGSP) -c $(INLINE) $<

rdf.o:		rdf.c structs.h defs.h
	$(CC) $(CFLAGS) $(CFLAGS2) -c $<

kernel.o:	kernel.c structs.h defs.h
	$(CC) $(CFLAGS) $(CFLAGS2) $(CFLAGSP) -c $<

force.o:	force.c structs.h defs.h
	$(CC) $(CFLAGS) $(CFLAGS2) $(CFLAGSP) $(INLINE) -c $<

#
#  Rule for checking out source under RCS
#

ewald-RIL.c:
	co -pRIL ewald.c > ewald-RIL.c


.c.o:
	$(CC) $(CFLAGS) -c $<

