#ifndef ZBUF_H
#define ZBUF_H

#ifndef FILE
#include <stdio.h>
#endif
#include "libcommon/common.h"

#define ZBUF_HF		1
#define ZBUF_RLE	2
#define ZBUF_TXT	3
#define ZBUF_TXT3	4
#define DEFAULT_ZBUF_TYPE	ZBUF_HF

#define ZBUF_INF    ((Float) -1000.0)      /* Infinity; same as HF_UNSET in
					      libray/libobj/hf.h */
/*
 * Z-buffer
 */
typedef struct {
	FILE *fzbuf;			/* Zbuf file pointer */
	char *rayfile;			/* Name of .ray input file */
	char *outfile;			/* Name of output file */
	Float **array;			/* Array of minimum distances from
					   all pixels in the current window */
	char **argv;			/* Write args as comment in text
					   file */
	int pad;			/* Number of pad values in
					   heightfield output */
} RSZbuf;

typedef int HEIGHTFIELD_SIZE;		/* Same size as libray/libobj/hf.c */

extern RSZbuf zbuffer;
extern void ZbufPrint(/* void */);
extern void ZbufAdd(/* Float, Float, Float */);

#endif
