/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                               G E T M E M . C                                *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1996                   *
*                                                                              *
********************************************************************************
*
* $Id: getmem.c,v 1.1 1996/12/10 18:40:58 jrh Exp $
* $Log: getmem.c,v $
 * Revision 1.1  1996/12/10  18:40:58  jrh
 * Initial revision
 *
*
*/
#include <stdio.h>
#include <stdlib.h>

void *getmem(size_t number, size_t size)
{
  void *pointer;

  pointer=calloc(number, size);
  if (pointer == NULL)
  {
    fprintf(stderr, "ERROR: Unable to allocate memory: ");
    perror(NULL);
    exit(1);
  }
  return(pointer);
}

void fremem(void **pointer)
{
  free(*pointer);
  *pointer=NULL;
}

void *expmem(void *pointer, size_t number, size_t size)
{
  pointer=realloc(pointer, number*size);
  if (pointer == NULL)
  {
    fprintf(stderr, "ERROR: Unable to change size of allocated memory: ");
    perror(NULL);
    exit(1);
  }
  return(pointer);
}
