/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                                 I N I T . C                                  *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1996                   *
*                                                                              *
********************************************************************************
*
* $Id: init.c,v 1.1 1996/12/10 18:41:22 jrh Exp $
* $Log: init.c,v $
 * Revision 1.1  1996/12/10  18:41:22  jrh
 * Initial revision
 *
*
*/
#include<stdio.h>
#include<X11/Xlib.h>
#include<X11/Intrinsic.h>
#include<X11/Shell.h>
#include<X11/cursorfont.h>
#include<Xm/Xm.h>
#include<Xm/DrawingA.h>
#include<Xm/PushBG.h>
#include<Xm/SeparatoG.h>
#include<Xm/ToggleBG.h>
#include<GL/gl.h>
#include<GL/glu.h>
#ifdef __osf__
#include<X11/GLw/GLwMDrawA.h>
#else
#include<GL/GLwMDrawA.h>
#endif
#include "viewmol.h"
#include "menu.h"

void makeWindow(int, char *, void *func());
void initSpectrum(Widget, caddr_t, caddr_t);
void initMODiagram(Widget, caddr_t, caddr_t);
void initHistory(Widget, caddr_t, caddr_t);
void setCursor(Widget, unsigned int);
void setMenuItem(int, int, int);
void blendToPicture(void);

extern char *getStringResource(Widget, char *);
extern void createFileselect(void);
extern int  input(int, char **);
extern void allocWindowColors(void);
extern void setWindowTitle(Widget, char *);
extern int  setAtom(void);
extern void inert(void);
extern int  makeConnectivity(int);
extern void *getmem(size_t, size_t);
extern void storeColor(Pixel, struct WINDOW *, int);
extern void redraw(int);
extern void drawBackground(int, Pixel, float);
extern int StringWidth(XFontStruct *, char *);
extern void deleteFontList(GLuint, XFontStruct *);
extern XFontStruct *makeRasterFont(Display *, char *, GLuint *);
extern void drawSpectrum(Widget, caddr_t, GLwDrawingAreaCallbackStruct *);
extern void drawHistory(Widget, caddr_t, GLwDrawingAreaCallbackStruct *);
extern void drawMODiagram(Widget, caddr_t, GLwDrawingAreaCallbackStruct *);
extern void reshape(Widget, caddr_t, GLwDrawingAreaCallbackStruct *);
extern void processInput(Widget, caddr_t,  GLwDrawingAreaCallbackStruct *);
extern void ende(Widget, caddr_t,  GLwDrawingAreaCallbackStruct *);
extern void setModel(Widget, caddr_t, GLwDrawingAreaCallbackStruct *);
extern void setDiagram(Widget, caddr_t, GLwDrawingAreaCallbackStruct *);
extern void changeBoolean(Widget, int *, GLwDrawingAreaCallbackStruct *);
extern void hardcopyCallback(Widget, caddr_t, XmAnyCallbackStruct *);
extern void clearGeometry(Widget, caddr_t, XmAnyCallbackStruct *);
extern void spectrumDialog(Widget, caddr_t, XmAnyCallbackStruct *);
extern void optimizationDialog(Widget, caddr_t, XmAnyCallbackStruct *);
extern void MODiagramDialog(Widget, caddr_t, XmAnyCallbackStruct *);
extern void wavefunctionDialog(Widget, caddr_t, XmAnyCallbackStruct *);
extern void drawingModeDialog(Widget, caddr_t, XmAnyCallbackStruct *);
extern void printDialog(Widget, caddr_t, XmAnyCallbackStruct *);
extern void colorEditor(Widget, caddr_t, XmAnyCallbackStruct *);
extern void quitSpectrum(Widget, caddr_t, XmAnyCallbackStruct *);
extern void quitHistory(Widget, caddr_t, XmAnyCallbackStruct *);
extern void quitMODiagram(Widget, caddr_t, XmAnyCallbackStruct *);
extern Widget makeMenu(Widget, int, char *, struct MenuItem *);
extern void doMenu(Widget, Widget, caddr_t);
extern void zoomOut(Widget, caddr_t, caddr_t);
extern void manual(Widget, caddr_t, caddr_t);
extern void (*drawString)(char *, double, double, double, GLuint);
extern void setWindowColor(int, Pixel, const float *);
extern void getImaginaryMode(Widget, caddr_t, caddr_t);
extern void saveMolecule(Widget, caddr_t, caddr_t);
extern void raytracer(Widget, caddr_t, caddr_t);
extern void setTransition(Widget, caddr_t, XmToggleButtonCallbackStruct *);

extern struct BASISSET *basisset;
extern struct ORBITAL *orbitals;
extern struct NORMAL_MODE *normal_modes;
extern struct WINDOW windows[];
extern Pixel stdcol[9];
extern int rgbMode;
extern char title[];
extern Widget topShell;
extern int label, showForces, nmodes, nhist, nbasfu, imag;
extern int existsUnitCell, showUnitCell, showInertia, swapBuffers;

#include "menudef.h"

int initViewer(int argc, char **argv, Widget widget)
{
  char *string;

  setCursor(widget, XC_watch);
  string=getStringResource(widget, "font");
  windows[VIEWER].font=makeRasterFont(XtDisplay(widget), string, &windows[VIEWER].GLfontId);
#ifndef LINUX
  windows[VIEWER].menu=makeMenu(XtParent(windows[VIEWER].widget), XmMENU_POPUP, "viewmol", viewerMenu);
  XtAddCallback(XtParent(windows[VIEWER].widget), XmNinputCallback, (XtCallbackProc)doMenu, windows[VIEWER].menu);
#else
  windows[VIEWER].menu=makeMenu(windows[VIEWER].widget, XmMENU_POPUP, "viewmol", viewerMenu);
  XtAddCallback(windows[VIEWER].widget, XmNinputCallback, (XtCallbackProc)doMenu, windows[VIEWER].menu);
#endif
  createFileselect();

  if (!input(argc, argv)) return(FALSE);
  allocWindowColors();
  setWindowTitle(widget, title);
  if (windows[VIEWER].mode == WIREMODEL)
  {
    setMenuItem(VIEWER,  0, False);
    setMenuItem(VIEWER, 19, False);
  }
  if (windows[VIEWER].mode == STICKMODEL) setMenuItem(VIEWER, 1, False);
  if (windows[VIEWER].mode == BALLMODEL)  setMenuItem(VIEWER, 2, False);
  if (windows[VIEWER].mode == CUPMODEL)   setMenuItem(VIEWER, 3, False);
  if (basisset == NULL)                   setMenuItem(VIEWER, 6, False);
  if (orbitals == NULL)                   setMenuItem(VIEWER, 7, False);
  if (nhist < 2)                          setMenuItem(VIEWER, 8, False);
  if (nhist == 0)                         setMenuItem(VIEWER, 9, False);
  if (nmodes == 0)                        setMenuItem(VIEWER, 10, False);
  if (!setAtom())                         setMenuItem(VIEWER, 11, False);
  inert();
  if (!makeConnectivity(existsUnitCell)) return(FALSE);
  if (!existsUnitCell) showUnitCell=FALSE;
  blendToPicture();
  setCursor(widget, XC_top_left_arrow);
  return(TRUE);
}

void initSpectrum(Widget w, caddr_t client_data, caddr_t call_data)
{
  struct MenuItem *menu;
  Pixel pixel;
  char t[7], *string, *label;
  register int i;

  makeWindow(SPECTRUM, "spectrum", (void *)drawSpectrum);
  string=getStringResource(windows[SPECTRUM].widget, "font");
  windows[SPECTRUM].font=makeRasterFont(XtDisplay(windows[SPECTRUM].widget), string, &windows[SPECTRUM].GLfontId);
  if (imag != 0)
  {
    menu=(struct MenuItem *)getmem(imag+1, sizeof(struct MenuItem));
    label=(char *)getmem(imag, 10);
    for (i=0; i<imag; i++)
    {
      sprintf(&label[10*i], "%7.2f i", -normal_modes[i].wavenumber);
      menu[i].label=&label[10*i];
      menu[i].class=&xmPushButtonGadgetClass;
      menu[i].callback=getImaginaryMode;
      menu[i].callback_data=(XtPointer)i;
      menu[i].widget=(Widget)NULL;
      menu[i].subitems=NULL;
    }
    menu[i].label=NULL; 
    spectrumMenu[1].subitems=menu;
  }
#ifndef LINUX
  windows[SPECTRUM].menu=makeMenu(XtParent(windows[SPECTRUM].widget), XmMENU_POPUP, "spectrum_menu", spectrumMenu);
  XtAddCallback(XtParent(windows[SPECTRUM].widget), XmNinputCallback, (XtCallbackProc)doMenu, windows[SPECTRUM].menu);
#else
  windows[SPECTRUM].menu=makeMenu(windows[SPECTRUM].widget, XmMENU_POPUP, "spectrum_menu", spectrumMenu);
  XtAddCallback(windows[SPECTRUM].widget, XmNinputCallback, (XtCallbackProc)doMenu, windows[SPECTRUM].menu);
#endif
  setMenuItem(VIEWER, 10, False);
  if (imag == 0) setMenuItem(SPECTRUM, 1, False);
  setMenuItem(SPECTRUM, 2, False);
  XtVaGetValues(windows[SPECTRUM].widget, XmNbackground, &pixel, NULL);
  storeColor(pixel, &windows[SPECTRUM], BACKGROUND);
  XtVaGetValues(windows[SPECTRUM].widget, XmNforeground, &pixel, NULL);
  storeColor(pixel, &windows[SPECTRUM], FOREGROUND);
  sprintf(t, "title%.1d", windows[SPECTRUM].mode);
  string=getStringResource(XtParent(XtParent(windows[SPECTRUM].widget)), t);
  setWindowTitle(XtParent(windows[SPECTRUM].widget), string);
}

void initHistory(Widget w, caddr_t client_data, caddr_t call_data)
{
  Pixel pixel;
  char *string;

  makeWindow(HISTORY, "history", (void *)drawHistory);
  string=getStringResource(windows[HISTORY].widget, "font");
  windows[HISTORY].font=makeRasterFont(XtDisplay(windows[HISTORY].widget), string, &windows[HISTORY].GLfontId);
#ifndef LINUX
  windows[HISTORY].menu=makeMenu(XtParent(windows[HISTORY].widget), XmMENU_POPUP, "history_menu", historyMenu);
  XtAddCallback(XtParent(windows[HISTORY].widget), XmNinputCallback, (XtCallbackProc)doMenu, windows[HISTORY].menu);
#else
  windows[HISTORY].menu=makeMenu(windows[HISTORY].widget, XmMENU_POPUP, "history_menu", historyMenu);
  XtAddCallback(windows[HISTORY].widget, XmNinputCallback, (XtCallbackProc)doMenu, windows[HISTORY].menu);
#endif
  setMenuItem(VIEWER, 8, False);
  XtVaGetValues(windows[HISTORY].widget, XmNbackground, &pixel, NULL);
  storeColor(pixel, &windows[HISTORY], BACKGROUND);
  XtVaGetValues(windows[HISTORY].widget, XmNforeground, &pixel, NULL);
  storeColor(pixel, &windows[HISTORY], FOREGROUND);
  storeColor(stdcol[GREEN], &windows[HISTORY], GNORM);
  redraw(VIEWER);
}

void initMODiagram(Widget w, caddr_t client_data, caddr_t call_data)
{
  Pixel pixel;
  char *string;

  makeWindow(MO, "MODiagram", (void *)drawMODiagram);
  string=getStringResource(windows[MO].widget, "font");
  windows[MO].font=makeRasterFont(XtDisplay(windows[MO].widget), string, &windows[MO].GLfontId);
#ifndef LINUX
  windows[MO].menu=makeMenu(XtParent(windows[MO].widget), XmMENU_POPUP, "MODiagram_menu", MODiagramMenu);
  XtAddCallback(XtParent(windows[MO].widget), XmNinputCallback, (XtCallbackProc)doMenu, windows[MO].menu);
#else
  windows[MO].menu=makeMenu(windows[MO].widget, XmMENU_POPUP, "MODiagram_menu", MODiagramMenu);
  XtAddCallback(windows[MO].widget, XmNinputCallback, (XtCallbackProc)doMenu, windows[MO].menu);
#endif
  setMenuItem(MO, 1, False);
  setMenuItem(MO, 2, False);
  setMenuItem(VIEWER, 7, False);
  XtVaGetValues(windows[MO].widget, XmNbackground, &pixel, NULL);
  storeColor(pixel, &windows[MO], BACKGROUND);
  XtVaGetValues(windows[MO].widget, XmNforeground, &pixel, NULL);
  storeColor(pixel, &windows[MO], FOREGROUND);
}

void makeWindow(int which, char *name, void *drawFunc())
{
  Display *display;
  XVisualInfo *vi;
  Colormap colormap;
  Widget shell, drawArea;
  Dimension width, height;

  display=XtDisplay(topShell);
  shell=XtCreatePopupShell(name, applicationShellWidgetClass, topShell, NULL, 0);
  drawArea=XtVaCreateManagedWidget(name, xmDrawingAreaWidgetClass, shell,
                                   XmNmarginHeight, 0,
                                   XmNmarginWidth, 0,
                                   NULL);
  XtManageChild(shell);
  XtRealizeWidget(shell);
  XtVaGetValues(drawArea, XmNheight, &height, XmNwidth, &width, NULL);
  XtVaGetValues(windows[VIEWER].widget, GLwNvisualInfo, &vi, NULL);
#ifndef MESA
  if (rgbMode)
    colormap=XCreateColormap(display, XtWindow(drawArea), vi->visual, AllocNone);
  else
#endif
    colormap=DefaultColormap(display, DefaultScreen(display));
  windows[which].widget=XtVaCreateManagedWidget("canvas", glwMDrawingAreaWidgetClass, drawArea,
                                                GLwNvisualInfo, vi,
                                                XmNheight, height,
                                                XmNwidth, width,
                                                XmNcolormap, colormap,
                                                NULL);
  windows[which].context=glXCreateContext(XtDisplay(windows[which].widget), vi, 0, GL_FALSE);
  GLwDrawingAreaMakeCurrent(windows[which].widget, windows[which].context);
  XtAddCallback(windows[which].widget, GLwNinputCallback, (XtCallbackProc)processInput, NULL);
  XtAddCallback(drawArea,              XmNresizeCallback, (XtCallbackProc)reshape, (XtPointer)which);
  XtAddCallback(windows[which].widget, GLwNexposeCallback, (XtCallbackProc)drawFunc, NULL);
}

void setCursor(Widget widget, unsigned int shape)
{
  static Cursor cursor=0;
  static unsigned int oldShape=0;
  Display *display;
  Window  window;

  display=XtDisplay(widget);
  window=XtWindow(widget);
  if (shape != oldShape)
  {
    if (cursor != 0) XFreeCursor(display, cursor);
    cursor=XCreateFontCursor(display, shape);
    oldShape=shape;
  }
  XDefineCursor(display, window, cursor);
  XFlush(display);
}

void showTitle(Dimension width, Dimension height)
{
  Display *display;
  XFontStruct *font;
  GLuint GLfont;
  char viewmol[] = PROGRAM;
  char *version, *by;
  char author[21] = "Jrg-Rdiger Hill";
  char versionLine[30];
  const float yellow[4]  = {1.0, 1.0,  0.0, 0.0};
  const float black[4]   = {0.0, 0.0,  0.0, 0.0};
  int w, cyrillic=FALSE;

  display=XtDisplay(windows[VIEWER].widget);
  by=getStringResource(topShell, "fontList");
  if (strstr(by, "koi8"))
  {
    cyrillic=TRUE;
    strcpy(viewmol, "");
    strcpy(author, "- ");
  }
  by=getStringResource(topShell, "by");
  version=getStringResource(topShell, "version");
  strcpy(versionLine, version);
  strcat(versionLine, " ");
  strcat(versionLine, VERSION);
  GLwDrawingAreaMakeCurrent(windows[VIEWER].widget, windows[VIEWER].context);
  drawBackground(VIEWER, stdcol[SKYBLUE], 0.0);
  glLoadIdentity();
  gluOrtho2D((double)0.0, (double)width, (double)0.0, (double)height);
  setWindowColor(FOREGROUND, stdcol[YELLOW], yellow);
  if (cyrillic)
  {
    font=makeRasterFont(display, "-cronyx-times-bold-r-normal--24-240-75-75-p-124-koi8r-1-24",
                        &GLfont);
    if (font == NULL)
    {
      font=makeRasterFont(display, "variable", &GLfont);
	strcpy(viewmol, PROGRAM);
    }
  }
  else
  {
    font=makeRasterFont(display, "-adobe-times-bold-r-normal--34-240-100-100-p-177-iso8859-1",
                        &GLfont);
    if (font == NULL)
      font=makeRasterFont(display, "variable", &GLfont);
  }
  w=StringWidth(font, viewmol);
  (*drawString)(viewmol, (GLdouble)(width-w)/2.e0, 2.e0/3.e0*height, 0.0, GLfont);
  deleteFontList(GLfont, font);
  setWindowColor(FOREGROUND, stdcol[BLACK], black);
  if (cyrillic)
  {
    font=makeRasterFont(display, "-cronyx-helvetica-medium-r-normal--14-140-75-75-p-77-koi8r-1-14",
                        &GLfont);
    if (font == NULL)
    {
      font=makeRasterFont(display, "variable", &GLfont);
	strcpy(author, "Jrg-Rdiger Hill");
    }
  }
  else
  {
    font=makeRasterFont(display, "-adobe-helvetica-medium-r-normal--14-*-*-*-*-*-iso8859-1",
                        &GLfont);
    if (font == NULL)
      font=makeRasterFont(display, "variable", &GLfont);
  }
  w=StringWidth(font, versionLine);
  (*drawString)(versionLine, (GLdouble)(width-w)/2.e0, height/2.e0, 0.0, GLfont);
  w=StringWidth(font, by);
  (*drawString)(by, (GLdouble)(width-w)/2.e0, height/2.5e0, 0.0, GLfont);
  w=StringWidth(font, author);
  (*drawString)(author, (GLdouble)(width-w)/2.e0, height/3.e0, 0.0, GLfont);
  deleteFontList(GLfont, font);
  GLwDrawingAreaSwapBuffers(windows[VIEWER].widget);
}

void setMenuItem(int menu, int item, int disable)
{
  struct MenuItem *m=NULL;

  switch (menu)
  {
    case VIEWER:    m=viewerMenu;
                    break;
    case SPECTRUM:  m=spectrumMenu;
                    break;
    case MO:        m=MODiagramMenu;
                    break;
    case HISTORY:   m=historyMenu;
                    break;
  }
  XtVaSetValues(m[item].widget, XmNsensitive, disable, NULL);
}

void blendToPicture(void)
{

/* Switch smoothly from title to picture */

  Dimension width, height;
  GLsizei incx, incy, ngrid=5;
  register int i, j, k;

  XtVaGetValues(windows[VIEWER].widget, XmNwidth, &width, XmNheight, &height, NULL);
  incx=(GLsizei)width/ngrid;
  incy=(GLsizei)height/ngrid;
  if (width % ngrid != 0) incx++;
  if (height % ngrid !=0) incy++;
  swapBuffers=FALSE;
  redraw(VIEWER);
  swapBuffers=TRUE;
  glReadBuffer(GL_BACK);
  glDrawBuffer(GL_FRONT);
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluOrtho2D((double)0.0, (double)width, (double)0.0, (double)height);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  i=0;
  j=0;
  for (k=ngrid-1; k>0; k--)
  {
    while (i<k)
    {
      glRasterPos2i((GLint)(i*incx+1), (GLint)(j*incy+1));
      glCopyPixels((GLint)(i*incx+1), (GLint)(j*incy+1), incx, incy, GL_COLOR);
      i++;
    }
    while (j<k)
    {
      glRasterPos2i((GLint)(i*incx+1), (GLint)(j*incy+1));
      glCopyPixels((GLint)(i*incx+1), (GLint)(j*incy+1), incx, incy, GL_COLOR);
      j++;
    }
    while (i>ngrid-k-1)
    {
      glRasterPos2i((GLint)(i*incx+1), (GLint)(j*incy+1));
      glCopyPixels((GLint)(i*incx+1), (GLint)(j*incy+1), incx, incy, GL_COLOR);
      i--;
    }
    while (j>ngrid-k)
    {
      glRasterPos2i((GLint)(i*incx+1), (GLint)(j*incy+1));
      glCopyPixels((GLint)(i*incx+1), (GLint)(j*incy+1), incx, incy, GL_COLOR);
      j--;
    }
    glXWaitGL();
  }
  glRasterPos2i((GLint)(i*incx+1), (GLint)(j*incy+1));
  glCopyPixels((GLint)(i*incx+1), (GLint)(j*incy+1), incx, incy, GL_COLOR);
  glXWaitGL();
  glDrawBuffer(GL_BACK);
}
