/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                               I N S I N T . C                                *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1996                   *
*                                                                              *
********************************************************************************
*
* $Id: insint.c,v 1.1 1996/12/10 18:41:30 jrh Exp $
* $Log: insint.c,v $
 * Revision 1.1  1996/12/10  18:41:30  jrh
 * Initial revision
 *
*/
#include<math.h>
#include "viewmol.h"

extern struct ATOM *atoms;
extern struct NORMAL_MODE *normal_modes;
extern double *cnm, temp;
extern int na, nmodes;

void makeINSIntensity(void)
{
  double pi, h, c, bk, amu, cotfac, qfac;
  register double f, rll, smax;
  register int i, j, k;

/* This subroutine computes inelastic neutron scattering intensities */

  pi=4.0*atan(1.0);
  h=6.626176e-34;
  c=2.99792458e10;
  bk=1.380662e-23;
  amu=1.6605655e-27;
  cotfac=h*c/(2.0*bk*temp);
  qfac=h*1.e20/(4.0*pi*pi*c*amu);

  smax=0.0;
  for (i=0; i<3*na; i++)
  {
    normal_modes[i].ins_intensity=0.0;
    if (normal_modes[i].wavenumber > 0.0)
    {
      f=sqrt(qfac/(2.0*normal_modes[i].wavenumber)/tanh(cotfac*normal_modes[i].wavenumber));
	k=0;
      for (j=0; j<na; j++)
	{
        rll=sqrt(cnm[i+nmodes*k]*cnm[i+nmodes*k]
		    +cnm[i+nmodes*(k+1)]*cnm[i+nmodes*(k+1)]
		    +cnm[i+nmodes*(k+2)]*cnm[i+nmodes*(k+2)]);
	  k+=3;
        normal_modes[i].ins_intensity+=atoms[j].neutron_scatterfac*rll;
      }
      normal_modes[i].ins_intensity*=f;
      smax=smax > normal_modes[i].ins_intensity ? smax : normal_modes[i].ins_intensity;
    }
  }
  for (i=0; i<3*na; i++)
  {
    if (smax == 0.0)
      normal_modes[i].rel_ins_intensity=0.0;
    else
      normal_modes[i].rel_ins_intensity=100.0*normal_modes[i].ins_intensity/smax;
  }
}
