/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                            R A Y T R A C E R . C                             *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1996                   *
*                                                                              *
********************************************************************************
*
* $Id: raytracer.c,v 1.1 1996/12/10 18:43:29 jrh Exp $
* $Log: raytracer.c,v $
 * Revision 1.1  1996/12/10  18:43:29  jrh
 * Initial revision
 *
*/
#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<unistd.h>
#include<X11/Intrinsic.h>
#include "viewmol.h"
#include "dialog.h"

extern char *getStringResource(Widget, char *);
extern void GetMessageBoxButton(Widget, XtPointer, caddr_t);
extern char *selectFile(char *, char *);
extern int messgb(Widget, int, char *, struct PushButtonRow *, int);
extern char *saveVectorFile(int, char *, int);
extern int runProg(char *, int, char *, char *, char *, pid_t *);
extern int checkFile(char **);

extern Widget topShell;
extern pid_t raypid;

void raytracer(Widget widget, caddr_t data1, caddr_t data2)
{
  static struct PushButtonRow buttons1[] = {{"continue", GetMessageBoxButton, (XtPointer)0, NULL},
                                            {"cancel", GetMessageBoxButton, (XtPointer)1, NULL}};
  static struct PushButtonRow buttons2[] = {{"doRaytracing", GetMessageBoxButton, (XtPointer)0, NULL},
                                            {"stopRaytracing", GetMessageBoxButton, (XtPointer)1, NULL}};
  static struct PushButtonRow buttons3[] = {{"continue", GetMessageBoxButton, (XtPointer)0, NULL}};
  pid_t pid;
  char line[MAXLENLINE], rayshade[MAXLENLINE], displayRLE[MAXLENLINE] = "";
  char *rayfile, rlefile[MAXLENLINE], *dot;

  if ((rayfile=selectFile("*", "vm_image.ray")) == NULL) return;
  saveVectorFile(VIEWER, rayfile, RAYTRACER);
  strcpy(rlefile, rayfile);
  if ((dot=strrchr(rlefile,'.')) != NULL)
    strcpy(dot, ".rle");
  else
    strcat(rlefile, ".rle");
  if (!access(rlefile, F_OK))
  {
    dot=getStringResource(topShell, "FileExists");
    sprintf(line, dot, rlefile);
    if (messgb(topShell, 1, line, buttons1, 2) == 1) return;
  }

  dot=getStringResource(topShell, "Rayshade");
  if (checkFile(&dot))
  {
    strcpy(rayshade, dot);
    dot=getStringResource(topShell, "DisplayRLE");
    if (!checkFile(&dot))
    {
      dot=getStringResource(topShell, "noDisplay");
      if (messgb(topShell, 3, dot, buttons2, 2) == 1) return;
	dot=NULL;
    }
    strcpy(displayRLE, dot);
    if ((raypid=fork()) == (pid_t)0)
    {
      runProg(rayshade, TRUE, rayfile, rlefile, "/dev/null", &pid);
      if (displayRLE[0] != '\0')
      {
        sprintf(line, displayRLE, rlefile);
        runProg(line, FALSE, NULL, NULL, "/dev/null", &pid);
      }
      exit(0);
    }
  }
  else
  {
    dot=getStringResource(topShell, "noRayshade");
    messgb(topShell, 3, dot, buttons3, 1);
  }
}
