/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                             W A V E F O R M . C                              *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1996                   *
*                                                                              *
********************************************************************************
*
* $Id: waveform.c,v 1.1 1996/12/10 18:44:23 jrh Exp $
* $Log: waveform.c,v $
 * Revision 1.1  1996/12/10  18:44:23  jrh
 * Initial revision
 *
*
*/
#include<math.h>
#include<X11/Intrinsic.h>
#include<Xm/Xm.h>
#include<Xm/BulletinB.h>
#include<Xm/DialogS.h>
#include<Xm/Form.h>
#include<Xm/Label.h>
#include<Xm/LabelG.h>
#include<Xm/MwmUtil.h>
#include<Xm/PanedW.h>
#include<Xm/PushB.h>
#include<Xm/PushBG.h>
#include<Xm/RowColumn.h>
#include<Xm/Scale.h>
#include<Xm/Separator.h>
#include<Xm/Text.h>
#include<Xm/ToggleB.h>
#include<GL/glu.h>
#include<GL/GLwMDrawA.h>
#include "viewmol.h"
#include "dialog.h"

extern void MapBox(Widget, caddr_t, caddr_t);
extern void GetUnit(Widget, struct TOGGLE *, XmPushButtonCallbackStruct *);
extern void GetSlider(Widget, struct SLIDER *, XmScrollBarCallbackStruct *);
extern Widget CreateToggleBox(Widget, struct PushButtonRow *, int, int,
                              int, int);
extern char *getStringResource(Widget, char *);
extern void CreatePushButtonRow(Widget, struct PushButtonRow *, int);
extern int checkFile(char **);
extern void calcmo(void);
extern void redraw(int);
extern void drawMolecule(Widget, caddr_t, GLwDrawingAreaCallbackStruct *);
extern void fremem(void **);

void wavefunctionDialogExit(Widget, caddr_t, XmPushButtonCallbackStruct *);
void changeLevel(Widget, struct SLIDER *, XmScrollBarCallbackStruct *);
void deleteGridObjects(void);

extern struct WINDOW windows[];
extern struct BASISSET *basisset;
extern struct ORBITAL *orbitals;
extern struct GRIDOBJECT *gridObjects;
extern int iwavef, ibasfu, interp, imo, needMoloch, ngridobjects;
extern int selectAtom, primitive, swapBuffers;
extern double level, gridres;
extern Widget topShell;
extern char moloch[];
static Widget dialog;
static int iwavef_save, interp_save;
static double level_save, gridres_save;

void wavefunctionDialog(Widget widget, caddr_t dummy, XmAnyCallbackStruct *data)
{
  Widget form, board, form1, checkbox1, checkbox2, sep1, sep2, sep3, sep4;
  Widget slider1, slider2, label;
  Arg args[3];
  register int i, molochExist=FALSE;
  static struct TOGGLE toggle1[5];
  static struct TOGGLE toggle2[3];
  static struct PushButtonRow buttons[] = {
    { "ok", wavefunctionDialogExit, (XtPointer)TRUE, NULL },
    { "cancel", wavefunctionDialogExit, (XtPointer)FALSE, NULL },
  };
  static struct PushButtonRow checkbox1_buttons[] = {
    { "all_off", GetUnit, (XtPointer)&toggle1[0], NULL },
    { "basis_function", GetUnit, (XtPointer)&toggle1[1], NULL },
    { "basis_in_mo", GetUnit, (XtPointer)&toggle1[2], NULL },
    { "molecular_orbital", GetUnit, (XtPointer)&toggle1[3], NULL },
    { "electron_density", GetUnit, (XtPointer)&toggle1[4], NULL },
  };
  static struct PushButtonRow checkbox2_buttons[] = {
    { "none", GetUnit, (XtPointer)&toggle2[0], NULL },
    { "linear", GetUnit, (XtPointer)&toggle2[1], NULL },
    { "logarithmic", GetUnit, (XtPointer)&toggle2[2], NULL },
  };
  static struct SLIDER surface, gridsize;
  int levelInt;
  char *word;

  iwavef_save=iwavef;
  interp_save=interp;
  level_save=level;
  gridres_save=gridres;
  gridsize.number=&gridres;
  gridsize.decimals=0;
  gridsize.draw=NULL;

  XtSetArg(args[0], XmNautoUnmanage, False);
  XtSetArg(args[1], XmNdefaultPosition, False);
  if (XmIsMotifWMRunning(topShell))
    XtSetArg(args[2], XmNmwmDecorations, MWM_DECOR_RESIZEH | MWM_DECOR_TITLE);
  else
    XtSetArg(args[2], (char *)NULL, 0);
  dialog=XmCreateDialogShell(windows[VIEWER].widget, "wavefunctionForm_popup", args, XtNumber(args));
  board=XtVaCreateWidget("wavefunctionForm", xmBulletinBoardWidgetClass, dialog,
                        XmNautoUnmanage, False,
                        XmNdefaultPosition, False,
                        NULL);
  form=XtVaCreateWidget("rowcolumn", xmRowColumnWidgetClass, board,
                        XmNorientation, XmVERTICAL,
                        NULL);

  form1=XtVaCreateWidget("controlarea", xmFormWidgetClass, form, NULL);

  for (i=0; i<5; i++)
  {
    toggle1[i].var=&iwavef;
    toggle1[i].draw=NULL;
  }
  toggle1[0].value=ALL_OFF;
  toggle1[1].value=BASIS_FUNCTION;
  toggle1[2].value=BASIS_IN_MO;
  toggle1[3].value=MOLECULAR_ORBITAL;
  toggle1[4].value=DENSITY;

  checkbox1=CreateToggleBox(form1, checkbox1_buttons, XtNumber(checkbox1_buttons),
                            XmVERTICAL, True, iwavef-1);

  if (orbitals != NULL)
  {
    if (needMoloch)
    {
      word=getStringResource(topShell, "Moloch");
      if ((molochExist=checkFile(&word))) strcpy(moloch, word); 
    }
    if (imo == -1 || (needMoloch && !molochExist))
      XtVaSetValues(checkbox1_buttons[BASIS_IN_MO-1].widget, XmNsensitive, False, NULL);
    if (imo == -1 || (needMoloch && !molochExist))
      XtVaSetValues(checkbox1_buttons[MOLECULAR_ORBITAL-1].widget, XmNsensitive, False, NULL);
    if (needMoloch && !molochExist) XtVaSetValues(checkbox1_buttons[DENSITY-1].widget, XmNsensitive, False, NULL);
  }
  else
  {
    XtVaSetValues(checkbox1_buttons[BASIS_IN_MO-1].widget, XmNsensitive, False, NULL);
    XtVaSetValues(checkbox1_buttons[MOLECULAR_ORBITAL-1].widget, XmNsensitive, False, NULL);
    XtVaSetValues(checkbox1_buttons[DENSITY-1].widget, XmNsensitive, False, NULL);
  }

  XtVaSetValues(checkbox1, XmNleftAttachment, XmATTACH_FORM,
                           XmNrightAttachment, XmATTACH_FORM,
                           XmNtopAttachment, XmATTACH_FORM,
                           NULL);
  sep1=XtVaCreateManagedWidget("sep1", xmSeparatorWidgetClass, form1,
                              XmNtraversalOn, False,
                              XmNleftAttachment, XmATTACH_FORM,
                              XmNrightAttachment, XmATTACH_FORM,
                              XmNtopAttachment, XmATTACH_WIDGET,
                              XmNtopWidget, checkbox1,
                              NULL);

  label=XtVaCreateManagedWidget("levelLabel", xmLabelWidgetClass, form1,
                                XmNleftAttachment, XmATTACH_FORM,
                                XmNrightAttachment, XmATTACH_FORM,
                                XmNtopAttachment, XmATTACH_WIDGET,
                                XmNtopWidget, sep1,
                                NULL);
  slider1=XtVaCreateManagedWidget("level", xmScaleWidgetClass, form1,
                                  XmNorientation, XmHORIZONTAL,
                                  XmNdecimalPoints, 3,
                                  XmNshowValue, True,
                                  XmNsensitive, True,
                                  XmNleftAttachment, XmATTACH_FORM,
                                  XmNrightAttachment, XmATTACH_FORM,
                                  XmNtopAttachment, XmATTACH_WIDGET,
                                  XmNtopWidget, label,
                                  NULL);
  levelInt=level*1000.;
  XtVaSetValues(slider1, XmNvalue, levelInt, NULL);
  surface.number=&level;
  surface.decimals=3;
  surface.draw=(void *)drawMolecule;
  XtAddCallback(slider1, XmNvalueChangedCallback, (XtCallbackProc)GetSlider, &surface);
  XtAddCallback(slider1, XmNdragCallback, (XtCallbackProc)changeLevel, &surface);

  sep2=XtVaCreateManagedWidget("sep2", xmSeparatorWidgetClass, form1,
                              XmNtraversalOn, False,
                              XmNleftAttachment, XmATTACH_FORM,
                              XmNrightAttachment, XmATTACH_FORM,
                              XmNtopAttachment, XmATTACH_WIDGET,
                              XmNtopWidget, slider1,
                              NULL);

  label=XtVaCreateManagedWidget("interpolationLabel", xmLabelWidgetClass, form1,
                                XmNleftAttachment, XmATTACH_FORM,
                                XmNrightAttachment, XmATTACH_FORM,
                                XmNtopAttachment, XmATTACH_WIDGET,
                                XmNtopWidget, sep2,
                                NULL);
  for (i=0; i<3; i++)
  {
    toggle2[i].var=&interp;
    toggle2[i].draw=NULL;
  }
  toggle2[0].value=IP_NONE;
  toggle2[1].value=IP_LINEAR;
  toggle2[2].value=IP_LOG;
  checkbox2=CreateToggleBox(form1, checkbox2_buttons, XtNumber(checkbox2_buttons),
                           XmVERTICAL, True, interp-1);

  XtVaSetValues(checkbox2, XmNleftAttachment, XmATTACH_FORM,
                           XmNrightAttachment, XmATTACH_FORM,
                           XmNtopAttachment, XmATTACH_WIDGET,
                           XmNtopWidget, label,
                           NULL);

  sep3=XtVaCreateManagedWidget("sep3", xmSeparatorWidgetClass, form1,
                              XmNtraversalOn, False,
                              XmNleftAttachment, XmATTACH_FORM,
                              XmNrightAttachment, XmATTACH_FORM,
                              XmNtopAttachment, XmATTACH_WIDGET,
                              XmNtopWidget, checkbox2,
                              NULL);

  label=XtVaCreateManagedWidget("gridLabel", xmLabelWidgetClass, form1,
                                XmNleftAttachment, XmATTACH_FORM,
                                XmNrightAttachment, XmATTACH_FORM,
                                XmNtopAttachment, XmATTACH_WIDGET,
                                XmNtopWidget, sep3,
                                NULL);
  slider2=XtVaCreateManagedWidget("grid", xmScaleWidgetClass, form1,
                                  XmNorientation, XmHORIZONTAL,
                                  XmNdecimalPoints, 0,
                                  XmNshowValue, True,
                                  XmNsensitive, True,
                                  XmNleftAttachment, XmATTACH_FORM,
                                  XmNrightAttachment, XmATTACH_FORM,
                                  XmNtopAttachment, XmATTACH_WIDGET,
                                  XmNtopWidget, label,
                                  NULL);
  if (gridres > 0.0)
    XtVaSetValues(slider2, XmNvalue, (int)gridres, NULL);
  else
  {
    XtVaGetValues(slider2, XmNvalue, &levelInt, NULL);
    gridres=(double)levelInt;
  }
  XtAddCallback(slider2, XmNvalueChangedCallback, (XtCallbackProc)GetSlider, &gridsize);
  sep4=XtVaCreateManagedWidget("sep4", xmSeparatorWidgetClass, form1,
                              XmNtraversalOn, False,
                              XmNleftAttachment, XmATTACH_FORM,
                              XmNrightAttachment, XmATTACH_FORM,
                              XmNtopAttachment, XmATTACH_WIDGET,
                              XmNtopWidget, slider2,
                              NULL);
  XtManageChild(form1);

  CreatePushButtonRow(form, buttons, XtNumber(buttons));
  XtAddCallback(dialog, XmNpopupCallback, (XtCallbackProc)MapBox, (XtPointer)NULL);

  XtManageChild(form);
  XtManageChild(board);
}

void wavefunctionDialogExit(Widget widget, caddr_t which, XmPushButtonCallbackStruct *data)
{
  int found=FALSE;
  register int i=0, j;

  XtDestroyWidget(dialog);
  if (!(int)which)
  {
    iwavef=iwavef_save;
    interp=interp_save;
    level=level_save;
    gridres=gridres_save;
  }
  else
  {
    switch (iwavef)
    {
      case ALL_OFF:           deleteGridObjects();
                              break;
      case BASIS_FUNCTION:
      case BASIS_IN_MO:       selectAtom=TRUE;
					i=ibasfu;
                              break;
      case MOLECULAR_ORBITAL: i=imo;
      case DENSITY:           selectAtom=FALSE;
					for (j=0; j<ngridobjects; j++)
					{
					  if (gridObjects[j].type       == iwavef &&
						gridObjects[j].number     == i      &&
						gridObjects[j].resolution == gridres)
					  {
					    found=TRUE;
					    break;
					  }
					}
                              if (!found) calcmo();
                              break;
    }
  }
  redraw(VIEWER);
}

void changeLevel(Widget widget, struct SLIDER *slider, XmScrollBarCallbackStruct *data)
{
  *(slider->number)=(double)(data->value)/pow((double)10., (double)slider->decimals);
  redraw(VIEWER);
}

void deleteGridObjects(void)
{
  register int i;

  for (i=0; i<ngridobjects; i++)
    fremem((void **)&gridObjects[i].grid);
  fremem((void **)&gridObjects);
  ngridobjects=0;
}
