/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                                 D R A W . C                                  *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1996                   *
*                                                                              *
********************************************************************************
*
* $Id: draw.c,v 1.1 1996/12/10 18:40:22 jrh Exp $
* $Log: draw.c,v $
 * Revision 1.1  1996/12/10  18:40:22  jrh
 * Initial revision
 *
*
*/
#include<math.h>
#include<stdio.h>
#include<X11/Xlib.h>
#include<X11/Intrinsic.h>
#include<X11/StringDefs.h>
#include<X11/keysym.h>
#include<Xm/Xm.h>
#include<GL/gl.h>
#include<GL/glu.h>
#ifdef __osf__
#include<X11/GLw/GLwMDrawA.h>
#else
#include<GL/GLwMDrawA.h>
#endif
#include "viewmol.h"

void wireModel(Dimension);
void stickModel(int);
void balls(double);
void setAtomProperties(struct ELEMENT *);
void drawIntern(void);
void labelAtoms(int);
void drawTitle(Dimension, Dimension, int);
void drawForces(void);
void drawNormalMode(void);
void drawArrow(double, double, double, double, double, double);

extern void setWindowColor(int, Pixel, const float *);
extern int StringWidth(XFontStruct *, char *);
extern int StringHeight(XFontStruct *);
extern void cone(double, double, double, double, double, double, double, int);
extern double dist(double, double, double, double, double, double);
extern void (*drawBegin)(GLenum), (*drawEnd)(void), (*drawVertex3d)(double, double, double);
extern void (*drawNormal3d)(double, double, double);
extern void (*drawColor4fv)(const GLfloat *), (*drawString)(char *, double, double, double, GLuint);
extern void (*drawLineStipple)(GLint, GLushort), (*drawDisable)(GLenum);
extern void (*drawLineWidth)(GLfloat);
extern void (*drawSphere)(GLUquadricObj *, GLdouble, GLint, GLint);
extern void (*drawOrtho)(GLdouble, GLdouble, GLdouble, GLdouble, GLdouble, GLdouble);
extern void (*drawPopMatrix)(void);
extern void raytracerBegin(GLenum);
extern void manual(Widget, caddr_t, caddr_t);
extern char *getStringResource(Widget, char *);
extern void printDialog(Widget, caddr_t, XmAnyCallbackStruct *);
extern void marching_cube(double, double, double, double *grid, double, int,
                          int, int, double, int, void (*)(GLenum), void (*)(void),
                          void (*)(double, double, double),
                          void (*)(double, double, double), int, int);
extern void ellipse(double, double, double, double, double, double, double,
                    double, double, int);
extern void cylinder(double, double, double, double, double, double, double,
                     int, int);
extern char *bfname(int);
extern void raytracerMaterial(struct ELEMENT *);
extern void redraw(int);
extern void *getmem(size_t, size_t);
extern void *expmem(void *, size_t, size_t);
extern void fremem(void **);

extern struct ATOM *atoms;
extern struct BOND *bonds;
extern struct ELEMENT *elements;
extern struct WINDOW windows[];
extern struct INTERNAL *internals;
extern struct NORMAL_MODE *normal_modes;
extern struct OPTIMIZATION *optimization;
extern struct COORDS *history;
extern struct ORBITAL *orbitals;
extern struct GRIDOBJECT *gridObjects;
extern Pixel stdcol[9];
extern Widget topShell;
extern GLfloat light0p[], light1p[];
extern int na, nb, ne, ninternal, nmodes, ngridobjects;
extern int label, mode, showForces, animate, existsUnitCell, showUnitCell, showInertia;
extern int primitive, imo, ibasfu, bfatom, lights, movelight;
extern double *cnm, cycle, amplitude, forceScale, wnScale;
extern double gridres, sphereres;
extern double tinert[3][3];
extern float xrot, yrot, zrot;
extern float xmov, ymov;
extern int rgbMode, picking, swapBuffers, selectAtom;
extern int iwavef, interp, debug, setins;
extern double *grid, radfac, level, weight;
extern char *formBondLength, *formBondAngle, *formTorsionAngle;

void drawBackground(int window, Pixel color, double depthBufferClear)
{
  float background_rgb[4] = {0.0, 0.0, 1.0, 0.0};
  int clear=GL_COLOR_BUFFER_BIT;
  register int i;

  setWindowColor(BACKGROUND, color, windows[window].background_rgb);
  if (depthBufferClear != 0.0)
  {
    glClearDepth(depthBufferClear);
    clear|=GL_DEPTH_BUFFER_BIT;
  }
  glClear(clear);
  if (color == stdcol[SKYBLUE])
  {
    glPushMatrix();
    glOrtho(0.0, 1.0, 0.0, 1.0, 0.0, 1.0);
    glShadeModel(GL_SMOOTH);
    for (i=0; i<=50; i++)
    {
      background_rgb[1]=(float)(200-2*i)/255.;
      setWindowColor(FOREGROUND, color, background_rgb);
      glRectf(0.0, 0.02*(i-1), 1.0, 0.02*i);
    }
    glShadeModel(GL_FLAT);
    glPopMatrix();
  }
}

void drawMolecule(Widget w, caddr_t client_data, GLwDrawingAreaCallbackStruct *data)
{
  static float xModel, yModel, zModel;
  static float xLight0=0.0, yLight0=0.0, zLight0=0.0;
  static float xLight1=0.0, yLight1=0.0, zLight1=0.0;
  GLfloat light0c[4] = {1.0, 1.0, 1.0, 1.0};
  GLfloat light1c[4] = {1.0, 1.0, 1.0, 1.0};
  const float black[4] = {0.0, 0.0, 0.0, 0.0};
  Dimension width, height;
  double boxf;
  int prim=GL_LINE_LOOP;
  register int i, found=0;

  switch (movelight)
  {
    case -1: xModel=xrot;
             yModel=yrot;
             zModel=zrot;
             break;
    case 0:  xLight0=xrot;
             yLight0=yrot;
             zLight0=zrot;
             break;
    case 1:  xLight1=xrot;
             yLight1=yrot;
             zLight1=zrot;
             break;
  }
  if (!picking)
  {
    GLwDrawingAreaMakeCurrent(windows[VIEWER].widget, windows[VIEWER].context);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
  }
  glOrtho(windows[VIEWER].left, windows[VIEWER].right, windows[VIEWER].bottom,
          windows[VIEWER].top, windows[VIEWER].near, windows[VIEWER].far);
  if (!picking)
  {
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    drawBackground(VIEWER, windows[VIEWER].background, windows[VIEWER].far);
  }
  if (primitive == GLU_FILL && windows[VIEWER].mode != WIREMODEL)
  {
    if (lights & 0x1)
    {
      glPushMatrix();
      glRotatef(xLight0, 1.0, 0.0, 0.0);
      glRotatef(yLight0, 0.0, 1.0, 0.0);
      glRotatef(zLight0, 0.0, 0.0, 1.0);
      glLightfv(GL_LIGHT0, GL_POSITION, light0p);
      glLightfv(GL_LIGHT0, GL_DIFFUSE,  light0c);
      glPopMatrix();
    }
    if (lights & 0x2)
    {
      glPushMatrix();
      glRotatef(xLight1, 1.0, 0.0, 0.0);
      glRotatef(yLight1, 0.0, 1.0, 0.0);
      glRotatef(zLight1, 0.0, 0.0, 1.0);
      glLightfv(GL_LIGHT1, GL_POSITION, light1p);
      glLightfv(GL_LIGHT1, GL_DIFFUSE,  light1c);
      glPopMatrix();
    }
  }
  glTranslatef(xmov, ymov, 0.0);
  glRotatef(xModel, 1.0, 0.0, 0.0);
  glRotatef(yModel, 0.0, 1.0, 0.0);
  glRotatef(zModel, 0.0, 0.0, 1.0);

  XtVaGetValues(windows[VIEWER].widget, XtNwidth, &width, XtNheight, &height, NULL);
  if (windows[VIEWER].mode == WIREMODEL || primitive == GLU_POINT)
  {
    glShadeModel(GL_FLAT);
    wireModel((width+height)/2);
  }
  if (primitive != GLU_FILL || windows[VIEWER].mode == WIREMODEL)
    glShadeModel(GL_FLAT);
  else
  {
    glShadeModel(GL_SMOOTH);
    glEnable(GL_DEPTH_TEST);
    glDepthFunc(GL_LESS);
    glEnable(GL_LIGHTING);
    if (lights & 0x1) glEnable(GL_LIGHT0);
    if (lights & 0x2) glEnable(GL_LIGHT1);
  }
  if (windows[VIEWER].mode == STICKMODEL || windows[VIEWER].mode == BALLMODEL)
    stickModel(FALSE);
  if (windows[VIEWER].mode == STICKMODEL)
    balls(-atoms[na].rad);
  if (windows[VIEWER].mode == BALLMODEL)
    balls(0.5);
  if (windows[VIEWER].mode == CUPMODEL)
  {
    balls(1.3);
    stickModel(TRUE);
  }
  if ((imo != -1 || ibasfu != 0 || iwavef != ALL_OFF) && !selectAtom)
  {
/*  if (drawBegin == glBegin)
    { */
      for (i=0; i<ngridobjects; i++)
      {
        if (gridObjects[i].type == iwavef)
        {
          if ((iwavef == MOLECULAR_ORBITAL && gridObjects[i].number == imo) ||
              ((iwavef == BASIS_FUNCTION || iwavef == BASIS_IN_MO) && gridObjects[i].number == ibasfu) ||
		  iwavef == DENSITY)
          {
            found=i+1;
            if (debug) printf("Found MO/basis function: %d\n", found);
            break;
          }
        } 
      }
/*  } */
    if (found)
    {
      boxf=windows[VIEWER].far;
      gridres=gridObjects[found-1].resolution;
      (*drawLineWidth)((GLfloat)1.);
      switch (primitive)
      {
        case GLU_POINT: prim=GL_POINTS;
                        break;
        case GLU_LINE:  prim=GL_LINE_LOOP;
                        break;
        case GLU_FILL:  prim=GL_TRIANGLE_STRIP;
                        break;
      }
	if (drawBegin == raytracerBegin) prim=GL_LINE_LOOP;
      if (primitive == GLU_FILL)
      {
        glShadeModel(GL_SMOOTH);
        glEnable(GL_DEPTH_TEST);
        glDepthFunc(GL_LESS);
        glEnable(GL_LIGHTING);
        glEnable(GL_LIGHT0);
        glEnable(GL_LIGHT1);
      }
      for (i=0; i<ne; i++)
        if (!strcmp(elements[i].symbol, "Ps")) break;
      setAtomProperties(&elements[i]);
      marching_cube(-boxf, -boxf, -boxf, gridObjects[found-1].grid,
                    2.0*boxf/gridres, (int)(gridres), (int)(gridres),
                    (int)(gridres), level, prim, drawBegin, drawEnd,
                    drawVertex3d, drawNormal3d, interp, debug);
      if (iwavef != DENSITY)
      {
        for (i=0; i<ne; i++)
          if (!strcmp(elements[i].symbol, "Ms")) break;
        setAtomProperties(&elements[i]);
        level=(-level);
        marching_cube(-boxf, -boxf, -boxf, gridObjects[found-1].grid,
                       2.0*boxf/gridres, (int)(gridres), (int)(gridres),
                       (int)(gridres), level, prim, drawBegin, drawEnd,
                       drawVertex3d, drawNormal3d, interp, debug);
        level=(-level);
      }
    }
  }
  if (primitive == GLU_FILL)
  {
    glDisable(GL_DEPTH_TEST);
    glShadeModel(GL_FLAT);
    glDisable(GL_LIGHTING);
    if (lights & 0x1) glDisable(GL_LIGHT0);
    if (lights & 0x2) glDisable(GL_LIGHT1);
  }

  if (ninternal && !picking) drawIntern();
  if (label) labelAtoms(LABEL);
  if (setins) labelAtoms(INS);
  if (showForces && !picking) drawForces();
  if (showInertia)
  {
    (*drawLineWidth)((GLfloat)1.);
    setWindowColor(FOREGROUND, stdcol[BLACK], black);
    ellipse(0.0, 0.0, 0.0, tinert[0][0], tinert[0][1], tinert[0][2],
            tinert[1][0], tinert[1][1], tinert[1][2], 40);
    ellipse(0.0, 0.0, 0.0, tinert[1][0], tinert[1][1], tinert[1][2],
            tinert[2][0], tinert[2][1], tinert[2][2], 40);
    ellipse(0.0, 0.0, 0.0, tinert[2][0], tinert[2][1], tinert[2][2],
            tinert[0][0], tinert[0][1], tinert[0][2], 40);
  }
  if (mode != -1 && animate == ARROWS && cnm != NULL) drawNormalMode();
  if (!picking) drawTitle(width, height, found);
  if (swapBuffers) GLwDrawingAreaSwapBuffers(windows[VIEWER].widget);
}

void wireModel(Dimension width)
{ 
  struct BONDORDER *bo;
  double x, y, z;
  int first, second;
  register int i;

  (*drawLineWidth)((GLfloat)width/100.);
  for (i=0; i<nb; i++)
  {
    first=bonds[i].first;
    if (!strncmp(atoms[first].name, "Uc", 2) && !showUnitCell) continue;
    second=bonds[i].second;
    x=atoms[first].x+bonds[i].frac*(atoms[second].x-atoms[first].x);
    y=atoms[first].y+bonds[i].frac*(atoms[second].y-atoms[first].y);
    z=atoms[first].z+bonds[i].frac*(atoms[second].z-atoms[first].z);
    if (picking)
    {
      glLoadName(first+1);
      (*drawBegin)(GL_LINES);
    }
    else
      (*drawBegin)(GL_LINE_STRIP);
    setAtomProperties(atoms[first].element);
    (*drawVertex3d)(atoms[first].x, atoms[first].y, atoms[first].z);
    (*drawVertex3d)(x, y, z);
    if (picking)
    {
      (*drawEnd)();
      glLoadName(second+1);
      (*drawBegin)(GL_LINES);
      (*drawVertex3d)(x, y, z);
    }
    setAtomProperties(atoms[second].element);
    (*drawVertex3d)(atoms[second].x, atoms[second].y, atoms[second].z);
    (*drawEnd)();
    if (bonds[i].order != (struct BONDORDER *)NULL)
    {
      bo=bonds[i].order;
      (*drawBegin)(GL_LINE_STRIP);
      setAtomProperties(atoms[first].element);
      (*drawVertex3d)(bo->x1, bo->y1, bo->z1);
      x=bo->x1+bonds[i].frac*(bo->x2-bo->x1);
      y=bo->y1+bonds[i].frac*(bo->y2-bo->y1);
      z=bo->z1+bonds[i].frac*(bo->z2-bo->z1);
      (*drawVertex3d)(x, y, z);
      setAtomProperties(atoms[second].element);
      (*drawVertex3d)(bo->x2, bo->y2, bo->z2);
      (*drawEnd)();
      if (bo->n == 3)
      {
        (*drawBegin)(GL_LINE_STRIP);
        setAtomProperties(atoms[first].element);
        (*drawVertex3d)(bo->x3, bo->y3, bo->z3);
        x=bo->x3+bonds[i].frac*(bo->x4-bo->x3);
        y=bo->y3+bonds[i].frac*(bo->y4-bo->y3);
        z=bo->z3+bonds[i].frac*(bo->z4-bo->z3);
        (*drawVertex3d)(x, y, z);
        setAtomProperties(atoms[second].element);
        (*drawVertex3d)(bo->x4, bo->y4, bo->z4);
        (*drawEnd)();
      }
    }
  }
  x=windows[VIEWER].far/100.;
  for (i=0; i<na; i++)
  {
    if (!strncmp(atoms[i].name, "Uc", 2) && !showUnitCell) continue;
    if (atoms[i].nbonds == 0)
    {
      if (picking) glLoadName(i+1);
      setAtomProperties(atoms[i].element);
      (*drawBegin)(GL_LINES);
      (*drawVertex3d)(atoms[i].x-x, atoms[i].y, atoms[i].z);
      (*drawVertex3d)(atoms[i].x+x, atoms[i].y, atoms[i].z);
      (*drawVertex3d)(atoms[i].x, atoms[i].y-x, atoms[i].z);
      (*drawVertex3d)(atoms[i].x, atoms[i].y+x, atoms[i].z);
      (*drawVertex3d)(atoms[i].x, atoms[i].y, atoms[i].z-x);
      (*drawVertex3d)(atoms[i].x, atoms[i].y, atoms[i].z+x);
      (*drawEnd)();
    }
  }
}

void stickModel(int onlyUnitCell)
{
  double x, y, z;
  int first, second;
  register int i;

  (*drawLineWidth)(1.);
  for (i=0; i<nb; i++)
  {
    first=bonds[i].first;
    if (!strncmp(atoms[first].name, "Uc", 2))
    {
      if (!showUnitCell) continue;
    }
    else
    {
      if (onlyUnitCell) continue;
    }
    second=bonds[i].second;
    x=atoms[first].x+bonds[i].frac*(atoms[second].x-atoms[first].x);
    y=atoms[first].y+bonds[i].frac*(atoms[second].y-atoms[first].y);
    z=atoms[first].z+bonds[i].frac*(atoms[second].z-atoms[first].z);
    setAtomProperties(atoms[first].element);
    glLoadName(first+1);
    cylinder(atoms[first].x, atoms[first].y, atoms[first].z, x, y, z, atoms[na].rad, (int)sphereres, primitive);
    setAtomProperties(atoms[second].element);
    glLoadName(second+1);
    cylinder(atoms[second].x, atoms[second].y, atoms[second].z, x, y, z, atoms[na].rad, (int)sphereres, primitive);
  }
}

void balls(double fac)
{
  GLUquadricObj *obj;
  register double rad;
  register int i;

  (*drawLineWidth)(1.);
  obj=gluNewQuadric();
  gluQuadricDrawStyle(obj, primitive);
  if (primitive == GLU_FILL) gluQuadricNormals(obj, GLU_SMOOTH);
  else                       gluQuadricNormals(obj, GLU_NONE);
  for (i=0; i<na; i++)
  {
    if (!strncmp(atoms[i].name, "Uc", 2))
    {
      if (!showUnitCell) continue;
      fac=1.0;
    }
    if (fac < 0.0)
      rad=-fac;
    else
      rad=fac*atoms[i].rad;
    glPushMatrix();
    glTranslated(atoms[i].x, atoms[i].y, atoms[i].z);
    setAtomProperties(atoms[i].element);
    glLoadName(i+1);
    (*drawSphere)(obj, rad, (int)sphereres, (int)sphereres);
    glPopMatrix();
  }
}

void drawIntern(void)
{
  const float black[4] = {0.0, 0.0, 0.0, 0.0};
  char line[10], *form;
  register double x, y, z;
  register int i, j, k;

  setWindowColor(FOREGROUND, stdcol[BLACK], black);
  glEnable(GL_LINE_STIPPLE);
  (*drawLineStipple)(1, 0xf0f0);
  (*drawLineWidth)((GLfloat)1.);
  for (i=0; i<ninternal; i++)
  {
    switch (internals[i].type)
    {
      case BONDAVERAGE: j=internals[i].atoms[0];
                        x=atoms[j].x+0.05;
                        y=atoms[j].y+0.05;
                        z=atoms[j].z+0.05;
                        form=formBondLength;
                        break;
      case BONDLENGTH:  j=internals[i].atoms[0];
                        k=internals[i].atoms[1];
                        x=(atoms[j].x+atoms[k].x)/2.0+0.05;
                        y=(atoms[j].y+atoms[k].y)/2.0+0.05;
                        z=(atoms[j].z+atoms[k].z)/2.0+0.05;
                        form=formBondLength;
                        (*drawBegin)(GL_LINES);
                        (*drawVertex3d)(atoms[j].x, atoms[j].y, atoms[j].z);
                        (*drawVertex3d)(atoms[k].x, atoms[k].y, atoms[k].z);
                        (*drawEnd)();
                        break;
      case ANGLE:       j=internals[i].atoms[1];
                        x=atoms[j].x+0.05;
                        y=atoms[j].y+0.05;
                        z=atoms[j].z+0.05;
                        form=formBondAngle;
                        (*drawBegin)(GL_LINE_STRIP);
                        j=internals[i].atoms[0];
                        (*drawVertex3d)(atoms[j].x, atoms[j].y, atoms[j].z);
                        j=internals[i].atoms[1];
                        (*drawVertex3d)(atoms[j].x, atoms[j].y, atoms[j].z);
                        j=internals[i].atoms[2];
                        (*drawVertex3d)(atoms[j].x, atoms[j].y, atoms[j].z);
                        (*drawEnd)();
                        break;
      case TORSION:     j=internals[i].atoms[1];
                        k=internals[i].atoms[2];
                        x=(atoms[j].x+atoms[k].x)/2.0+0.05;
                        y=(atoms[j].y+atoms[k].y)/2.0+0.05;
                        z=(atoms[j].z+atoms[k].z)/2.0+0.05;
                        form=formTorsionAngle;
                        (*drawBegin)(GL_LINE_STRIP);
                        j=internals[i].atoms[0];
                        (*drawVertex3d)(atoms[j].x, atoms[j].y, atoms[j].z);
                        j=internals[i].atoms[1];
                        (*drawVertex3d)(atoms[j].x, atoms[j].y, atoms[j].z);
                        j=internals[i].atoms[2];
                        (*drawVertex3d)(atoms[j].x, atoms[j].y, atoms[j].z);
                        j=internals[i].atoms[3];
                        (*drawVertex3d)(atoms[j].x, atoms[j].y, atoms[j].z);
                        (*drawEnd)();
                        break;
      default:          (*drawDisable)(GL_LINE_STIPPLE);
                        return;
    }
    sprintf(line, form, internals[i].value);
    (*drawString)(line, x, y, z, windows[VIEWER].GLfontId);
  }
  (*drawDisable)(GL_LINE_STIPPLE);
}

void labelAtoms(int what)
{
  const float black[4] = {0.0, 0.0, 0.0, 0.0};
  char name[MAXLENLINE];
  register int i;

  setWindowColor(FOREGROUND, stdcol[BLACK], black);
  for (i=0; i<na; i++)
  {
    if (strncmp(atoms[i].name, "Uc", 2))
    {
      switch(what)
      {
        case LABEL: sprintf(name, "%s%d", atoms[i].name, i+1);
                    break;
        case INS:   sprintf(name, "%f", atoms[i].neutron_scatterfac);
                    break;
      }
      glLoadName(i+1);
      (*drawString)(name, atoms[i].x+0.05, atoms[i].y+0.05, atoms[i].z+0.05, windows[VIEWER].GLfontId);
    }
  }
}

void drawTitle(Dimension w, Dimension h, int found)
{
  const float black[4] = {0.0, 0.0, 0.0, 0.0};
  const float blue[4] = {0.0, 0.0, 1.0, 0.0};
  const float red[4] = {1.0, 0.0, 0.0, 0.0};
  char line1[MAXLENLINE], line2[MAXLENLINE], *c, *d;
  register int i, j;

  if (mode != -1)
  {
    c=getStringResource(topShell, "wavenumberTitle");
    sprintf(line1, c, normal_modes[mode].sym, wnScale*normal_modes[mode].wavenumber);
    strcpy(line2, "");
  }
  else if (selectAtom)
  {
    c=getStringResource(topShell, "selectAtomTitle");
    strcpy(line1, c);
    strcpy(line2, "");
  }
  else if (setins)
  {
    c=getStringResource(topShell, "selectINSTitle");
    sprintf(line1, c, weight);
    strcpy(line2, "");
  }
  else if (found)
  {
    if (iwavef == BASIS_FUNCTION && ibasfu != 0)
    {
      c=getStringResource(topShell, "basisfunctionTitle");
      sprintf(line1, c, ibasfu+1, atoms[bfatom].name, bfatom+1, bfname(ibasfu));
      c=getStringResource(topShell, "isosurfacePlusMinus");
      sprintf(line2, c, level, (-level));
    }
    else if (iwavef == BASIS_IN_MO && ibasfu != 0)
    {
      c=getStringResource(topShell, "basisfunctionInMOTitle");
      sprintf(line1, c, ibasfu+1, imo+1, atoms[bfatom].name, bfatom+1,
              orbitals[imo].coeff[ibasfu], bfname(ibasfu));
      c=getStringResource(topShell, "isosurfacePlusMinus");
      sprintf(line2, c, level, (-level));
    }
    else if (iwavef == MOLECULAR_ORBITAL && imo != -1)
    {
      c=getStringResource(topShell, "molecularOrbitalTitle");
      sprintf(line1, c, imo+1, orbitals[imo].symmetry, orbitals[imo].energy);
      c=getStringResource(topShell, "isosurfacePlusMinus");
      sprintf(line2, c, level, (-level));
    }
    else if (iwavef == DENSITY)
    {
      c=getStringResource(topShell, "electronDensityTitle");
      sprintf(line1, c);
      c=getStringResource(topShell, "isosurfacePlus");
      sprintf(line2, c, level);
    }
    else
      return;
  }
  else if (windows[HISTORY].widget != NULL)
  {
    c=getStringResource(topShell, "historyTitle");
    sprintf(line1, c, (int)cycle, optimization[(int)cycle-1].energy,
            optimization[(int)cycle-1].gnorm);
    line2[0]='\0';
  }
  else
    return;

  setWindowColor(FOREGROUND, stdcol[BLACK], black);
  glMatrixMode(GL_PROJECTION);
  glPushMatrix();
  glLoadIdentity();
  (*drawOrtho)(0.0, (double)w, 0.0, (double)h, 0.0, 1.0);
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glLoadIdentity();
  i=(w-StringWidth(windows[VIEWER].font, line1))/2;
  j=StringHeight(windows[VIEWER].font);
  (*drawString)(line1, (double)i, (double)(h-2*j), 0.0, windows[VIEWER].GLfontId);
  if (line2[0] != '\0')
  {
    i=(w-StringWidth(windows[VIEWER].font, line2))/2;
    if ((c=strchr(line2, ' ')) != NULL) *c='\0';
    (*drawString)(line2, (double)i, (double)(h-4*j), 0.0, windows[VIEWER].GLfontId);
    if (c != NULL)
    {
      i+=StringWidth(windows[VIEWER].font, line2);
      setWindowColor(FOREGROUND, stdcol[RED], red);
      if ((d=strchr(c+1, ',')) != NULL) *d='\0';
      *c=' ';
      (*drawString)(c, (double)i, (double)(h-4*j), 0.0, windows[VIEWER].GLfontId);
      if (d != NULL)
      {
        i+=StringWidth(windows[VIEWER].font, c);
        setWindowColor(FOREGROUND, stdcol[BLUE], blue);
        *d=',';
        (*drawString)(d, (double)i, (double)(h-4*j), 0.0, windows[VIEWER].GLfontId);
      }
    }
  }
  glMatrixMode(GL_PROJECTION);
  (*drawPopMatrix)();
  glMatrixMode(GL_MODELVIEW);
  glPopMatrix();
}

void drawForces(void)
{
  const float black[4] = {0.0, 0.0, 0.0, 0.0};
  int primitiveSave=primitive;
  register int i, j;

  if (existsUnitCell)
    j=(na-8)*((int)cycle-1);
  else
    j=na*((int)cycle-1);
  setWindowColor(FOREGROUND, stdcol[BLACK], black);
  (*drawLineWidth)((GLfloat)1.);
  if (drawBegin != glBegin) primitive=GLU_LINE;
  for (i=0; i<na; i++)
    drawArrow(atoms[i].x, atoms[i].y, atoms[i].z, -100.0*forceScale*history[j+i].gx,
              -100.0*forceScale*history[j+i].gy, -100.0*forceScale*history[j+i].gz);
  if (drawBegin != glBegin) primitive=primitiveSave;
}

void drawNormalMode(void)
{
  const float black[4] = {0.0, 0.0, 0.0, 0.0};
  int primitiveSave=primitive;
  register int i, j;

  setWindowColor(FOREGROUND, stdcol[BLACK], black);
  j=0;
  if (drawBegin != glBegin) primitive=GLU_LINE;
  for (i=0; i<na; i++)
  {
    drawArrow(atoms[i].x, atoms[i].y, atoms[i].z, amplitude*cnm[mode+nmodes*j],
              amplitude*cnm[mode+nmodes*(j+1)], amplitude*cnm[mode+nmodes*(j+2)]);
    j+=3;
  }
  if (drawBegin != glBegin) primitive=primitiveSave;
}

void drawArrow(double x1, double y1, double z1, double x2, double y2, double z2)
{
  double length;

  if ((length=dist(x1, y1, z1, x1+x2, y1+y2, z1+z2)) > 1.0e-04)
  {
    if (length > 0.2*windows[VIEWER].top)
      cylinder(x1, y1, z1, x1+0.8*x2, y1+0.8*y2, z1+0.8*z2, 0.01*length,
              (int)sphereres, primitive);
    else
    {
      (*drawLineWidth)((GLfloat)1.);
      (*drawBegin)(GL_LINES);
      (*drawVertex3d)(x1, y1, z1);
      (*drawVertex3d)(x1+0.8*x2, y1+0.8*y2, z1+0.8*z2);
      (*drawEnd)();
    }
    cone(x1+0.8*x2, y1+0.8*y2, z1+0.8*z2, x1+x2, y1+y2, z1+z2,
         0.03*length, (int)sphereres);
  }
}

void setAtomProperties(struct ELEMENT *element)
{
  GLfloat v[4];

  if (drawBegin == raytracerBegin) raytracerMaterial(element);

  if (rgbMode)
  {
    v[0]=0.5*(element->dark[0]+element->light[0]);
    v[1]=0.5*(element->dark[1]+element->light[1]);
    v[2]=0.5*(element->dark[2]+element->light[2]);
    v[3]=0.0;
  }
  if (primitive == GLU_FILL && (windows[VIEWER].mode != WIREMODEL ||
      !strcmp(element->symbol, "Ps") || !strcmp(element->symbol, "Ms")))
  {
    if (rgbMode)
    {
      glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT, element->ambient);
      glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, v);
      glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, element->specular);
      glMaterialfv(GL_FRONT_AND_BACK, GL_EMISSION, element->emission);
      glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, element->shininess);
    }
    else
    {
      glMaterialiv(GL_FRONT_AND_BACK, GL_COLOR_INDEXES, element->colormap);
      glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, element->shininess);
    }
  }
  else
  {
    if (rgbMode)
      (*drawColor4fv)(v);
    else
      glIndexi(element->colormap[1]);
  }
}

void viewerKeyAction(KeySym keysym)
{
  switch (keysym)
  {
    case XK_F1:          manual((Widget)0, (caddr_t)0, (caddr_t)0);
                         break;
    case XK_Print:       printDialog((Widget)0, (caddr_t)VIEWER, (XmAnyCallbackStruct *)0);
                         break;
    case XK_KP_Add:
    case XK_plus:        forceScale*=1.4;
                         break;
    case XK_KP_Subtract:
    case XK_minus:       forceScale/=1.4;
                         break;
    case XK_Up:          windows[VIEWER].top/=1.5;
                         windows[VIEWER].bottom/=1.5;
                         windows[VIEWER].right/=1.5;
                         windows[VIEWER].left/=1.5;
                         break;
    case XK_Down:        windows[VIEWER].top*=1.5;
                         windows[VIEWER].bottom*=1.5;
                         windows[VIEWER].right*=1.5;
                         windows[VIEWER].left*=1.5;
                         break;
  }
  redraw(VIEWER);
}
