/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                               D R A W E L . C                                *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1996                   *
*                                                                              *
********************************************************************************
*
* $Id: drawel.c,v 1.1 1996/12/10 18:40:27 jrh Exp $
* $Log: drawel.c,v $
 * Revision 1.1  1996/12/10  18:40:27  jrh
 * Initial revision
 *
*
*/
#include<math.h>
#include<stdio.h>
#include<X11/Intrinsic.h>
#include<X11/StringDefs.h>
#include<X11/keysym.h>
#include<Xm/Xm.h>
#include<GL/gl.h>
#ifdef __osf__
#include<X11/GLw/GLwMDrawA.h>
#else
#include<GL/GLwMDrawA.h>
#endif
#include "viewmol.h"

extern double makeTics(double, double, double *, char *);
extern void setWindowColor(int, Pixel, const float*);
extern void (*drawBegin)(GLenum), (*drawEnd)(void), (*drawVertex2d)(double, double);
extern void (*drawString)(char *, double, double, double, GLuint);
extern void (*drawLineStipple)(GLint, GLushort), (*drawDisable)(GLenum);
extern void (*drawLineWidth)(GLfloat);
extern void printDialog(Widget, caddr_t, XmAnyCallbackStruct *);
extern void pixwor(Dimension, Dimension, GLdouble, GLdouble, GLdouble, GLdouble,
                   double *, double *);
extern void drawBackground(int, Pixel, float);
extern int StringWidth(XFontStruct *, char *);
extern void setMenuItem(int, int, int);
extern void fremem(void **);
extern void deleteGridObjects(void);
extern void redraw(int);

extern struct ORBITAL *orbitals;
extern struct WINDOW windows[];
extern Pixel stdcol[9];
extern double denres, *grid;
extern int unit, needMoloch;
extern int imo, imosav, nbasfu;
extern int picking, swapBuffers;

void drawMODiagram(Widget w, caddr_t client_data, GLwDrawingAreaCallbackStruct *data)
{
  Dimension width, height;
  char line[15], trans[15];
  char form[8], units[7];
  double scan[500];
  double eunit=1.0, e1h, e2h, e;
  double xpix, ypix, strl=0.0e0;
  double ticMark, ticSave, ticInc;
  double smax, shape, center, ehelp, fac;
  double off1, off2, off;
  const float red[4]   = {1.0, 0.0, 0.0, 0.0};
  const float blue[4]  = {0.0, 0.0, 1.0, 0.0};
  const float white[4] = {1.0, 1.0, 1.0, 0.0};
  register double l;
  register int i, j;

/* This subroutine draws a MO energy diagram */

/* Convert units from Hartree/particle */
  switch (unit)
  {
    case HARTREE: eunit=1.0e0;           /* to Hartree/particle */
			strcpy(units, "Eh");
			break;
    case KJ_MOL:  eunit=2625.5001e0;     /* to kJ/mol */
			strcpy(units, "kJ/mol");
                  break;
    case EV:      eunit=27.211611e0;     /* to eV */
			strcpy(units, "eV");
			break;
    case CM:      eunit=4.3598149e6/(6.626176e0*2.99792458e0);   /* to 1/cm (E/hc) */
                  strcpy(units, "1/cm");
                  break;
  }
  XtVaGetValues(windows[MO].widget, XtNwidth, &width, XtNheight, &height, NULL);
  if (!picking)
  {
    GLwDrawingAreaMakeCurrent(windows[MO].widget, windows[MO].context);
    glLoadIdentity();
  }
  pixwor(width, height, windows[MO].left, windows[MO].right, windows[MO].bottom,
	   windows[MO].top, &xpix, &ypix);
  drawBackground(MO, windows[MO].background, 0.0e0);
  setWindowColor(FOREGROUND, windows[MO].foreground, windows[MO].foreground_rgb);
  glOrtho(windows[MO].left, windows[MO].right, windows[MO].bottom,
	    windows[MO].top, windows[MO].near, windows[MO].far);
  e1h=windows[MO].bottom*eunit;
  e2h=windows[MO].top*eunit;
  glShadeModel(GL_FLAT);

/* Calculate and draw tic marks */

  ticInc=makeTics(e1h, e2h, &ticMark, form);
  ticSave=ticMark;
  do
  {
    if (fabs(ticMark) < 1.0e-5) ticMark=0.0;
    sprintf(line, form, ticMark);
    l=(double)(StringWidth(windows[MO].font, line)+9.e0);
    strl= strl > l ? strl : l;
    (*drawString)(line, 2.e0*xpix, ticMark/eunit-5.e0*ypix, 0.0, windows[MO].GLfontId);
    ticMark+=ticInc;
  } while (ticMark < e2h);
  strl*=xpix;
  ticMark=ticSave;

  (*drawLineWidth)((GLfloat)1.);
  glEnable(GL_LINE_STIPPLE);                             /* Dotted lines */
  (*drawLineStipple)(1, 0x3333);
  (*drawBegin)(GL_LINES);
  (*drawVertex2d)(strl, 0.0e0);
  (*drawVertex2d)(1.0e0, 0.0e0);
  (*drawEnd)();
  (*drawDisable)(GL_LINE_STIPPLE);
  (*drawBegin)(GL_LINES);
  (*drawVertex2d)(strl, windows[MO].bottom);
  (*drawVertex2d)(strl, windows[MO].top);
  (*drawEnd)();

  do
  {
    (*drawBegin)(GL_LINES);
    (*drawVertex2d)(strl-5.e0*xpix, ticMark/eunit);
    (*drawVertex2d)(strl+5.e0*xpix, ticMark/eunit);
    (*drawEnd)();
    ticMark+=ticInc;
  } while (ticMark < e2h);
  (*drawString)(units, 2.e0*xpix, (ticMark-5.e0*ticInc/2.e0)/eunit, 0.0, windows[MO].GLfontId);

/* Draw energy levels */

  if (windows[MO].mode == DENSITY_OF_STATES)
  {
    e=windows[MO].bottom;
    smax=0.0;
    for (i=0; i<500; i++)
    {
      scan[i]=0.0e0;
	for (j=0; j<nbasfu; j++)
	{
	  shape=e-orbitals[j].energy;
	  scan[i]+=exp(-shape*shape/denres);
	}
	smax= smax > scan[i] ? smax : scan[i];
	e+=(windows[MO].top-windows[MO].bottom)/500.e0;
    }
    (*drawBegin)(GL_LINE_STRIP);
    (*drawVertex2d)(scan[0]*(1.e0-strl)/smax+strl, windows[MO].bottom);
    for (i=1; i<500; i++)
	(*drawVertex2d)(scan[i]*(1.e0-strl)/smax+strl, windows[MO].bottom+
		     (double)i*(windows[MO].top-windows[MO].bottom)/500.e0);
    (*drawEnd)();
  }
  else
  {
    for (i=0; i<nbasfu; i++)
    {
      if (i != imo)
	{
        glLoadName(i+1);
        (*drawBegin)(GL_LINES);
	  (*drawVertex2d)(strl+20.e0*xpix, orbitals[i].energy);
	  (*drawVertex2d)(1.0e0-20.e0*xpix, orbitals[i].energy);
        (*drawEnd)();
      }
    }

/* Draw the selected energy level with symmetry and energy
   in a centered box */

    if (imo != (-1))
    {
	setWindowColor(FOREGROUND, stdcol[RED], red);
      glLoadName(imo+1);
	(*drawBegin)(GL_LINES);
	(*drawVertex2d)(strl+20.e0*xpix, orbitals[imo].energy);
	(*drawVertex2d)(1.0e0-20.e0*xpix, orbitals[imo].energy);
	(*drawEnd)();
      center=0.5e0+strl/2.e0;
      if (imosav != (-1) && imosav != imo)
	{
        ehelp=orbitals[imo].energy-orbitals[imosav].energy;
        (*drawBegin)(GL_LINES);
	  (*drawVertex2d)(strl+20.e0*xpix, orbitals[imosav].energy);
        (*drawVertex2d)(1.0e0-20.e0*xpix, orbitals[imosav].energy);
        (*drawEnd)();
	  setWindowColor(FOREGROUND, stdcol[BLUE], blue);
        (*drawBegin)(GL_LINES);
	  (*drawVertex2d)(center, orbitals[imosav].energy);
        (*drawVertex2d)(center, orbitals[imo].energy);
        (*drawEnd)();
        if (imosav < imo)
	    fac=-10.e0;
        else
	    fac=10.e0;
        (*drawBegin)(GL_LINE_STRIP);
	  (*drawVertex2d)(center-3.e0*xpix, orbitals[imo].energy+fac*ypix);
	  (*drawVertex2d)(center, orbitals[imo].energy);
	  (*drawVertex2d)(center+3.e0*xpix, orbitals[imo].energy+fac*ypix);
	  (*drawEnd)();
        sprintf(line, "%.6f", eunit*ehelp);
	  sprintf(trans, "%s -> %s", orbitals[imosav].symmetry, orbitals[imo].symmetry);
        ehelp=fabs(ehelp)/2.e0+orbitals[imo < imosav ? imo : imosav].energy+13.*ypix;
	}
      else
	{
        ehelp=orbitals[imo].energy;
	  sprintf(line, "%.6f", eunit*orbitals[imo].energy);
	  sprintf(trans, "%s", orbitals[imo].symmetry);
      }
      off1=(double)(StringWidth(windows[MO].font, trans)+4)/2.e0;
      off2=(double)(StringWidth(windows[MO].font, line)+4)/2.e0;
      off=xpix*(off1 > off2 ? off1 : off2);
      setWindowColor(FOREGROUND, stdcol[WHITE], white);
      if (ehelp-windows[MO].bottom < 27.e0*ypix)
	{
        glRectd(center-off, ehelp+27.e0*ypix, center+off, ehelp);
	  setWindowColor(FOREGROUND, windows[MO].foreground, windows[MO].foreground_rgb);
        (*drawBegin)(GL_LINE_LOOP);
	  (*drawVertex2d)(center-off, ehelp+27.e0*ypix);
	  (*drawVertex2d)(center-off, ehelp);
	  (*drawVertex2d)(center+off, ehelp);
	  (*drawVertex2d)(center+off, ehelp+27.e0*ypix);
	  (*drawEnd)();
	  (*drawString)(trans, center-(off1-2.e0)*xpix, ehelp+16.e0*ypix, 0.0, windows[MO].GLfontId);
	  (*drawString)(line, center-(off2-2.e0)*xpix, ehelp+3.e0*ypix, 0.0, windows[MO].GLfontId);
      }
      else
      {
        glRectd(center-off, ehelp-27.e0*ypix, center+off, ehelp);
	  setWindowColor(FOREGROUND, windows[MO].foreground, windows[MO].foreground_rgb);
        (*drawBegin)(GL_LINE_LOOP);
	  (*drawVertex2d)(center-off, ehelp-27.e0*ypix);
	  (*drawVertex2d)(center-off, ehelp);
	  (*drawVertex2d)(center+off, ehelp);
	  (*drawVertex2d)(center+off, ehelp-27.e0*ypix);
	  (*drawEnd)();
	  (*drawString)(trans, center-(off1-2.e0)*xpix, ehelp-11.e0*ypix, 0.0, windows[MO].GLfontId);
        (*drawString)(line, center-(off2-2.e0)*xpix, ehelp-24.e0*ypix, 0.0, windows[MO].GLfontId);
      }
    }
  }
  if (swapBuffers) GLwDrawingAreaSwapBuffers(windows[MO].widget);
}

void quitMODiagram(Widget w, caddr_t client_data, XmAnyCallbackStruct *data)
{
  deleteGridObjects();
  GLwDrawingAreaMakeCurrent(windows[VIEWER].widget, windows[VIEWER].context);
  fremem((void **)&windows[MO].font);
  XtDestroyWidget(XtParent(XtParent(windows[MO].widget)));
  windows[MO].widget=0;
  setMenuItem(VIEWER, 7, True);
  imo=(-1);
  imosav=(-1);
  redraw(VIEWER);
}

void setTransition(Widget w, caddr_t dummy, XmToggleButtonCallbackStruct *data)
{
  if (data->set)
    imosav=imo;
  else
    imosav=(-1);
}

void MODiagramKeyAction(KeySym keysym)
{
  int imoSave=imo;

  switch (keysym)
  {
    case XK_Print: printDialog((Widget)0, (caddr_t)MO, (XmAnyCallbackStruct *)0);
			 break;
    case XK_Down:  if (--imo < 0) imo=nbasfu;
		       break;
    case XK_Up:    if (++imo > nbasfu) imo=0;
			 break;
  }
  if (imo != imoSave && grid != NULL)
    fremem((void **)&grid);
  if (orbitals[imo].occupation == 0.0 && needMoloch) setMenuItem(VIEWER, 6, False);
  else                                               setMenuItem(VIEWER, 6, True);
}
