/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                                G E T R C . C                                 *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1996                   *
*                                                                              *
********************************************************************************
*
* $Id: getrc.c,v 1.1 1996/12/10 18:41:02 jrh Exp $
* $Log: getrc.c,v $
 * Revision 1.1  1996/12/10  18:41:02  jrh
 * Initial revision
 *
*
*/
#include<ctype.h>
#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<sys/utsname.h>
#include<X11/Xlib.h>
#include<X11/StringDefs.h>
#include<X11/Intrinsic.h>
#include<Xm/Xm.h>
#ifdef __osf__
#include<X11/GLw/GLwMDrawA.h>
#else
#include<GL/GLwMDrawA.h>
#endif
#include<GL/glu.h>
#include "viewmol.h"
#include "dialog.h"
#include "isotopes.h"
#ifdef LINUX
#define SYS_NMLN 65
#endif

void getPrimitive(char *, int *, int);
int  getColor(GLfloat *p);
void unknownResource(char *, char *);
void storeCommand(char *, char *, char *);

extern void GetMessageBoxButton(Widget, XtPointer, caddr_t);
extern char *getStringResource(Widget, char *);
extern int  getIntResource(Widget, char *);
extern void getRGBColor(Widget, Pixel, float *, float *, float *);
extern int checkFile(char **);
extern void *getmem(size_t, size_t);
extern void *expmem(void *, size_t, size_t);
extern void osname(char *);
extern int messgb(Widget, int, char *, struct PushButtonRow *, int);
extern void loadAtomColors(void);
extern void GetPapersize(Widget, caddr_t, XmToggleButtonCallbackStruct *);

extern struct ATOM *atoms;
extern struct ELEMENT *elements;
extern struct WINDOW windows[];
extern struct OPTION *options;
extern Pixel stdcol[9];
extern char title[MAXLENLINE], webbrowser[MAXLENLINE];
extern int na, ne, nopt;
extern double radfac, bndfac, temp, sphereres, denres;
extern double paperHeight, paperWidth;
extern int debug, label;
extern int lines, mode;
extern int primitive;
extern double level;
extern int unit;
extern char *formBondLength, *formBondAngle, *formTorsionAngle;
extern int rgbMode, simplify, interp;
extern Widget topShell;
extern XtAppContext app;

int getrc(void)
{
  FILE *file;
  static struct PushButtonRow buttons1[] = {{"exit", GetMessageBoxButton, (XtPointer)0, NULL}};
  char line[MAXLENLINE], rcfile[MAXLENLINE], *word;
  char os[SYS_NMLN+12];
  size_t mne=110;
  int nline=0, error;

  debug=0;
  label=FALSE;

/* Find default model */

  word=getStringResource(topShell, "model");
  if (strstr(word, "wire"))
    windows[VIEWER].mode=WIREMODEL;
  else if (strstr(word, "stick"))
    windows[VIEWER].mode=STICKMODEL;
  else if (strstr(word, "ball"))
    windows[VIEWER].mode=BALLMODEL;
  else if (strstr(word, "cpk"))
    windows[VIEWER].mode=CUPMODEL;
  else
  {
    unknownResource("Viewmol.model", word);
    windows[VIEWER].mode=WIREMODEL;
  }

/* Find default drawing primitive */

  word=getStringResource(topShell, "drawingMode");
  if (strstr(word, "dot"))
    primitive=GLU_POINT;
  else if (strstr(word, "line"))
    primitive=GLU_LINE;
  else if (strstr(word, "surface"))
    primitive=GLU_FILL;
  else
  {
    unknownResource("Viewmol.drawingMode", word);
    primitive=GLU_FILL;
  }

/* Find default sphere/cylinder/arrow resolution */

  sphereres=(double)getIntResource(topShell, "sphereResolution");

  word=getStringResource(topShell, "simplifyWhileRotating");
  if (!strcmp(word, "True")) simplify=TRUE;
  else                       simplify=FALSE;

  word=getStringResource(topShell, "interpolation");
  if (!strcmp(word, "none"))
    interp=IP_NONE;
  else if (!strcmp(word, "linear"))
    interp=IP_LINEAR;
  else if (!strcmp(word, "logarithmic"))
    interp=IP_LOG;
  else
  {
    unknownResource("Viewmol.interpolation", word);
    interp=IP_LINEAR;
  }

  temp=273.e0;
  lines=TRUE;
  windows[SPECTRUM].foreground=stdcol[BLACK];
  windows[SPECTRUM].background=stdcol[WHITE];
  windows[SPECTRUM].mode=SPECTRUM_IR;
  word=getStringResource(topShell, "wavenumbers");
  windows[SPECTRUM].left=atof(strtok(word, ":"))-10.;
  windows[SPECTRUM].right=atof(strtok(NULL, ":"))+10.;
  windows[SPECTRUM].bottom=110.0e0;
  windows[SPECTRUM].top=-10.0e0;
  windows[SPECTRUM].near=0.0e0;
  windows[SPECTRUM].far=1.0e0;
  windows[HISTORY].foreground=stdcol[BLUE];
  windows[HISTORY].background=stdcol[WHITE];
  windows[HISTORY].mode=SCALES | ENERGY | GNORM;
  windows[HISTORY].left=1.0e0;
  windows[HISTORY].bottom=0.0e0;
  windows[HISTORY].near=0.0e0;
  windows[HISTORY].far=1.0e0;
  unit=HARTREE;
  windows[MO].foreground=stdcol[BLACK];
  windows[MO].background=stdcol[WHITE];
  windows[MO].mode=ENERGY_LEVELS;
  windows[MO].left=0.0e0;
  windows[MO].right=1.0e0;
  windows[MO].near=0.0e0;
  windows[MO].far=1.0e0;
  level=atof(getStringResource(topShell, "isosurface"));
  denres=atof(getStringResource(topShell, "densityResolution"));

/* Get format strings for bond lengths, bond angles, and torsion angles */

  formBondLength=getStringResource(topShell, "bondLength");
  if (strstr(formBondLength, "pm")) bndfac=100.e0;
  if (strstr(formBondLength, "bohr") || strstr(formBondLength, "au")) bndfac=1.e0/0.52917706e0;
  formBondAngle=getStringResource(topShell, "bondAngle");
  formTorsionAngle=getStringResource(topShell, "torsionAngle");

/* Get command to start Web browser for manual and check if browser is accessible */

  word=getStringResource(topShell, "webBrowser");
  strncpy(webbrowser, word, MAXLENLINE);
  word=strtok(webbrowser, " \t");
  strcpy(line, strchr(webbrowser, '\0')+1);
  if (checkFile(&word))
  {
    strncpy(webbrowser, word, MAXLENLINE);
    strcat(webbrowser, " ");
    strcat(webbrowser, line);
  }
  else
    webbrowser[0]='\0';

/* Get paper size */

  word=getStringResource(topShell, "paperSize");
  if (strchr(word, 'x') != NULL)
  {
    paperWidth=atof(strtok(word, "x"));
    paperHeight=atof(strtok(NULL, "x"));
  }
  else
  {
    if (strstr(word, "A5") != NULL)
      GetPapersize((Widget)0, (caddr_t)A5, (XmToggleButtonCallbackStruct *)0);
    else if (strstr(word, "A4") != NULL)
      GetPapersize((Widget)0, (caddr_t)A4, (XmToggleButtonCallbackStruct *)0);
    else if (strstr(word, "A3") != NULL)
      GetPapersize((Widget)0, (caddr_t)A3, (XmToggleButtonCallbackStruct *)0);
    else if (strstr(word, "Letter") != NULL)
      GetPapersize((Widget)0, (caddr_t)LETTER, (XmToggleButtonCallbackStruct *)0);
    else if (strstr(word, "Legal") != NULL)
      GetPapersize((Widget)0, (caddr_t)LEGAL, (XmToggleButtonCallbackStruct *)0);
    else
    {
	unknownResource("Viewmol.paperSize", word);
	GetPapersize((Widget)0, (caddr_t)A4, (XmToggleButtonCallbackStruct *)0);
    }
  }

  elements=(struct ELEMENT *)getmem(mne, sizeof(struct ELEMENT));

  strcpy(rcfile, "viewmolrc");
  if ((file=fopen(rcfile, "r")) == NULL)
  {
    if ((word=getenv("HOME")) != NULL)
    {
      strcpy(rcfile, word);
      strcat(rcfile, "/.viewmolrc");
    }
    if ((file=fopen(rcfile, "r")) == NULL)
    {
      if ((word=getenv("VIEWMOLPATH")) != NULL)
      {
        strcpy(rcfile, word);
        strcat(rcfile, "viewmolrc");
      }
      if ((file=fopen(rcfile, "r")) == NULL)
      {
	  word=getStringResource(topShell, "unableToOpen");
	  sprintf(line, word, "viewmolrc");
        messgb(topShell, 3, line, buttons1, 1);
	  exit(-1);
      }
    }
  }

  ne=0;
  osname(os);
  while (fgets(line, MAXLENLINE, file) != NULL)
  {
    nline++;
    error=FALSE;
    if (line[0] != '#')
    {
      if (strstr(line, "debug"))
      {
        word=strtok(line, "=");
        word=strtok(NULL, "=");
        debug=atoi(word);
      }
	else if (strstr(line, "option"))
	{
	  if (options == NULL)
	    options=(struct OPTION *)getmem(nopt+1, sizeof(struct OPTION));
        else
	    options=(struct OPTION *)expmem((void *)options, nopt+1, sizeof(struct OPTION));
	  strtok(line, " \t");
	  strcpy(options[nopt].flag, strtok(NULL, " \t"));
	  storeCommand(options[nopt].command, strtok(NULL, " \t"), os);
	  while ((word=strtok(NULL, " \t")) != NULL)
	  {
	    strncat(options[nopt].command, " ", MAXLENLINE);
	    strncat(options[nopt].command, word, MAXLENLINE);
	  }
	  nopt++;
	}
	else
	{
        if ((word=strtok(line, " \t")) != NULL)
        {
          strcpy(elements[ne].symbol, word);
          elements[ne].symbol[0]=toupper(elements[ne].symbol[0]);
          elements[ne].symbol[1]=tolower(elements[ne].symbol[1]);
          if ((word=strtok(NULL, " \t")) != NULL)
	    {
            elements[ne].rad=atof(word);
            if (!(error=getColor(&elements[ne].dark[0])))
              error=getColor(&elements[ne].light[0]);
          }
          else
            error=TRUE;
	    elements[ne].shininess=128.0;
	    while ((word=strtok(NULL, " \t")) != NULL)
	    {
	      if (strstr(word, "am") != NULL)
	        error=getColor(&elements[ne].ambient[0]);
            if (strstr(word, "em") != NULL)
              error=getColor(&elements[ne].emission[0]);
	      if (strstr(word, "sp") != NULL)
	        error=getColor(&elements[ne].specular[0]);
	      if (strstr(word, "sh") != NULL)
	      {
              word=strtok(NULL, " \t");
	        elements[ne].shininess=(float)atof(word);
	      }
	      if (strstr(word, "al") != NULL)
	      {
              word=strtok(NULL, " \t");
	        elements[ne].alpha=(float)atof(word);
	      }
	    }
	  }
	  else
	    error=TRUE;
        if (error)
	  {
	    word=getStringResource(topShell, "errorOnLine");
	    sprintf(line, word, nline, rcfile);
	    messgb(topShell, 2, line, buttons1, 1);
	    exit(-1);
	  }
	  if (++ne > mne)
	  {
	    mne+=10;
	    elements=(struct ELEMENT *)expmem((void *)elements, mne, sizeof(struct ELEMENT));
	  }
	} /* end of "if (strstr(line ..." */
    } /* end of "if (line[0] ... " */
  } /* end of "while (fgets ..." */
  if (nopt == 0)
  {
    word=getStringResource(topShell, "noInputFilter");
    sprintf(line, word, rcfile);
    messgb(topShell, 3, line, buttons1, 1);
    exit(-1);
  }
  return(TRUE);
}

int setAtom(void)
{
  int uc=FALSE;
  register int i, j;

  for (i=0; i<na; i++)
  {
    if (!uc && !strncmp(atoms[i].name, "Uc", 2)) uc=TRUE;
    for (j=0; j<ne; j++)
    {
      if (!strncmp(atoms[i].name, elements[j].symbol, 2))
      {
        atoms[i].rad=elements[j].rad/radfac;
        atoms[i].element=&elements[j];
      }
    }
    for (j=0; j<LASTELEMENT; j++)
    {
	if (!strncmp(atoms[i].name, pse[j], 2))
	  atoms[i].mass=isotope[j][0];
    }
  }
  for (j=0; j<ne; j++)
  {
    if (!strncmp(elements[j].symbol, "Bd", 2))
    {
	atoms[na].rad=elements[j].rad/radfac;
	atoms[na].element=&elements[j];
    }
  }
  if (!rgbMode) loadAtomColors();
  return(uc);
}

void getPrimitive(char *line, int *primitive, int deflt)
{
  if (strstr(line, "dot"))
    *primitive=GLU_POINT;
  else if (strstr(line, "line"))
    *primitive=GLU_LINE;
  else if (strstr(line, "surface"))
    *primitive=GLU_FILL;
  else
    *primitive=deflt;
}

int getColor(GLfloat *p)
{
  char *word;

  if ((word=strtok(NULL, " \t")) == NULL) return(TRUE);
  p[0]=(float)atof(word);
  if ((word=strtok(NULL, " \t")) == NULL) return(TRUE);
  p[1]=(float)atof(word);
  if ((word=strtok(NULL, " \t")) == NULL) return(TRUE);
  p[2]=(float)atof(word);
  p[3]=0.0;
  return(FALSE);
}

void unknownResource(char *resource, char *value)
{
  static struct PushButtonRow buttons[] = {{"exit", GetMessageBoxButton, (XtPointer)0, NULL},
						       {"continue", GetMessageBoxButton, (XtPointer)1, NULL}};
  char *word, line[MAXLENLINE];

  word=getStringResource(topShell, "unknownResource");
  sprintf(line, word, value, resource);
  if (!messgb(topShell, 3, line, buttons, 2)) exit(-1);
}

void storeCommand(char *target, char *value, char *replacement)
{
  char *p=value, *t=target;

  while (*p)
  {
    if (*p != '$')
	*t++=*p++;
    else
    {
	if (!strncmp(p, "$OSNAME", 7))
	{
	  strcpy(t, replacement);
	  p+=7;
	  t+=strlen(replacement);
	}
	else if (!strncmp(p, "${OSNAME}", 9))
	{
	  strcpy(t, replacement);
	  p+=9;
	  t+=strlen(replacement);
	}
	else
	  *t++=*p++;
    }
  }
}
