/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                            P R I N T F O R M . C                             *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1996                   *
*                                                                              *
********************************************************************************
*
* $Id: printform.c,v 1.1 1996/12/10 18:43:19 jrh Exp $
* $Log: printform.c,v $
 * Revision 1.1  1996/12/10  18:43:19  jrh
 * Initial revision
 *
*
*/
#include<stdlib.h>
#include<X11/Intrinsic.h>
#include<Xm/Xm.h>
#include<Xm/DialogS.h>
#include<Xm/Form.h>
#include<Xm/Label.h>
#include<Xm/LabelG.h>
#include<Xm/MwmUtil.h>
#include<Xm/PanedW.h>
#include<Xm/PushB.h>
#include<Xm/PushBG.h>
#include<Xm/RowColumn.h>
#include<Xm/Scale.h>
#include<Xm/Separator.h>
#include<Xm/Text.h>
#include<Xm/ToggleB.h>
#include<GL/glu.h>
#include "tiffio.h"
#include "viewmol.h"
#include "dialog.h"
#include "menu.h"

void printDialog(Widget, caddr_t, XmAnyCallbackStruct *);
void printDialogExit(Widget, caddr_t, XmPushButtonCallbackStruct *);
void GetFormat(Widget, caddr_t, XmToggleButtonCallbackStruct *);
void GetOrientation(Widget, caddr_t, XmToggleButtonCallbackStruct *);
void GetPapersize(Widget, caddr_t, XmToggleButtonCallbackStruct *);
void GetCompression(Widget, caddr_t, XmToggleButtonCallbackStruct *);
void SetPapersize(int);
void Fileselect(Widget, caddr_t, XmAnyCallbackStruct *);

extern void GetInsWeight(Widget, caddr_t, XmAnyCallbackStruct *);
extern Widget makeMenu(Widget, int, char *, struct MenuItem *);
extern void MapBox(Widget, caddr_t, XmAnyCallbackStruct *);
extern Widget CreateToggleBox(Widget, struct PushButtonRow *, int, int,
                              int, int);
extern char *selectFile(char *, char *);
extern char *getStringResource(Widget, char *);
extern char *saveVectorFile(int, char *, int);
extern char *saveTiff(int, char *, int);
extern void GetMessageBoxButton(Widget, XtPointer, caddr_t);
extern void setAnimation(int);
extern Boolean normalMode(XtPointer);
extern int messgb(Widget, int, char *, struct PushButtonRow *, int);
extern void CreatePushButtonRow(Widget, struct PushButtonRow *, int);
extern void setMenuItem(int, int, int);

extern struct WINDOW windows[4];
extern Widget topShell, fileBox;
extern double paperWidth, paperHeight;
extern int format, landscape, animate, mode, primitive, iwavef, imo;

static Widget filename, dialog, pWidth, pHeight, comp, paperformat;
static int window, format_save, landscape_save, compression=COMPRESSION_NONE;
static int paper=A4;
static char name[MAXLENLINE];
static struct PushButtonRow radiobox2_buttons[] = {
  { "landscape", GetOrientation, (XtPointer)TRUE, NULL },
  { "portrait", GetOrientation, (XtPointer)FALSE, NULL }
};

void printDialog(Widget widget, caddr_t which, XmAnyCallbackStruct *data)
{
  Widget board, form, form1, form2, form3, form4, form5, form6, sep1, sep2, sep3, sep4;
  Widget radiobox1, radiobox2, file, select, papersize;
  Widget clabel, wlabel, hlabel;
  Arg args[3];
  static struct PushButtonRow buttons[] = {
    { "ok", printDialogExit, (XtPointer)TRUE, NULL },
    { "cancel", printDialogExit, (XtPointer)FALSE, NULL }
  };
  static struct PushButtonRow radiobox1_buttons[] = {
    { "tiff", GetFormat, (XtPointer)TIFFFILE, NULL },
    { "hpgl", GetFormat, (XtPointer)HPGL, NULL },
    { "postscript", GetFormat, (XtPointer)POSTSCRIPT, NULL },
    { "raytracer", GetFormat, (XtPointer)RAYTRACER, NULL }
  };
  static struct MenuItem paperMenu[] = {
    { "a5", &xmPushButtonGadgetClass, GetPapersize, (XtPointer)A5, NULL, NULL },
    { "a4", &xmPushButtonGadgetClass, GetPapersize, (XtPointer)A4, NULL, NULL },
    { "a3", &xmPushButtonGadgetClass, GetPapersize, (XtPointer)A3, NULL, NULL },
    { "letter", &xmPushButtonGadgetClass, GetPapersize, (XtPointer)LETTER, NULL, NULL },
    { "legal", &xmPushButtonGadgetClass, GetPapersize, (XtPointer)LEGAL, NULL, NULL },
    { "userdefined", &xmPushButtonGadgetClass, GetPapersize, (XtPointer)USER, NULL, NULL },
    { NULL, NULL, NULL, NULL, NULL, NULL }
  };
  static struct MenuItem compressionMenu[] = {
    { "none", &xmPushButtonGadgetClass, GetCompression, (XtPointer)COMPRESSION_NONE, NULL, NULL },
    { "mac", &xmPushButtonGadgetClass, GetCompression, (XtPointer)COMPRESSION_PACKBITS, NULL, NULL },
    { "lzw", &xmPushButtonGadgetClass, GetCompression, (XtPointer)COMPRESSION_LZW, NULL, NULL },
    { NULL, NULL, NULL, NULL, NULL, NULL }
  };
  char line[MAXLENLINE];
  register int i;

  /* This function creates the dialog for file output */

  format_save=format;
  landscape_save=landscape;
  window=(int)which;

  setMenuItem(VIEWER, 18, False);
  if (windows[SPECTRUM].widget) setMenuItem(SPECTRUM, 3, False);
  if (windows[HISTORY].widget) setMenuItem(HISTORY, 1, False);
  if (windows[MO].widget) setMenuItem(MO, 3, False);
  XtSetArg(args[0], XmNautoUnmanage, False);
  XtSetArg(args[1], XmNdefaultPosition, False);
  if (XmIsMotifWMRunning(topShell))
    XtSetArg(args[2], XmNmwmDecorations, MWM_DECOR_RESIZEH | MWM_DECOR_TITLE);
  else
    XtSetArg(args[2], (char *)NULL, 0);
  dialog=XmCreateDialogShell(windows[window].widget, "printForm_popup", args, XtNumber(args));
  board=XtVaCreateWidget("printForm", xmFormWidgetClass, dialog,
                         XmNautoUnmanage, False,
                         XmNdefaultPosition, False,
                         NULL);
  form=XtVaCreateWidget("rowcolumn", xmRowColumnWidgetClass, board,
                        XmNorientation, XmVERTICAL,
                        XmNtopAttachment, XmATTACH_FORM,
                        XmNbottomAttachment, XmATTACH_FORM,
                        XmNleftAttachment, XmATTACH_FORM,
                        XmNrightAttachment, XmATTACH_FORM,
                        NULL);

  form1=XtVaCreateWidget("controlarea1", xmRowColumnWidgetClass, form,
                         XmNorientation, XmHORIZONTAL,
                         XmNleftAttachment, XmATTACH_FORM,
                         XmNrightAttachment, XmATTACH_FORM,
                         NULL);
  radiobox1=CreateToggleBox(form1, radiobox1_buttons, XtNumber(radiobox1_buttons),
                            XmVERTICAL, True, format-2);
  if (window != VIEWER || (windows[VIEWER].mode == WIREMODEL && iwavef == ALL_OFF))
     XtVaSetValues(radiobox1_buttons[RAYTRACER-2].widget, XmNsensitive, False, NULL);
  if ((animate == ANIMATE && mode != (-1) && window == VIEWER) ||
	(imo != (-1) && window == MO))
  {
    XtVaSetValues(radiobox1_buttons[HPGL-2].widget, XmNsensitive, False, NULL);
    XtVaSetValues(radiobox1_buttons[POSTSCRIPT-2].widget, XmNsensitive, False, NULL);
  }
  if (window == VIEWER && primitive == GLU_FILL &&
     (iwavef != ALL_OFF || windows[window].mode != WIREMODEL))
  {
    XtVaSetValues(radiobox1_buttons[HPGL-2].widget, XmNsensitive, False, NULL);
    XtVaSetValues(radiobox1_buttons[POSTSCRIPT-2].widget, XmNsensitive, False, NULL);
  }
  XtVaSetValues(radiobox1, XmNleftAttachment, XmATTACH_FORM,
                           XmNtopAttachment, XmATTACH_FORM,
                           XmNbottomAttachment, XmATTACH_FORM,
                           NULL);
  sep1=XtVaCreateManagedWidget("sep1", xmSeparatorWidgetClass, form1,
                               XmNorientation, XmVERTICAL,
                               XmNtraversalOn, False,
                               XmNtopAttachment, XmATTACH_FORM,
                               XmNbottomAttachment, XmATTACH_FORM,
                               XmNleftAttachment, XmATTACH_WIDGET,
                               XmNleftWidget, radiobox1,
                               NULL);
  form2=XtVaCreateWidget("controlarea2", xmRowColumnWidgetClass, form1,
                         XmNorientation, XmVERTICAL,
				 XmNtopAttachment, XmATTACH_FORM,
				 XmNbottomAttachment, XmATTACH_FORM,
				 XmNrightAttachment, XmATTACH_FORM,
                         NULL);
  radiobox2=CreateToggleBox(form2, radiobox2_buttons, XtNumber(radiobox2_buttons),
                            XmVERTICAL, True, landscape ? 0 : 1);
  XtVaSetValues(radiobox2,XmNrightAttachment, XmATTACH_FORM,
                          XmNtopAttachment, XmATTACH_FORM,
                          NULL);
  if (format == TIFFFILE || format == RAYTRACER)
  {
    XtVaSetValues(radiobox2_buttons[0].widget, XmNsensitive, False, NULL);
    XtVaSetValues(radiobox2_buttons[1].widget, XmNsensitive, False, NULL);
  }
  sep2=XtVaCreateManagedWidget("sep2", xmSeparatorWidgetClass, form2,
                               XmNorientation, XmHORIZONTAL,
                               XmNtraversalOn, False,
                               XmNleftAttachment, XmATTACH_FORM,
                               XmNrightAttachment, XmATTACH_FORM,
                               XmNtopAttachment, XmATTACH_WIDGET,
                               XmNtopWidget, radiobox2,
                               NULL);
  clabel=XtVaCreateManagedWidget("compressionlabel", xmLabelWidgetClass, form2,
                                 XmNleftAttachment, XmATTACH_FORM,
                                 XmNrightAttachment, XmATTACH_FORM,
                                 XmNtopAttachment, XmATTACH_WIDGET,
                                 XmNtopWidget, sep2,
                                 NULL);
  if (strcmp(getStringResource(topShell, "hasLZW"), "True"))
    compressionMenu[2].label=NULL;
  comp=makeMenu(form2, XmMENU_OPTION, "compression", compressionMenu);
  if (format == TIFFFILE)
  {
    for (i=0; compressionMenu[i].label != NULL; i++)
    {
      if ((int)(compressionMenu[i].callback_data) == compression)
        XtVaSetValues(comp, XmNmenuHistory, compressionMenu[i].widget,
                      XmNleftAttachment, XmATTACH_FORM,
                      XmNrightAttachment, XmATTACH_FORM,
                      XmNtopAttachment, XmATTACH_WIDGET,
                      XmNtopWidget, clabel,
                      NULL);
    }
  }
  else
    XtVaSetValues(comp, XmNsensitive, False, NULL);
  XtManageChild(comp);

  sep3=XtVaCreateManagedWidget("sep3", xmSeparatorWidgetClass, form,
                               XmNorientation, XmHORIZONTAL,
                               XmNtraversalOn, False,
                               XmNleftAttachment, XmATTACH_FORM,
                               XmNrightAttachment, XmATTACH_FORM,
                               XmNtopAttachment, XmATTACH_WIDGET,
                               XmNleftWidget, form1,
                               NULL);
  form3=XtVaCreateWidget("controlarea3", xmFormWidgetClass, form,
                         NULL);
  file=XtVaCreateManagedWidget("file", xmLabelWidgetClass, form3,
                               XmNleftAttachment, XmATTACH_FORM,
                               XmNtopAttachment, XmATTACH_FORM,
                               XmNbottomAttachment, XmATTACH_FORM,
                               NULL);
  switch (format)
  {
    case TIFFFILE:   strcpy(name, "vm_image.tiff");
                     break;
    case HPGL:       strcpy(name, "vm_plot.hpgl");
                     break;
    case POSTSCRIPT: strcpy(name, "vm_plot.ps");
                     break;
    case RAYTRACER:  strcpy(name, "vm_image.ray");
                     break;
  }
  filename=XtVaCreateManagedWidget("filename", xmTextWidgetClass, form3,
                                   XmNvalue, name,
					     XmNcolumns, 12,
                                   XmNleftAttachment, XmATTACH_WIDGET,
                                   XmNleftWidget, file,
                                   XmNtopAttachment, XmATTACH_FORM,
                                   XmNbottomAttachment, XmATTACH_FORM,
                                   NULL);
  select=XtVaCreateManagedWidget("select", xmPushButtonGadgetClass, form3,
                                 XmNleftAttachment, XmATTACH_WIDGET,
					   XmNleftWidget, filename,
                                 XmNtopAttachment, XmATTACH_FORM,
                                 XmNbottomAttachment, XmATTACH_FORM,
                                 XmNrightAttachment, XmATTACH_FORM,
                                 XmNdefaultButtonShadowThickness, 1,
                                 NULL);
  XtAddCallback(select, XmNactivateCallback, (XtCallbackProc)Fileselect, NULL);

  form4=XtVaCreateWidget("controlarea4", xmFormWidgetClass, form,
                         NULL);
  papersize=XtVaCreateManagedWidget("papersize", xmLabelWidgetClass, form4,
                                    XmNleftAttachment, XmATTACH_FORM,
                                    XmNtopAttachment, XmATTACH_FORM,
                                    XmNbottomAttachment, XmATTACH_FORM,
                                    NULL);
  paperformat=makeMenu(form4, XmMENU_OPTION, "paperformat", paperMenu);
  for (i=0; paperMenu[i].label != NULL; i++)
  {
    if ((int)paperMenu[i].callback_data == paper)
      XtVaSetValues(paperformat, XmNmenuHistory, paperMenu[i].widget,
                                 XmNrightAttachment, XmATTACH_FORM,
                                 XmNtopAttachment, XmATTACH_FORM,
                                 XmNbottomAttachment, XmATTACH_FORM,
                                 NULL);
  }
  if (format == TIFFFILE || format == RAYTRACER)
    XtVaSetValues(paperformat, XmNsensitive, False, NULL);
  XtManageChild(paperformat);

  form5=XtVaCreateWidget("controlarea5", xmFormWidgetClass, form,
                         NULL);
  form6=XtVaCreateWidget("controlarea5", xmFormWidgetClass, form,
                         NULL);
  wlabel=XtVaCreateManagedWidget("widthlabel", xmLabelWidgetClass, form5,
                                 XmNleftAttachment, XmATTACH_FORM,
                                 XmNtopAttachment, XmATTACH_FORM,
					   XmNbottomAttachment, XmATTACH_FORM,
                                 NULL);

  hlabel=XtVaCreateManagedWidget("heightlabel", xmLabelWidgetClass, form6,
                                 XmNleftAttachment, XmATTACH_FORM,
                                 XmNtopAttachment, XmATTACH_FORM,
                                 XmNbottomAttachment, XmATTACH_FORM,
                                 NULL);

  sprintf(line, "%7.2f", paperWidth);
  pWidth=XtVaCreateManagedWidget("width", xmTextWidgetClass, form5,
                                 XmNvalue, line,
					   XmNcolumns, 7,
                                 XmNtopAttachment, XmATTACH_FORM,
                                 XmNrightAttachment, XmATTACH_FORM,
                                 XmNbottomAttachment, XmATTACH_FORM,
                                 NULL);
  XtAddCallback(pWidth, XmNvalueChangedCallback, (XtCallbackProc)GetInsWeight, &paperWidth);

  sprintf(line, "%7.2f", paperHeight);
  pHeight=XtVaCreateManagedWidget("height", xmTextWidgetClass, form6,
                                  XmNvalue, line,
					    XmNcolumns, 7,
                                  XmNtopAttachment, XmATTACH_FORM,
					    XmNrightAttachment, XmATTACH_FORM,
                                  XmNbottomAttachment, XmATTACH_FORM,
                                  NULL);
  XtAddCallback(pHeight, XmNvalueChangedCallback, (XtCallbackProc)GetInsWeight, &paperHeight);

  if (paper != USER)
  {
    XtVaSetValues(pWidth, XmNsensitive, False, NULL);
    XtVaSetValues(pHeight, XmNsensitive, False, NULL);
  }
  sep4=XtVaCreateManagedWidget("sep4", xmSeparatorWidgetClass, form,
                               XmNorientation, XmHORIZONTAL,
                               XmNtraversalOn, False,
                               XmNleftAttachment, XmATTACH_FORM,
                               XmNrightAttachment, XmATTACH_FORM,
                               XmNtopAttachment, XmATTACH_WIDGET,
                               XmNleftWidget, form5,
                               NULL);

  XtManageChild(form1);
  XtManageChild(form2);
  XtManageChild(form3);
  XtManageChild(form4);
  XtManageChild(form5);
  XtManageChild(form6);

  CreatePushButtonRow(form, buttons, 2);
  XtAddCallback(dialog, XmNpopupCallback, (XtCallbackProc)MapBox, (XmAnyCallbackStruct *)NULL);
  XtManageChild(form);
  XtManageChild(board);
}

void GetFormat(Widget button, caddr_t which, XmToggleButtonCallbackStruct *data)
{
  if (data->set) format=(int)which;
  switch (format)
  {
    case TIFFFILE:   strcpy(name, "vm_image.tiff");
                     XtVaSetValues(radiobox2_buttons[0].widget, XmNsensitive, False, NULL);
                     XtVaSetValues(radiobox2_buttons[1].widget, XmNsensitive, False, NULL);
                     XtVaSetValues(comp, XmNsensitive, True, NULL);
                     XtVaSetValues(paperformat, XmNsensitive, False, NULL);
                     break;
    case HPGL:       strcpy(name, "vm_plot.hpgl");
                     XtVaSetValues(radiobox2_buttons[0].widget, XmNsensitive, True, NULL);
                     XtVaSetValues(radiobox2_buttons[1].widget, XmNsensitive, True, NULL);
                     XtVaSetValues(comp, XmNsensitive, False, NULL);
                     XtVaSetValues(paperformat, XmNsensitive, True, NULL);
                     break;
    case POSTSCRIPT: strcpy(name, "vm_plot.ps");
                     XtVaSetValues(radiobox2_buttons[0].widget, XmNsensitive, True, NULL);
                     XtVaSetValues(radiobox2_buttons[1].widget, XmNsensitive, True, NULL);
                     XtVaSetValues(comp, XmNsensitive, False, NULL);
                     XtVaSetValues(paperformat, XmNsensitive, True, NULL);
                     break;
    case RAYTRACER:  strcpy(name, "vm_image.ray");
                     XtVaSetValues(radiobox2_buttons[0].widget, XmNsensitive, False, NULL);
                     XtVaSetValues(radiobox2_buttons[1].widget, XmNsensitive, False, NULL);
                     XtVaSetValues(comp, XmNsensitive, False, NULL);
                     XtVaSetValues(paperformat, XmNsensitive, False, NULL);
                     break;
  }
  XtVaSetValues(filename, XmNvalue, name, NULL);
}

void GetOrientation(Widget button, caddr_t which, XmToggleButtonCallbackStruct *data)
{
  if (data->set)
  {
    SetPapersize(TRUE);
    if ((int)which)
      landscape=TRUE;
    else
      landscape=FALSE;
  }
}

void GetPapersize(Widget button, caddr_t which, XmToggleButtonCallbackStruct *data)
{
  paper=(int)which;
  switch (paper)
  {
    case A5:     paperWidth=210.2;
                 paperHeight=148.6;
                 break;
    case A4:     paperWidth=297.3;
                 paperHeight=210.2;
                 break;
    case A3:     paperWidth=420.4;
                 paperHeight=297.3;
                 break;
    case LETTER: paperWidth=278.0;
                 paperHeight=216.0;
                 break;
    case LEGAL:  paperWidth=356.0;
                 paperHeight=216.0;
                 break;
  }
  if (button == 0) return;
  SetPapersize(!landscape);
  if (paper == USER)
  {
    XtVaSetValues(pWidth, XmNsensitive, True,
                          NULL);
    XtVaSetValues(pHeight, XmNsensitive, True,
                           NULL);
  }
  else
  {
    XtVaSetValues(pWidth, XmNsensitive, False,
                          NULL);
    XtVaSetValues(pHeight, XmNsensitive, False,
                           NULL);
  }
}

void GetCompression(Widget button, caddr_t which, XmToggleButtonCallbackStruct *data)
{
  compression=(int)which;
}

void printDialogExit(Widget button, caddr_t which, XmPushButtonCallbackStruct *data)
{
  static struct PushButtonRow buttons[] = {{"continue", GetMessageBoxButton, (XtPointer)0, NULL}};
  char *file, *dot, *word=NULL;
  char f[MAXLENLINE], num[3], str[MAXLENLINE];
  register int i, n;

  if (!(int)which)
  {
    format=format_save;
    landscape=landscape_save;
  }
  else
  {
    file=XmTextGetString(filename);
    switch (format)
    {
      case TIFFFILE:   if (animate && mode != (-1) && window == VIEWER)
			     {
				 dot=strrchr(file, '.');
				 n=dot-file;
				 setAnimation(FALSE);
				 for (i=0; i<24; i++)
				 {
				   strncpy(f, file, n);
				   f[n]='\0';
				   sprintf(num, "%2.2d", i);
				   strcat(f, num);
				   strcat(f, dot);
				   normalMode((XtPointer)0);
				   word=saveTiff(window, f, compression);
				 }
				 setAnimation(TRUE);
				 strncpy(f, file, n);
				 f[n]='\0';
				 strcat(f, "XX");
				 strcat(f, dot);
				 strcat(f, " (XX=0-23)");
				 file=f;
			     }
			     else
				 word=saveTiff(window, file, compression);
                       break;
      case HPGL:
	case POSTSCRIPT: word=saveVectorFile(window, file, format);
                       break;
      case RAYTRACER:  if (animate && mode != (-1) && window == VIEWER)
			     {
				 dot=strrchr(file, '.');
				 n=dot-file;
				 setAnimation(FALSE);
				 for (i=0; i<24; i++)
				 {
				   strncpy(f, file, n);
				   f[n]='\0';
				   sprintf(num, "%2.2d", i);
				   strcat(f, num);
				   strcat(f, dot);
				   normalMode((XtPointer)0);
				   word=saveVectorFile(window, f, format);
				 }
				 setAnimation(TRUE);
				 strncpy(f, file, n);
				 f[n]='\0';
				 strcat(f, "XX");
				 strcat(f, dot);
				 strcat(f, " (XX=0-23)");
				 file=f;
			     }
			     else
				 word=saveVectorFile(window, file, format);
                       break;
    }
    sprintf(str, word, file);
    messgb(topShell, 0, str, buttons, 1);
    XtFree(file);
  }
  XtDestroyWidget(dialog);
  XtUnmanageChild(fileBox);
  setMenuItem(VIEWER, 18, True);
  if (windows[SPECTRUM].widget) setMenuItem(SPECTRUM, 3, True);
  if (windows[HISTORY].widget) setMenuItem(HISTORY, 1, True);
  if (windows[MO].widget) setMenuItem(MO, 3, True);
}

void SetPapersize(int swap)
{
  double help;
  char line[MAXLENLINE];

  if (swap)
  {
    help=paperWidth;
    paperWidth=paperHeight;
    paperHeight=help;
  }

  sprintf(line, "%f", paperWidth);
  XtVaSetValues(pWidth, XmNvalue, line, NULL);
  sprintf(line, "%f", paperHeight);
  XtVaSetValues(pHeight, XmNvalue, line, NULL);
}

void Fileselect(Widget button, caddr_t dummy, XmAnyCallbackStruct *call_data)
{
  char *str, filter[MAXLENLINE];

  XtVaGetValues(filename, XmNvalue, &str, NULL);
  strcpy(filter, "*");
  strcat(filter, strrchr(str, '.'));
  str=selectFile(filter, str);
  XtVaSetValues(filename, XmNvalue, str, NULL);
}
