/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                              V I E W M O L . C                               *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1996                   *
*                                                                              *
********************************************************************************
*
* $Id: viewmol.c,v 1.1 1996/12/10 18:44:18 jrh Exp $
* $Log: viewmol.c,v $
* Revision 1.1  1996/12/10  18:44:18  jrh
* Initial revision
*
*
*/
#include<signal.h>
#include<stdio.h>
#include<X11/Xlib.h>
#include<X11/Intrinsic.h>
#include<Xm/Xm.h>
#include<Xm/DrawingA.h>
#include<GL/gl.h>
#include<GL/glu.h>
#include<GL/glx.h>
#ifdef __osf__
#include<X11/GLw/GLwMDrawA.h>
#else
#include<GL/GLwMDrawA.h>
#endif
#include "dialog.h"
#include "viewmol.h"
#include "fallbacks.h"

extern void processInput(Widget, caddr_t,  GLwDrawingAreaCallbackStruct *);
void reshape(Widget, caddr_t, XmDrawingAreaCallbackStruct *);
void drawMolecule(Widget, caddr_t, GLwDrawingAreaCallbackStruct *);
void getRotation(int, int);
void setDrawingDevice(int);
void ende(Widget, caddr_t, XmAnyCallbackStruct *);

extern void hpglBegin(GLenum), hpglEnd(void), hpglVertex3d(double, double, double);
extern void hpglNormal3d(double, double, double);
extern void hpglVertex2d(double, double), hpglColor4fv(const GLfloat *);
extern void plotString(char *, double, double, double, GLuint);
extern void hpglLineStipple(GLint, GLushort), hpglDisable(GLenum);
extern void hpglLineWidth(GLfloat);
extern void hpglClearColor(GLclampf, GLclampf, GLclampf, GLclampf);
extern void hpglSphere(GLUquadricObj *, GLdouble, GLint, GLint);
extern void hpglCylinder(GLUquadricObj *qobj, GLdouble, GLdouble, GLdouble, GLint, GLint);
extern void hpglOrtho(GLdouble, GLdouble, GLdouble, GLdouble, GLdouble, GLdouble);
extern void hpglPopMatrix(void);
extern void PostscriptBegin(GLenum), PostscriptEnd(void), PostscriptVertex3d(double, double, double);
extern void PostscriptNormal3d(double, double, double);
extern void PostscriptVertex2d(double, double), PostscriptColor4fv(const GLfloat *);
extern void PostscriptString(char *, double, double, double, GLuint);
extern void printString(char *, double, double, double, GLuint);
extern void PostscriptLineStipple(GLint, GLushort), PostscriptDisable(GLenum);
extern void PostscriptLineWidth(GLfloat);
extern void PostscriptClearColor(GLclampf, GLclampf, GLclampf, GLclampf);
extern void PostscriptOrtho(GLdouble, GLdouble, GLdouble, GLdouble, GLdouble, GLdouble);
extern void PostscriptPopMatrix(void);
extern void raytracerBegin(GLenum), raytracerEnd(void), raytracerVertex3d(double, double, double);
extern void raytracerNormal3d(double, double, double);
extern void raytracerColor4fv(const GLfloat *);
extern void raytracerClearColor(GLclampf, GLclampf, GLclampf, GLclampf);
extern void raytracerSphere(GLUquadricObj *, GLdouble, GLint, GLint);
extern void raytracerCylinder(GLUquadricObj *qobj, GLdouble, GLdouble, GLdouble, GLint, GLint);
extern void GetMessageBoxButton(Widget, XtPointer, caddr_t);
extern char *getStringResource(Widget, char *);
extern void pixwor(Dimension, Dimension, GLdouble, GLdouble, GLdouble, GLdouble, double *, double *);
extern int messgb(Widget, int, char *, struct PushButtonRow *, int);
extern void loadColorMap(void);
extern int getrc(void);
extern void showTitle(Dimension, Dimension);
extern int initViewer(int, char **, Widget);
extern void redraw(int);
extern void fremem(void **);

void (*drawBegin)(GLenum), (*drawEnd)(void), (*drawVertex3d)(double, double, double);
void (*drawVertex2d)(double, double), (*drawNormal3d)(double, double, double);
void (*drawColor4fv)(const GLfloat *);
void (*drawString)(char *, double, double, double, GLuint);
void (*drawLineStipple)(GLint, GLushort), (*drawDisable)(GLenum);
void (*drawLineWidth)(GLfloat);
void (*drawClearColor)(GLclampf, GLclampf, GLclampf, GLclampf);
void (*drawSphere)(GLUquadricObj *, GLdouble, GLint, GLint);
void (*drawCylinder)(GLUquadricObj *qobj, GLdouble, GLdouble, GLdouble, GLint, GLint);
void (*drawOrtho)(GLdouble, GLdouble, GLdouble, GLdouble, GLdouble, GLdouble);
void (*drawPopMatrix)(void);

struct ATOM *atoms;
struct BOND *bonds;
struct ELEMENT *elements;
struct NORMAL_MODE *normal_modes=NULL;
struct WINDOW windows[4];
struct OPTION *options=NULL;
struct COORDS *history=NULL;
struct INTERNAL *internals=NULL;
struct OPTIMIZATION *optimization=NULL;
struct ORBITAL *orbitals=NULL;
struct BASISSET *basisset=NULL;
struct GRIDOBJECT *gridObjects=NULL;
Pixel stdcol[9], historyColor;
char title[MAXLENLINE], webbrowser[MAXLENLINE]={""};
int na, nb, ne, nmodes, nopt=0, nhist=0, ninternal=0, ngridobjects=0;
double *cnm=NULL, *coord, *exponents=NULL, *grid=NULL;
double radfac, bndfac=1.0e0, amplitude, forceScale, wnScale=1.0;
double transx, transy, transz;
double tinert[3][3], tmat[4][4], prmat[4][4];
double paperWidth=0.0, paperHeight=0.0, sphereres=10.;
float xrot=0.0, yrot=0.0, zrot=0.0;
float xmov=0.0, ymov=0.0;
float historyColor_rgb[4] = {0.0, 0.0, 1.0, 0.0};
GLfloat light0p[4] = {0.0, 0.0, 1.0, 0.0};
GLfloat light1p[4] = {0.0, 1.0, 0.0, 0.0};
int rotateXY=FALSE, rotateZ=FALSE;
int primitive, animate=ANIMATE, lights=3, movelight=(-1);
int lines=TRUE, mode=(-1), showForces=FALSE, setins=FALSE;
int existsUnitCell=FALSE, showUnitCell=TRUE;
int showInertia=FALSE, selectAtom=FALSE, simplify=TRUE;
int rgbMode, picking=FALSE, swapBuffers=TRUE;
int drawingDevice;
double temp, weight=0.0e0;
int label, imag=0;
int debug;
double emax, emin, cycle;
int nhist;
double e1, e2, denres=(1.);
int nbasfu, unit, imo=(-1), imosav=(-1), ibasfu=0, bfatom;
char *formBondLength, *formBondAngle, *formTorsionAngle;
XtAppContext app;
Widget topShell, fileBox, bfMenu;
int showMenu=TRUE;
int iwavef=ALL_OFF, interp=IP_LINEAR;
double level=0.05, gridres=(-1.);
int needMoloch=FALSE, gaussian=FALSE;
char moloch[MAXLENLINE];
pid_t manual_pid=0, raypid=0;
int format=TIFFFILE, landscape=TRUE;

int main(int argc, char** argv)
{
  Display *display;
  Widget viewer;
  Colormap colormap;
  XVisualInfo *vi;
  Dimension width, height;
  int attrib[] = {GLX_RED_SIZE, 1,
                  GLX_GREEN_SIZE, 1,
                  GLX_BLUE_SIZE, 1,
                  GLX_DEPTH_SIZE, 1,
                  GLX_DOUBLEBUFFER,
                  GLX_RGBA,
                  None};
  static struct PushButtonRow buttons[] = {{"exit", GetMessageBoxButton, (XtPointer)0, NULL}};
  char *line;

  topShell=XtVaAppInitialize(&app, "Viewmol", NULL, 0, &argc, argv, fallbacks, NULL);
  if (topShell == NULL)
  {
    fprintf(stderr, "%s: ERROR: Cannot connect to X server.\n", PROGRAM);
    exit(-1);
  }
  display=XtDisplay(topShell);
  rgbMode=TRUE;
  if ((vi=glXChooseVisual(display, DefaultScreen(display), attrib)) == NULL)
  {
    attrib[9]=None;
    rgbMode=FALSE;
    if ((vi=glXChooseVisual(display, DefaultScreen(display), attrib)) == NULL)
    {
      line=getStringResource(topShell, "noVisual");
      messgb(topShell, 3, line, buttons, 1);
      exit(-1);
    }
  }
  viewer=XtVaCreateManagedWidget("viewer", xmDrawingAreaWidgetClass, topShell,
                                 XmNmarginHeight, 0,
                                 XmNmarginWidth, 0,
                                 NULL);
  XtRealizeWidget(topShell);

  XtVaGetValues(viewer, XmNwidth, &width, XmNheight, &height, NULL);
#ifndef MESA
  if (rgbMode)
    colormap=XCreateColormap(display, XtWindow(viewer), vi->visual, AllocNone);
  else
#endif
    colormap=DefaultColormap(display, DefaultScreen(display));

  windows[VIEWER].widget=XtVaCreateManagedWidget("canvas", glwMDrawingAreaWidgetClass, viewer,
                                                 GLwNvisualInfo, vi,
                                                 XmNwidth, width,
                                                 XmNheight, height,
                                                 XmNcolormap, colormap,
                                                 NULL);
  windows[VIEWER].context=glXCreateContext(XtDisplay(windows[VIEWER].widget), vi, 0, GL_FALSE);
  GLwDrawingAreaMakeCurrent(windows[VIEWER].widget, windows[VIEWER].context);

  loadColorMap();

  if (getrc())
  {
    setDrawingDevice(SCREEN);
    showTitle(width, height);
    if (initViewer(argc, argv, XtParent(windows[VIEWER].widget)))
    {
      XtAddCallback(windows[VIEWER].widget, GLwNinputCallback, (XtCallbackProc)processInput, NULL);
      XtAddCallback(viewer,                 XmNresizeCallback, (XtCallbackProc)reshape, (XtPointer)VIEWER);
      XtAddCallback(windows[VIEWER].widget, GLwNexposeCallback, (XtCallbackProc)drawMolecule, NULL);
      XSelectInput(XtDisplay(windows[VIEWER].widget), XtWindow(windows[VIEWER].widget),
                   ButtonPressMask | ButtonReleaseMask | KeyPressMask | ExposureMask | Button1MotionMask | Button2MotionMask);
    }
  }
  XtAppMainLoop(app);
  return(0);
}

void reshape(Widget widget, caddr_t window, XmDrawingAreaCallbackStruct *data)
{
  Dimension width, height;
  double rel;
  int w;

  XtVaGetValues(widget, XmNwidth, &width, XmNheight, &height, NULL);
  w=(int)window;
  XtVaSetValues(windows[w].widget, XmNwidth, width, XmNheight, height, NULL);
  GLwDrawingAreaMakeCurrent(windows[w].widget, windows[w].context);
  glViewport(0, 0, width, height);
  if (w == VIEWER)
  {
    if (width > height)
    {
      rel=((double)width/(double)height-1.0)*windows[VIEWER].near;
      windows[VIEWER].left=windows[VIEWER].near+rel;
      windows[VIEWER].right=windows[VIEWER].far-rel;
      windows[VIEWER].bottom=windows[VIEWER].near;
      windows[VIEWER].top=windows[VIEWER].far;
    }
    else
    {
      rel=((double)height/(double)width-1.0)*windows[VIEWER].near;
      windows[VIEWER].left=windows[VIEWER].near;
      windows[VIEWER].right=windows[VIEWER].far;
      windows[VIEWER].bottom=windows[VIEWER].near+rel;
      windows[VIEWER].top=windows[VIEWER].far-rel;
    }
  }
}

void getRotation(int x, int y)
{
  static int xold, yold;

  if (rotateXY == 1)
  {
    xrot+=(float)(y-yold);
    yrot+=(float)(x-xold);
  }
  else if (rotateZ == 1)
    zrot+=(float)(x-xold);
 
  if (rotateXY == -1)
    rotateXY=1;
  else if (rotateZ == -1)
    rotateZ=1;
 
  xold=x;
  yold=y;
}

void getTranslation(int x, int y)
{
  Dimension width, height;
  static int xold, yold;
  double xpix, ypix;

  if (rotateXY == 1)
  {
    XtVaGetValues(windows[VIEWER].widget, XtNwidth, &width, XtNheight, &height, NULL);
    pixwor(width, height, windows[VIEWER].left, windows[VIEWER].right, windows[VIEWER].bottom,
         windows[VIEWER].top, &xpix, &ypix);
    xmov+=(float)(x-xold)*xpix;
    ymov+=(float)(yold-y)*ypix;
  }
  if (rotateXY == -1) rotateXY=1;

  xold=x;
  yold=y;
}

void getEnlargement(int x)
{
  static int xold=(-1);
  float  scale;

  if (rotateZ == 1)
  {
    scale=1.+(float)(x-xold)*0.025;
    windows[VIEWER].top*=scale;
    windows[VIEWER].bottom*=scale;
    windows[VIEWER].right*=scale;
    windows[VIEWER].left*=scale;
  }
  if (rotateZ == -1) rotateZ=1;
  xold=x;
  redraw(VIEWER);
}

void setDrawingDevice(int device)
{
  drawingDevice=device;

  switch (device)
  {
    case SCREEN:     drawBegin=glBegin;
                     drawEnd=glEnd;
                     drawVertex3d=glVertex3d;
                     drawVertex2d=glVertex2d;
                     drawNormal3d=glNormal3d;
                     drawColor4fv=glColor4fv;
                     drawClearColor=glClearColor;
                     drawString=printString;
                     drawLineStipple=glLineStipple;
			   drawLineWidth=glLineWidth;
                     drawDisable=glDisable;
                     drawSphere=gluSphere;
                     drawCylinder=gluCylinder;
                     drawOrtho=glOrtho;
                     drawPopMatrix=glPopMatrix;
                     break;
    case HPGL:       drawBegin=hpglBegin;
                     drawEnd=hpglEnd;
                     drawVertex3d=hpglVertex3d;
                     drawVertex2d=hpglVertex2d;
                     drawNormal3d=hpglNormal3d;
                     drawColor4fv=hpglColor4fv;
                     drawClearColor=hpglClearColor;
                     drawString=plotString;
                     drawLineStipple=hpglLineStipple;
			   drawLineWidth=hpglLineWidth;
                     drawDisable=hpglDisable;
                     drawSphere=hpglSphere;
                     drawCylinder=hpglCylinder;
                     drawOrtho=hpglOrtho;
                     drawPopMatrix=hpglPopMatrix;
                     break;
    case POSTSCRIPT: drawBegin=PostscriptBegin;
                     drawEnd=PostscriptEnd;
                     drawVertex3d=PostscriptVertex3d;
                     drawVertex2d=PostscriptVertex2d;
                     drawNormal3d=PostscriptNormal3d;
                     drawColor4fv=PostscriptColor4fv;
                     drawClearColor=PostscriptClearColor;
                     drawString=PostscriptString;
                     drawLineStipple=PostscriptLineStipple;
			   drawLineWidth=PostscriptLineWidth;
                     drawDisable=PostscriptDisable;
                     drawSphere=hpglSphere;
                     drawCylinder=hpglCylinder;
                     drawOrtho=PostscriptOrtho;
                     drawPopMatrix=PostscriptPopMatrix;
                     break;
    case RAYTRACER:  drawBegin=raytracerBegin;
                     drawEnd=raytracerEnd;
                     drawVertex3d=raytracerVertex3d;
                     drawVertex2d=glVertex2d;
                     drawNormal3d=raytracerNormal3d;
                     drawColor4fv=raytracerColor4fv;
                     drawClearColor=raytracerClearColor;
                     drawString=printString;
                     drawLineStipple=glLineStipple;
			   drawLineWidth=glLineWidth;
                     drawDisable=glDisable;
                     drawSphere=raytracerSphere;
                     drawCylinder=raytracerCylinder;
			   drawOrtho=glOrtho;
			   drawPopMatrix=glPopMatrix;
                     break;
  }
}

void ende(Widget widget, caddr_t client_data, XmAnyCallbackStruct *call_data)
{
  fremem((void **)&windows[VIEWER].font);
  fremem((void **)&atoms);
  fremem((void **)&bonds);
  if (cnm != NULL) fremem((void **)&cnm);
  if (normal_modes != NULL) fremem((void **)&normal_modes);
  if (history != NULL) fremem((void **)&history);
  if (optimization != NULL) fremem((void **)&optimization);
  if (orbitals != NULL) fremem((void **)&orbitals);
  if (basisset != NULL) fremem((void **)&basisset);
  if (exponents != NULL) fremem((void **)&exponents);
  if (options != NULL) fremem((void **)&options);
  if (manual_pid && kill(manual_pid, 0) != -1) kill(manual_pid, SIGTERM);
  if (raypid && kill(raypid, 0) != -1) kill(raypid, SIGTERM);
  exit(0);
}
