/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                              V I E W M O L . H                               *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1996                   *
*                                                                              *
********************************************************************************
*
* $Id: viewmol.h,v 1.1 1996/12/10 18:46:03 jrh Exp $
* $Log: viewmol.h,v $
 * Revision 1.1  1996/12/10  18:46:03  jrh
 * Initial revision
 *
*
*/
#include<X11/Intrinsic.h>
#include<GL/gl.h>
#include<GL/glx.h>

#define PROGRAM "Viewmol"
#define VERSION "2.0"

#define MAXLENLINE 132
#define MAXLENBASISNAME 12
#define TRUE  1
#define FALSE 0

#define BLACK   0
#define WHITE   1
#define RED     2
#define GREEN   3
#define BLUE    4
#define YELLOW  5
#define CYAN    6
#define MAGENTA 7
#define SKYBLUE 8

#define VIEWER   0
#define SPECTRUM 1
#define HISTORY  2
#define MO       3

#define BACKGROUND 1
#define FOREGROUND 2

#define WIREMODEL  1
#define STICKMODEL 2
#define BALLMODEL  3
#define CUPMODEL   4

#define SPECTRUM_ALL   1
#define SPECTRUM_IR    2
#define SPECTRUM_RAMAN 3
#define SPECTRUM_INS   4

#define ANIMATE 1
#define ARROWS  2
#define DISTORT 3

#define SCALES 0x1
#define ENERGY 0x2
#define GNORM  0x4

#define HARTREE 1
#define KJ_MOL  2
#define EV      3
#define CM      4

#define DENSITY_OF_STATES 1
#define ENERGY_LEVELS     2

#define BONDAVERAGE 1
#define BONDLENGTH  2
#define ANGLE       3
#define TORSION     4

#define ALL_OFF           1
#define BASIS_FUNCTION    2
#define BASIS_IN_MO       3
#define MOLECULAR_ORBITAL 4
#define DENSITY           5

#define IP_NONE    1
#define IP_LINEAR  2
#define IP_LOG     3

#define LABEL 1
#define INS   2

#define SCREEN     1
#define TIFFFILE   2
#define HPGL       3
#define POSTSCRIPT 4
#define RAYTRACER  5

#define A5         1
#define A4         2
#define A3         3
#define LETTER     4
#define LEGAL      5
#define USER       6

#define LMAX 4        /* maximum l quantum number supported */

struct BASISSET
{
  double     *first;          /* points to the first exponent of a shell  */
  int         nprim;          /* the number of primitives in a shell      */
  int         ang;            /* the angular quantum number of the shell  */
  struct BASISSET *next;      /* points to the BASISSET structure for the */
};                            /* next shell of this atom or NULL          */

struct ATOM
{
  double x;
  double y;
  double z;
  double rad;
  double mass;
  double neutron_scatterfac;
  int    nbonds;
  struct ELEMENT  *element;
  struct BASISSET *basis;
  char   name[8];
  char   basisname[MAXLENBASISNAME];
}; 

struct BONDORDER
{
  int n;
  double x1;
  double y1;
  double z1;
  double x2;
  double y2;
  double z2;
  double x3;
  double y3;
  double z3;
  double x4;
  double y4;
  double z4;
};

struct BOND
{
  int    first;
  int    second;
  struct BONDORDER *order;
  double frac;
};

struct ELEMENT
{
  double  rad;
  double  mass;
  GLfloat dark[4];
  GLfloat light[4];
  GLfloat emission[4];
  GLfloat ambient[4];
  GLfloat specular[4];
  GLfloat shininess;
  GLfloat alpha;
  GLint   colormap[3];
  char    symbol[2];
};

struct NORMAL_MODE
{
  double wavenumber;
  double ir_intensity;
  double raman_intensity;
  double ins_intensity;
  double rel_ir_intensity;
  double rel_raman_intensity;
  double rel_ins_intensity;
  char   sym[4];
};

struct WINDOW
{
  Widget      widget;
  GLXContext  context;
  int         foreground;
  int         background;
  int         mode;
  Widget      menu;
  double      left;
  double      right;
  double      bottom;
  double      top;
  double      near;
  double      far;
  float       foreground_rgb[4];
  float       background_rgb[4];
  XFontStruct *font;
  GLuint      GLfontId;
};

struct OPTION
{
  char flag[8];
  char command[MAXLENLINE];
};

struct COORDS
{
  GLdouble x;
  GLdouble y;
  GLdouble z;
  GLdouble gx;
  GLdouble gy;
  GLdouble gz;
};

struct INTERNAL
{
  double value;
  int atoms[4];
  int type;
};

struct OPTIMIZATION
{
  GLdouble energy;
  GLdouble gnorm;
  int      coords;
  int      natoms;
};

struct ORBITAL
{
  GLdouble energy;
  GLdouble occupation;
  double  *coeff;
  char     symmetry[4];
};

struct GRIDOBJECT
{
  double resolution;
  double *grid;
  int    type;
  int    number;
};

struct ZOOM
{
  int    window;
  double left;
  double right;
  double bottom;
  double top;
};

struct TOGGLE
{
  int *var;
  int  value;
  void (*draw)();
};

struct SLIDER
{
  double *number;
  int    decimals;
  void   (*draw)();
};
