/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                                 H P G L . C                                  *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1996                   *
*                                                                              *
********************************************************************************
*
* $Id: hpgl.c,v 1.1 1996/12/10 18:41:12 jrh Exp $
* $Log: hpgl.c,v $
 * Revision 1.1  1996/12/10  18:41:12  jrh
 * Initial revision
 *
*/
#include<math.h>
#include<stdio.h>
#include<X11/Xlib.h>
#include<GL/gl.h>
#include "viewmol.h"

extern struct WINDOW windows[4];
extern double tmat[4][4], prmat[4][4];
static char pu[]="PU", pd[]="PD";
static FILE *file=NULL;
static double xnull, ynull, znull, fsx, fsy, pixel, stipple[8*sizeof(GLushort)];
static char *pen, *stippleStart;
static int what, lastpen, portrait, nstipple=0;

void getMatrix(double matrix[4][4]);
void multMatrix(double matrix1[4][4], double matrix2[4][4], double matrix3[4][4]);
FILE *hpglInit(char *, double, double, double, double, double, double,
		   Dimension, int);
void hpglClose(void);
void hpglBegin(int);
void hpglEnd(void);
void hpglVertex3d(double, double, double);
void hpglVertex2d(double, double);
void hpglNormal3d(double, double, double);
void hpglColor4fv(const GLfloat *);
void plotString(char *, double, double, double, GLuint);
void hpglLineStipple(GLint, GLushort);
void hpglLineWidth(GLfloat);
void hpglDisable(GLenum);
void hpglClearColor(GLclampf, GLclampf, GLclampf, GLclampf);
void hpglChangeMatrix(int);
void hpglOrtho(GLdouble, GLdouble, GLdouble, GLdouble, GLdouble, GLdouble);
void hpglPopMatrix(void);

void getMatrix(double matrix[4][4])
{
  double mvmat[4][4], prmat[4][4];

  glGetDoublev(GL_MODELVIEW_MATRIX, &mvmat[0][0]);
  glGetDoublev(GL_PROJECTION_MATRIX, &prmat[0][0]);
  multMatrix(mvmat, prmat, matrix);
}

void multMatrix(double matrix1[4][4], double matrix2[4][4], double matrix3[4][4])
{
  register int i, j, k;

  for (i=0; i<4; i++)
  {
    for (j=0; j<4; j++)
    {
      matrix3[i][j]=0.0e0;
      for (k=0; k<4; k++)
        matrix3[i][j]+=matrix1[i][k]*matrix2[k][j];
    }
  }
}

FILE *hpglInit(char *filename, double left, double right, double bottom,
               double top, double fontSizeX, double fontSizeY, Dimension width,
		   int rotate)
{
  register int i, j;

  lastpen=0;
  if (file == NULL)
  {
    file=fopen(filename, "w");
    fprintf(file, "IN;\n");
    if (rotate)
      fprintf(file, "SC%f,%f,%f,%f;\n", bottom, top, left, right);
    else
      fprintf(file, "SC%f,%f,%f,%f;\n", left, right, bottom, top);
    portrait=rotate;
    getMatrix(tmat);
    for (i=0; i<4; i++)
    {
	for (j=0; j<4; j++)
      {
	  if (i == j)
	    prmat[i][j]=1.0;
        else
	    prmat[i][j]=0.0;
	}
    }
    fsx=fontSizeX;
    fsy=fontSizeY;
    pixel=(right-left)/(double)width;
  }
  return(file);
}

void hpglClose(void)
{
  fprintf(file, "SP0;");
  fclose(file);
  file=NULL;
}

void hpglBegin(int mode)
{
  what=mode;
  pen=pu;
}

void hpglEnd()
{
  if ((-what) == GL_LINE_LOOP) hpglVertex3d(xnull, ynull, znull);
  fprintf(file, "\n");
}

void hpglVertex3d(double x, double y, double z)
{
  static double xold, yold;
  static int j=0;
  double xt, yt, xv, yv;
  register int i, loop=TRUE;

  xt=x*tmat[0][0]+y*tmat[1][0]+z*tmat[2][0]+tmat[3][0];
  yt=x*tmat[0][1]+y*tmat[1][1]+z*tmat[2][1]+tmat[3][1];
  if (nstipple && pen == pd)
  {
    xv=xt-xold;
    yv=yt-yold;
    pen=stippleStart;
    while (loop)
    {
      for (i=0; i<=nstipple; i++)
      {
        xold+=stipple[i]*xv;
        yold+=stipple[i]*yv;
        if ((xold > xt && xv > 0.0) || (xold < xt && xv < 0.0))
        {
          xold=xt;
          loop=FALSE;
        }
        if ((yold > yt && yv > 0.0) || (yold < yt && yv < 0.0))
        {
          yold=yt;
          loop=FALSE;
        }
        if (portrait)
          j+=fprintf(file, "%s%f,%f;", pen, -yold, xold);
        else
          j+=fprintf(file, "%s%f,%f;", pen, xold, yold);
        if (j > 80)
        {
	    fprintf(file, "\n");
	    j=0;
        }
        if (pen == pd)
          pen=pu;
        else
          pen=pd;
      }
    }
    pen=pd;
  }
  else
  {
    if (portrait)
      j+=fprintf(file, "%s%f,%f;", pen, -yt, xt);
    else
      j+=fprintf(file, "%s%f,%f;", pen, xt, yt);
  }
  xold=xt;
  yold=yt;
  if (what == GL_LINE_LOOP)
  {
    xnull=x;
    ynull=y;
    znull=z;
    what=(-what);
  }
  
  if (what == GL_LINES && pen == pd)
    pen=pu;
  else
    pen=pd;
}

void hpglVertex2d(double x, double y)
{
  hpglVertex3d(x, y, 0.0);
}

void hpglNormal3d(double x, double y, double z)
{
}

void hpglColor4fv(const GLfloat *color)
{
  static GLdouble pens[16][4];
  register int i;

  for (i=0; i<lastpen; i++)
  {
    if (pens[i][0] == color[0] && pens[i][1] == color[1] &&
	  pens[i][2] == color[2] && pens[i][3] == color[3])
    {
      fprintf(file, "SP%d;\n", i+1);
      return;
    }
  }
  pens[lastpen][0]=color[0]; 
  pens[lastpen][1]=color[1]; 
  pens[lastpen][2]=color[2]; 
  pens[lastpen][3]=color[3]; 
  fprintf(file, "SP%d;\n", lastpen+1);
  if (lastpen < 15) lastpen++;
}

void plotString(char *s, double x, double y, double z, GLuint dummy)
{
/* This subroutine plots the string s scaled with sf
   starting at the position x, y, and z. Plotting
   is done to the file pointed to by file. */

/* Character data */
  static short chr[]={
  /* ! */
  28,8,11,8,15,8,15,12,15,12,15,12,11,12,11,8,11,10,20,5,40,5,40,16,40,16,40,
  10,20,
  /* " */
  24,3,40,8,40,8,40,8,30,8,30,3,40,13,40,18,40,18,40,18,30,18,30,13,40,
  /* # */
  16,3,22,19,22,3,30,19,30,7,18,7,34,15,18,15,34,
  /* $ */
  48,3,15,7,11,7,11,14,11,14,11,18,15,18,15,18,22,18,22,14,26,14,26,7,26,7,26,
  3,30,3,30,3,36,3,36,7,40,7,40,14,40,14,40,18,36,11,40,11,11,
  /* % */
  36,3,11,18,40,3,40,10,40,10,40,10,33,10,33,3,33,3,33,3,40,11,18,18,18,18,18,
  18,11,18,11,11,11,11,11,11,18,
  /* & */
  48,18,22,14,22,14,22,14,15,14,15,10,11,10,11,7,11,7,11,3,15,3,15,3,22,3,22,
  14,30,14,30,14,36,14,36,10,40,10,40,5,36,5,36,5,30,5,30,18,11,
  /* ' */
  12,8,40,13,40,13,40,13,30,13,30,8,40,
  /* ( */
  12,6,11,3,20,3,20,3,31,3,31,6,40,
  /* ) */
  12,15,11,18,20,18,20,18,31,18,31,15,40,
  /* * */
  16,3,26,19,26,11,18,11,34,3,18,19,34,3,34,19,18,
  /* + */
  8,3,26,19,26,11,18,11,34,
  /* , */
  24,8,15,8,20,8,20,12,20,12,20,12,15,12,15,9,11,9,11,10,15,10,15,8,15,
  /* - */
  4,3,26,18,26,
  /* . */
  16,8,11,8,15,8,15,12,15,12,15,12,11,12,11,8,11,
  /* / */
  4,3,11,18,40,
  /* 0 */
  36,3,15,3,36,3,36,7,40,7,40,14,40,14,40,18,36,18,36,18,15,18,15,14,11,14,11,
  7,11,7,11,3,15,3,15,18,36,
  /* 1 */
  8,3,26,11,40,11,40,11,11,
  /* 2 */
  28,3,30,3,36,3,36,7,40,7,40,14,40,14,40,18,36,18,36,18,30,18,30,3,11,3,11,18,
  11,
  /* 3 */
  32,3,40,18,40,18,40,11,26,11,26,14,26,14,26,18,22,18,22,18,15,18,15,14,11,14,
  11,7,11,7,11,3,15,
  /* 4 */
  12,3,15,14,40,14,20,14,11,3,15,18,15,
  /* 5 */
  32,3,15,7,11,7,11,14,11,14,11,18,15,18,15,18,22,18,22,14,26,14,26,3,26,3,26,
  3,40,3,40,18,40,
  /* 6 */
  44,3,22,7,26,7,26,14,26,14,26,18,22,18,22,18,15,18,15,14,11,14,11,7,11,7,11,
  3,15,3,15,3,36,3,36,7,40,7,40,14,40,14,40,18,36,
  /* 7 */
  8,3,40,18,40,18,40,7,11,
  /* 8 */
  60,3,15,3,22,3,22,7,26,7,26,14,26,14,26,18,30,18,30,18,36,18,36,14,40,14,40,
  7,40,7,40,3,36,3,36,3,30,3,30,7,26,14,26,18,22,18,22,18,15,18,15,14,11,14,11,
  7,11,7,11,3,15,
  /* 9 */
  40,3,15,7,11,7,11,14,11,14,11,18,15,18,15,18,36,18,36,14,40,14,40,7,40,7,40,
  3,36,3,36,3,30,3,30,7,26,7,26,18,26,
  /* : */
  32,8,25,8,30,8,30,12,30,12,30,12,25,12,25,8,25,8,15,8,20,8,20,12,20,12,20,12,
  15,12,15,8,15,
  /* ; */
  40,8,25,8,30,8,30,12,30,12,30,12,25,12,25,8,25,8,15,8,20,8,20,12,20,12,20,12,
  15,12,15,9,11,9,11,10,15,10,15,8,15,
  /* < */
  8,10,16,3,23,3,23,10,30,
  /* = */
  8,3,29,18,29,18,23,3,23,
  /* > */
  8,11,30,18,23,18,23,11,16,
  /* ? */
  48,8,11,8,15,8,15,12,15,12,15,12,11,12,11,8,11,8,20,18,30,18,30,18,36,18,36,
  14,40,14,40,7,40,7,40,3,36,3,36,10,36,10,36,13,33,13,33,8,20,
  /* @ */
  0,
  /* A */
  24,3,11,3,36,3,36,7,40,7,40,14,40,14,40,18,36,18,36,18,11,18,26,3,26,
  /* B */
  40,3,11,3,40,3,40,14,40,14,40,18,36,18,36,18,30,18,30,14,26,14,26,3,26,14,26,
  18,22,18,22,18,15,18,15,14,11,14,11,3,11,
  /* C */
  28,18,15,14,11,14,11,7,11,7,11,3,15,3,15,3,36,3,36,7,40,7,40,14,40,14,40,18,
  36,
  /* D */
  24,3,11,3,40,3,40,14,40,14,40,18,36,18,36,18,15,18,15,14,11,14,11,3,11,
  /* E */
  16,3,11,3,40,3,40,18,40,14,26,3,26,3,11,18,11,
  /* F */
  12,3,11,3,40,3,40,18,40,14,26,3,26,
  /* G */
  36,11,26,18,26,18,26,18,15,18,15,14,11,14,11,7,11,7,11,3,15,3,15,3,36,3,36,
  7,40,7,40,14,40,14,40,18,36,
  /* H */
  12,3,11,3,40,18,40,18,11,18,26,3,26,
  /* I */
  12,7,11,14,11,11,11,11,40,7,40,14,40,
  /* J */
  16,3,15,7,11,7,11,14,11,14,11,18,15,18,15,18,40,
  /* K */
  16,3,11,3,40,18,40,11,26,11,26,3,26,11,26,18,11,
  /* L */
  8,3,40,3,11,3,11,18,11,
  /* M */
  16,3,11,3,40,3,40,11,26,11,26,18,40,18,40,18,11,
  /* N */
  12,3,11,3,40,3,40,18,11,18,11,18,40,
  /* O */
  32,3,15,3,36,3,36,7,40,7,40,14,40,14,40,18,36,18,36,18,15,18,15,14,11,14,11,
  7,11,7,11,3,15,
  /* P */
  24,3,11,3,40,3,40,14,40,14,40,18,36,18,36,18,30,18,30,14,26,14,25,3,26,
  /* Q */
  36,3,15,3,36,3,36,7,40,7,40,14,40,14,40,18,36,18,36,18,15,18,15,14,11,14,11,
  7,11,7,11,3,15,14,15,18,11,
  /* R */
  28,3,11,3,40,3,40,14,40,14,40,18,36,18,36,18,30,18,30,14,26,14,26,3,26,14,
  26,18,11,
  /* S */
  44,3,15,7,11,7,11,14,11,14,11,18,15,18,15,18,22,18,22,14,26,14,26,7,26,7,
  26,3,30,3,30,3,36,3,36,7,40,7,40,14,40,14,40,18,36,
  /* T */
  8,11,11,11,40,3,40,18,40,
  /* U */
  20,3,40,3,15,3,15,7,11,7,11,14,11,14,11,18,15,18,15,18,40,
  /* V */
  8,3,40,11,11,11,11,18,40,
  /* W */
  24,3,40,3,15,3,15,7,11,7,11,11,15,11,15,14,11,14,11,18,15,18,15,18,40,
  /* X */
  8,3,40,18,11,3,11,18,40,
  /* Y */
  12,3,40,11,26,11,26,18,40,11,26,11,11,
  /* Z */
  12,3,40,18,40,18,40,3,11,3,11,18,11,
  /* [ */
  0,
  /* \ */
  4,3,40,18,11,
  /* ] */
  0,
  /* ^ */
  0,
  /* _ */
  4,3,11,18,11,
  /* ` */
  0,
  /* a */
  32,3,15,3,22,3,22,7,26,7,26,14,26,14,26,18,22,18,26,18,11,18,15,14,11,14,
  11,7,11,7,11,3,15,
  /* b */
  32,3,11,3,40,3,22,7,26,7,26,14,26,14,26,18,22,18,22,18,15,18,15,14,11,14,
  11,7,11,7,11,3,15,
  /* c */
  28,18,15,14,11,14,11,7,11,7,11,3,15,3,15,3,22,3,22,7,26,7,26,14,26,14,26,
  18,22,
  /* d */
  32,18,15,14,11,14,11,7,11,7,11,3,15,3,15,3,22,3,22,7,26,7,26,14,26,14,26,
  18,22,18,40,18,11,
  /* e */
  36,18,15,14,11,14,11,7,11,7,11,3,15,3,15,3,22,3,22,7,26,7,26,14,26,14,26,
  18,22,18,22,18,18,18,18,3,18,
  /* f */
  20,7,11,7,36,7,36,11,40,11,40,14,40,14,40,18,36,11,26,3,26,
  /* g */
  44,3,5,7,1,7,1,14,1,14,1,18,5,18,5,18,26,18,22,14,26,14,26,7,26,7,26,3,22,
  3,22,3,15,3,15,7,11,7,11,14,11,14,11,18,15,
  /* h */
  20,3,11,3,40,3,22,7,26,7,26,14,26,14,26,18,22,18,22,18,11,
  /* i */
  16,7,11,14,11,11,11,11,26,11,26,7,26,11,31,11,34,
  /* j */
  20,5,5,9,1,9,1,12,1,12,1,16,5,16,5,16,26,16,31,16,34,
  /* k */
  12,3,11,3,40,18,27,3,19,3,19,18,11,
  /* l */
  12,7,11,14,11,11,11,11,40,11,40,7,40,
  /* m */
  28,3,11,3,26,3,22,7,26,7,26,11,22,11,22,11,11,11,22,15,26,15,26,19,22,19,
  22,19,11,
  /* n */
  20,3,11,3,26,3,22,7,26,7,26,14,26,14,26,18,22,18,22,18,11,
  /* o */
  32,3,15,3,22,3,22,7,26,7,26,14,26,14,26,18,22,18,22,18,15,18,15,14,11,14,
  11,7,11,7,11,3,15,
  /* p */
  32,3,1,3,26,3,22,7,26,7,26,14,26,14,26,18,22,18,22,18,15,18,15,14,11,14,
  11,7,11,7,11,3,15,
  /* q */
  32,18,15,14,11,14,11,7,11,7,11,3,15,3,15,3,22,3,22,7,26,7,26,14,26,14,
  26,18,22,18,26,18,1,
  /* r */
  16,3,11,3,26,3,22,7,26,7,26,14,26,14,26,18,22,
  /* s */
  36,3,15,7,11,7,11,14,11,14,11,18,15,18,15,14,19,14,19,6,19,6,19,3,22,3,
  22,7,26,7,26,14,26,14,26,18,22,
  /* t */
  20,18,15,14,11,14,11,10,11,10,11,6,15,6,15,6,40,3,26,9,26,
  /* u */
  20,3,26,3,15,3,15,7,11,7,11,14,11,14,11,18,15,18,11,18,26,
  /* v */
  12,3,26,10,11,10,11,11,11,11,11,18,26,
  /* w */
  24,3,26,3,15,3,15,7,11,7,11,11,15,11,15,15,11,15,11,19,15,19,15,19,26,
  /* x */
  8,3,26,18,11,3,11,18,26,
  /* y */
  32,3,5,7,1,7,1,14,1,14,1,18,5,18,5,18,26,3,26,3,15,3,15,7,11,7,11,14,
  11,14,11,18,15,
  /* z */
  12,3,26,18,26,18,26,3,11,3,11,18,11,
  /* { */
  0,
  /* | */
  4,10,11,10,40,
  /* } */
  0,
  /* ~ */
  0,
  /*  */
  32,3,29,3,36,3,36,7,40,7,40,14,40,14,40,18,36,18,36,18,29,18,29,14,25,14,
  25,7,25,7,25,3,29,
  /*  (Adiaeresis) */
  32,3,11,3,36,3,36,7,40,7,40,14,40,14,40,18,36,18,36,18,11,18,26,3,26,7,
  43,7,46,14,43,14,46,
  /*  (Odiaeresis) */
  40,3,15,3,36,3,36,7,40,7,40,14,40,14,40,18,36,18,36,18,15,18,15,14,11,
  14,11,7,11,7,11,3,15,7,43,7,46,14,43,14,46,
  /*  (Udiaeresis) */
  28,3,40,3,15,3,15,7,11,7,11,14,11,14,11,18,15,18,15,18,40,7,43,7,46,14,
  43,14,46,
  /*  (ssharp) */
  44,3,1,3,36,3,36,7,40,7,40,14,40,14,40,18,36,18,36,18,30,18,30,14,26,14,
  26,11,26,14,26,18,22,18,22,18,15,18,15,14,11,14,11,7,11,
  /*  (adiaeresis) */
  40,3,15,3,22,3,22,7,26,7,26,14,26,14,26,18,22,18,26,18,11,18,15,14,11,
  14,11,7,11,7,11,3,15,7,28,7,31,14,28,14,31,
  /*  (odiaeresis) */
  40,3,15,3,22,3,22,7,26,7,26,14,26,14,26,18,22,18,22,18,15,18,15,14,11,
  14,11,7,11,7,11,3,15,7,28,7,31,14,28,14,31,
  /*  (udiaeresis) */
  28,3,26,3,15,3,15,7,11,7,11,14,11,14,11,18,15,18,11,18,26,7,28,7,31,14,
  28,14,31};
  double x1, y1, x2, y2;
  int chrstart;
  unsigned char ic, *p;
  register int j, k;

  x1=x*tmat[0][0]+y*tmat[1][0]+z*tmat[2][0]+tmat[3][0];
  y1=x*tmat[0][1]+y*tmat[1][1]+z*tmat[2][1]+tmat[3][1];
  for (p=(unsigned char *)s; *p!=(unsigned char)0; p++)
  {
    if (*p != ' ')
    {
      ic=(*p)-'!';
	if (ic > 93)
	{
	  switch (ic)
	  {
	    case 143: ic=94;
			  break;
	    case 163: ic=95;
			  break;
	    case 181: ic=96;
			  break;
	    case 187: ic=97;
			  break;
	    case 190: ic=98;
			  break;
	    case 195: ic=99;
			  break;
	    case 213: ic=100;
			  break;
	    case 219: ic=101;
			  break;
	  }
	}
      chrstart=0;
      k=0;
      for (j=0; j<ic; j++)
      {
        chrstart+=chr[k]+1;
        k+=chr[k]+1;
      }
      for (j=1; j<chr[chrstart]; j+=4)
      {
        x2=x1+fsx*chr[chrstart+j];
        y2=y1+fsy*chr[chrstart+j+1];
        if (portrait)
          fprintf(file, "PU%f,%f;", -y2, x2);
        else
          fprintf(file, "PU%f,%f;", x2, y2);
        x2=x1+fsx*chr[chrstart+j+2];
        y2=y1+fsy*chr[chrstart+j+3];
        if (portrait)
          fprintf(file, "PD%f,%f;\n", -y2, x2);
        else
          fprintf(file, "PD%f,%f;\n", x2, y2);
      }
    }
    x1+=22.*fsx;
  }
}

void hpglLineStipple(GLint line, GLushort style)
{
  int last;
  register int i, j=0;

  if ((last=style & 1) == 1)
    stippleStart=pd;
  else
    stippleStart=pu;
  stipple[0]=pixel;
  for (i=1; i<8*sizeof(GLushort); i++)
  {
    if (((style & (1 << i)) >> i) == last)
	stipple[j]+=pixel;
    else
    {
	last=(style & (1 << i)) >> i;
	stipple[++j]=pixel;
    }
  }
  nstipple=j;
}

void hpglLineWidth(GLfloat lineWidth)
{
}

void hpglDisable(GLenum what)
{
  nstipple=0;
}

void hpglClearColor(GLclampf rad, GLclampf green, GLclampf blue, GLclampf alpha)
{
}

void hpglChangeMatrix(int restore)
{
  static double matrix[4][4], save[4][4];
  register int i, j;

  if (restore)
  {
    for (i=0; i<4; i++)
    {
      for (j=0; j<4; j++)
        tmat[i][j]=save[i][j];
    }
  }
  else
  {
    for (i=0; i<4; i++)
    {
      for (j=0; j<4; j++)
        save[i][j]=tmat[i][j];
    }
    getMatrix(matrix);
    multMatrix(matrix, prmat, tmat);
  }
}

void hpglOrtho(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble near,
               GLdouble far)
{
  glOrtho(left, right, bottom, top, near, far);
  glGetDoublev(GL_PROJECTION_MATRIX, &tmat[0][0]);
}

void hpglPopMatrix(void)
{
  glPopMatrix();
  glGetDoublev(GL_PROJECTION_MATRIX, &tmat[0][0]);
}
