/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                              M K U N I T C . C                               *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1996                   *
*                                                                              *
********************************************************************************
*
* $Id: mkunitc.c,v 1.1 1996/12/10 18:42:14 jrh Exp $
* $Log: mkunitc.c,v $
 * Revision 1.1  1996/12/10  18:42:14  jrh
 * Initial revision
 *
*
*/
#include<math.h>
#include "viewmol.h"

extern struct ATOM *atoms;
extern struct COORDS *history;
extern double *coord;
extern int na, nhist;

extern void *expmem(void *, size_t, size_t);

int makeUnitCell(double a, double b, double c, double alpha, double beta,
                 double gamma, int frac)
{
/* This function computes from the unit cell lengths
   and angles the cartesian coordinates of the eight
   corners and stores them in atoms[], if frac == TRUE
   the input coordinates are fractional coordinates
   and this function will convert them to cartesian
   coordinates
*/
  double torad, x2=0.0, y2=0.0, x3=0.0, y3=0.0, z3=0.0;
  register int n=na, i;

  torad=atan(1.0e0)/45.0e0;
  alpha*=torad;
  beta*=torad;
  gamma*=torad;

  atoms=(struct ATOM *)expmem((void *)atoms, n+9, sizeof(struct ATOM));
  
  strcpy(atoms[n].name, "Uc");
  atoms[n].x=0.0e0;
  atoms[n].y=0.0e0;
  atoms[n++].z=0.0e0;
  strcpy(atoms[n].name, "Uc");
  atoms[n].x=a;
  atoms[n].y=0.0e0;
  atoms[n++].z=0.0e0;
  strcpy(atoms[n].name, "Uc");
  atoms[n].x=b*cos(gamma);
  atoms[n].y=sqrt(b*b-atoms[n].x*atoms[n].x);
  atoms[n++].z=0.0e0;
  if (frac)
  {
    x2=atoms[n-1].x;
    y2=atoms[n-1].y;
  }
  strcpy(atoms[n].name, "Uc");
  atoms[n].x=c*cos(beta);
  atoms[n].y=(b*c*cos(alpha)-atoms[n-1].x*atoms[n].x)/atoms[n-1].y;
  atoms[n++].z=sqrt(c*c-atoms[n].x*atoms[n].x-atoms[n].y*atoms[n].y);
  if (frac)
  {
    x3=atoms[n-1].x;
    y3=atoms[n-1].y;
    z3=atoms[n-1].z;
  }
  strcpy(atoms[n].name, "Uc");
  atoms[n].x=atoms[n-1].x+atoms[n-3].x;
  atoms[n].y=atoms[n-1].y+atoms[n-3].y;
  atoms[n++].z=atoms[n-1].z+atoms[n-3].z;
  strcpy(atoms[n].name, "Uc");
  atoms[n].x=atoms[n-1].x+atoms[n-3].x;
  atoms[n].y=atoms[n-1].y+atoms[n-3].y;
  atoms[n++].z=atoms[n-1].z+atoms[n-3].z;
  strcpy(atoms[n].name, "Uc");
  atoms[n].x=atoms[n-4].x+atoms[n-3].x;
  atoms[n].y=atoms[n-4].y+atoms[n-3].y;
  atoms[n++].z=atoms[n-4].z+atoms[n-3].z;
  strcpy(atoms[n].name, "Uc");
  atoms[n].x=atoms[n-6].x+atoms[n-5].x;
  atoms[n].y=atoms[n-6].y+atoms[n-5].y;
  atoms[n++].z=atoms[n-6].z+atoms[n-5].z;
  na=n;

  if (frac)
  {
    for (i=0; i<n-8; i++)
    {
	atoms[i].x = a*atoms[i].x+x2*atoms[i].y+x3*atoms[i].z;
	atoms[i].y =y2*atoms[i].y+y3*atoms[i].z;
	atoms[i].z*=z3;
    }
    for (i=0; i<(n-8)*nhist; i++)
    {
      history[i].x = a*history[i].x+x2*history[i].y+x3*history[i].z;
	history[i].y =y2*history[i].y+y3*history[i].z;
	history[i].z*=z3;
    }
  }
  return(TRUE);
}
