/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                              M O U S E C B . C                               *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1996                   *
*                                                                              *
********************************************************************************
*
* $Id: mousecb.c,v 1.1 1996/12/10 18:42:34 jrh Exp $
* $Log: mousecb.c,v $
 * Revision 1.1  1996/12/10  18:42:34  jrh
 * Initial revision
 *
*
*/
#include<X11/Intrinsic.h>
#include<Xm/Xm.h>
#include<Xm/PushBG.h>
#include<Xm/RowColumn.h>
#ifdef __osf__
#include<X11/GLw/GLwMDrawA.h>
#else
#include<GL/GLwMDrawA.h>
#endif
#include<GL/glu.h>
#include "viewmol.h"
#include "menu.h"

void processInput(Widget, caddr_t, GLwDrawingAreaCallbackStruct *);
void doMenu(Widget, Widget, GLwDrawingAreaCallbackStruct *);

extern void setMenuItem(int, int, int);
extern char *bfname(int);
extern Widget makeMenu(Widget, int, char *, struct MenuItem *);
extern void drawMolecule(Widget, caddr_t, GLwDrawingAreaCallbackStruct *);
extern void drawSpectrum(Widget, caddr_t, GLwDrawingAreaCallbackStruct *);
extern void drawHistory(Widget, caddr_t, GLwDrawingAreaCallbackStruct *);
extern void drawMODiagram(Widget, caddr_t, GLwDrawingAreaCallbackStruct *);
extern void viewerMouseAction(XEvent *, int);
extern void spectrumMouseAction(GLwDrawingAreaCallbackStruct *, int);
extern void historyMouseAction(unsigned int, int, int, int, Dimension, Dimension);
extern void MODiagramMouseAction(GLwDrawingAreaCallbackStruct *, int);
extern void viewerKeyAction(KeySym);
extern void spectrumKeyAction(KeySym);
extern void historyKeyAction(KeySym);
extern void MODiagramKeyAction(KeySym);
extern void getTranslation(int, int);
extern void getRotation(int, int);
extern void getEnlargement(int);
extern void zoomIn(Widget, GLwDrawingAreaCallbackStruct *);

extern struct WINDOW windows[];
extern struct ORBITAL *orbitals;
extern float xrot, yrot, zrot;
extern int lines, label, showForces;
extern int rotateXY, rotateZ, imo, ibasfu;
extern int showMenu, primitive, selectAtom, iwavef;
extern int picking, swapBuffers, movelight, simplify;
extern Widget bfMenu;

void processInput(Widget w, caddr_t client_data,  GLwDrawingAreaCallbackStruct *data)
{
  KeySym keysym;
  XComposeStatus status;
  static int primitiveSave;
  char buffer[2];

  if (data->reason == GLwCR_INPUT)
  {
    switch (data->event->type)
    {
      case ButtonPress:   if (w == windows[VIEWER].widget)
                          {
                            if (data->event->xbutton.button != Button3 && simplify && movelight == (-1))
                            {
                              primitiveSave=primitive;
                              primitive=GLU_LINE;
                            }
                            viewerMouseAction(data->event, TRUE);
                          }
                          else if (w == windows[SPECTRUM].widget)
                            spectrumMouseAction(data, TRUE);
                          else if (w == windows[HISTORY].widget)
                            historyMouseAction(data->event->xbutton.button, TRUE,
                                               data->event->xbutton.x, data->event->xbutton.y,
                                               data->width, data->height);
                          else if (w == windows[MO].widget)
                            MODiagramMouseAction(data, TRUE);
                          break;
      case ButtonRelease: if (w == windows[VIEWER].widget)
                          {
                            if (data->event->xbutton.button != Button3 && simplify && movelight == (-1))
                              primitive=primitiveSave;
                            viewerMouseAction(data->event, FALSE);
                            rotateXY=rotateZ=0;
/*                          return; */
                          }
                          else if (w == windows[SPECTRUM].widget)
                            spectrumMouseAction(data, FALSE);
                          else if (w == windows[HISTORY].widget)
                            historyMouseAction(data->event->xbutton.button, FALSE,
                                               data->event->xbutton.x, data->event->xbutton.y,
                                               data->width, data->height);
                          else if (w == windows[MO].widget)
                            MODiagramMouseAction(data, FALSE);
                          break;
      case KeyPress:      XLookupString((XKeyEvent *)data->event, buffer, 2, &keysym, &status); 
                          if (w == windows[VIEWER].widget)
                            viewerKeyAction(keysym);
                          if (w == windows[SPECTRUM].widget)
                            spectrumKeyAction(keysym);
                          else if (w == windows[HISTORY].widget)
                            historyKeyAction(keysym);
                          else if (w == windows[MO].widget)
                            MODiagramKeyAction(keysym);
                          break;
      case MotionNotify:  if (data->event->xmotion.state & Button1Mask)
                          {
                            if (w == windows[VIEWER].widget)
                            {
                              if (data->event->xmotion.state & ShiftMask)
                                getTranslation(data->event->xmotion.x, data->event->xmotion.y);
                              else
                                getRotation(data->event->xmotion.x, data->event->xmotion.y);
                            }
                            else if (w == windows[HISTORY].widget)
                            {
                              historyMouseAction(Button1, TRUE, data->event->xmotion.x,
                                                 data->event->xmotion.y,
                                                 data->width, data->height);
                            }
                          }
                          else if (data->event->xmotion.state & Button2Mask)
                          {
                            if (w == windows[VIEWER].widget)
                              if (data->event->xmotion.state & ShiftMask)
                                getEnlargement(data->event->xmotion.x);
                              else
                                getRotation(data->event->xmotion.x, data->event->xmotion.y);
                            else
                            {
                              zoomIn(w, data);
                              return;
                            }
                          }
                          else
                            return;
                          break;
      default:            break;
      
    }
    drawMolecule(w, client_data, data);
    if (w == windows[SPECTRUM].widget)
      drawSpectrum(w, client_data, data);
    else if (w == windows[HISTORY].widget)
      drawHistory(w, client_data, data);
    else if (w == windows[MO].widget)
      drawMODiagram(w, client_data, data);
  }
}

void doMenu(Widget widget, Widget menu, GLwDrawingAreaCallbackStruct *data)
{
#ifndef LINUX
  if (showMenu || widget != XtParent(windows[VIEWER].widget))
#else
  if (showMenu || widget != windows[VIEWER].widget)
#endif
  {
    if (data->event->xany.type == ButtonPress &&
        data->event->xbutton.button == Button3)
    {
      XmMenuPosition(menu, (XButtonPressedEvent *)(data->event));
      XtManageChild(menu);
    }
  }
  else
    viewerMouseAction(data->event, TRUE);
}

void changeBoolean(Widget w, int *bool, GLwDrawingAreaCallbackStruct *data)
{
  *bool=!(*bool);
  drawMolecule((Widget)0, (caddr_t)0, (GLwDrawingAreaCallbackStruct *)0);
}

void setModel(Widget w, caddr_t model, GLwDrawingAreaCallbackStruct *data)
{
  setMenuItem(VIEWER, windows[VIEWER].mode-WIREMODEL, True);
  windows[VIEWER].mode=(int)model;
  setMenuItem(VIEWER, (int)model-WIREMODEL, False);
  if ((int)model != WIREMODEL)
    setMenuItem(VIEWER, 19, True);
  else
    setMenuItem(VIEWER, 19, False);
  drawMolecule((Widget)0, (caddr_t)0, (GLwDrawingAreaCallbackStruct *)0);
}

void setDiagram(Widget w, caddr_t diagram, GLwDrawingAreaCallbackStruct *data)
{
  if (windows[MO].mode == DENSITY_OF_STATES)
    windows[MO].mode=ENERGY_LEVELS;
  else
    windows[MO].mode=DENSITY_OF_STATES;
  drawMODiagram((Widget)0, (caddr_t)0, (GLwDrawingAreaCallbackStruct *)0);
}
