/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                                 S A V E . C                                  *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1996                   *
*                                                                              *
********************************************************************************
*
* $Id: save.c,v 1.1 1996/12/10 18:43:57 jrh Exp $
* $Log: save.c,v $
 * Revision 1.1  1996/12/10  18:43:57  jrh
 * Initial revision
 *
*
*/
#include<stdio.h>
#include "viewmol.h"
#include "dialog.h"

extern void GetMessageBoxButton(Widget, XtPointer, caddr_t);
extern char *selectFile(char *, char *);
extern char *getStringResource(Widget, char *);
extern int messgb(Widget, int, char *, struct PushButtonRow *, int);

extern struct ATOM *atoms;
extern double radfac, transx, transy, transz;
extern int na, existsUnitCell;
extern Widget topShell;

void saveMolecule(Widget widget, caddr_t data1, caddr_t data2)
{
  static struct PushButtonRow buttons[] = {{"continue", GetMessageBoxButton, (XtPointer)0, NULL}};
  FILE *file;
  double a2bohr=radfac/0.52917706;
  char *filename, *word, str[MAXLENLINE];
  register int i, n;

  if ((filename=selectFile("*", "vm_coord")) != NULL)
  {
    file=fopen(filename, "w");

    fprintf(file, "$coord\n");
    n=na;
    if (existsUnitCell) n-=8;
    for (i=0; i<n; i++)
    {
      fprintf(file, "%22.14f%22.14f%22.14f  %s\n", (atoms[i].x-transx)*a2bohr,
              (atoms[i].y-transy)*a2bohr, (atoms[i].z-transz)*a2bohr,
  	  	  atoms[i].name);
    }
    fprintf(file, "$end\n");
    fclose(file);

    word=getStringResource(topShell, "MoleculeSaved");
    sprintf(str, word, filename);
    messgb(topShell, 0, str, buttons, 1);
  }
}
