/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                             S P E C F O R M . C                              *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1996                   *
*                                                                              *
********************************************************************************
*
* $Id: specform.c,v 1.1 1996/12/10 18:44:01 jrh Exp $
* $Log: specform.c,v $
 * Revision 1.1  1996/12/10  18:44:01  jrh
 * Initial revision
 *
*
*/
#include<stdlib.h>
#include<X11/Intrinsic.h>
#include<Xm/Xm.h>
#include<Xm/BulletinB.h>
#include<Xm/DialogS.h>
#include<Xm/Form.h>
#include<Xm/Label.h>
#include<Xm/LabelG.h>
#include<Xm/MwmUtil.h>
#include<Xm/PanedW.h>
#include<Xm/PushB.h>
#include<Xm/PushBG.h>
#include<Xm/RowColumn.h>
#include<Xm/Scale.h>
#include<Xm/Separator.h>
#include<Xm/Text.h>
#include<Xm/ToggleB.h>
#ifdef __osf__
#include<X11/GLw/GLwMDrawA.h>
#else
#include<GL/GLwMDrawA.h>
#endif
#include "viewmol.h"
#include "dialog.h"

void GetMode(Widget, caddr_t, XmToggleButtonCallbackStruct *);
void GetAnimate(Widget, caddr_t, XmToggleButtonCallbackStruct *);
void GetType(Widget, caddr_t, XmToggleButtonCallbackStruct *);
void GetSlider(Widget, struct SLIDER *, XmScrollBarCallbackStruct *);
void GetAmplitude(Widget, caddr_t, XmScrollBarCallbackStruct *);
void GetScale(Widget, caddr_t, XmScrollBarCallbackStruct *);
void spectrumDialogExit(Widget, caddr_t, XmPushButtonCallbackStruct *);
void GetIns(Widget, caddr_t, XmToggleButtonCallbackStruct *);
void GetInsWeight(Widget, caddr_t, XmToggleButtonCallbackStruct *);

extern void MapBox(Widget, caddr_t, XmAnyCallbackStruct *);
extern Widget CreateToggleBox(Widget, struct PushButtonRow *, int, int,
			            int, int);
extern char *getStringResource(Widget, char *);
extern void CreatePushButtonRow(Widget, struct PushButtonRow *, int);
extern void setWindowTitle(Widget, char *);
extern void drawMolecule(Widget, caddr_t, GLwDrawingAreaCallbackStruct *);
extern void drawSpectrum(Widget, caddr_t, GLwDrawingAreaCallbackStruct *);
extern void setAnimation(int);
extern void restoreGeometry(void);
extern void distortGeometry(double);
extern void redraw(int);
extern void setMenuItem(int, int, int);

extern struct WINDOW windows[];
extern struct NORMAL_MODE *normal_modes;
extern int animate, lines, setins, mode;
extern double weight, temp, amplitude, wnScale;
extern Widget topShell;

static Widget dialog, insweight;
static int mode_save, animate_save, lines_save, setins_save;
static double weight_save, temp_save, amplitude_save, wnScale_save;

void spectrumDialog(Widget widget, caddr_t dummy, XmAnyCallbackStruct *data)
{
  static int namplitude;
  Widget board, form, form1, form2, form3, form4;
  Widget radiobox1, radiobox2, radiobox3;
  Widget ins, slider1, slider2, slider3, temperature, ampl, scale;
  Widget sep1, sep2, sep3, sep4, sep5;
  static struct SLIDER tempSlider;
  Arg args[3];
  char str[20];
  static struct PushButtonRow buttons[] = {
    { "ok", spectrumDialogExit, (XtPointer)TRUE, NULL },
    { "cancel", spectrumDialogExit, (XtPointer)FALSE, NULL }
  };
  static struct PushButtonRow radiobox1_buttons[] = {
    { "all_modes", GetMode, (XtPointer)SPECTRUM_ALL, NULL },
    { "ir_modes", GetMode, (XtPointer)SPECTRUM_IR, NULL },
    { "raman_modes", GetMode, (XtPointer)SPECTRUM_RAMAN, NULL },
    { "ins_modes", GetMode, (XtPointer)SPECTRUM_INS, NULL }
  };
  static struct PushButtonRow radiobox2_buttons[] = {
    { "animate", GetAnimate, (XtPointer)ANIMATE, NULL },
    { "draw_arrows", GetAnimate, (XtPointer)ARROWS, NULL },
    { "distort", GetAnimate, (XtPointer)DISTORT, NULL }
  };
  static struct PushButtonRow radiobox3_buttons[] = {
    { "line_spectrum", GetType, (XtPointer)TRUE, NULL },
    { "gaussian_spectrum", GetType, (XtPointer)FALSE, NULL }
  };

  /* This function creates the dialog for the spectrum window */
 
  mode_save=windows[SPECTRUM].mode;
  animate_save=animate;
  lines_save=lines;
  setins_save=setins;
  weight_save=weight;
  temp_save=temp;
  amplitude_save=amplitude;
  wnScale_save=wnScale;
  namplitude=(int)(100.e0*amplitude/windows[VIEWER].top);

  XtSetArg(args[0], XmNautoUnmanage, False);
  XtSetArg(args[1], XmNdefaultPosition, False);
  if (XmIsMotifWMRunning(topShell))
    XtSetArg(args[2], XmNmwmDecorations, MWM_DECOR_RESIZEH | MWM_DECOR_TITLE);
  else
    XtSetArg(args[2], (char *)NULL, 0);
  dialog=XmCreateDialogShell(windows[SPECTRUM].widget, "spectrumForm_popup", args, XtNumber(args));
  board=XtVaCreateWidget("spectrumForm", xmBulletinBoardWidgetClass, dialog,
                         XmNautoUnmanage, False,
                         XmNdefaultPosition, False,
                         NULL);

  /* Form is the row/column widget which organizes the layout of the whole box
     (toggle button boxes/sliders on top, OK/Cancel button on bottom) */
  form=XtVaCreateWidget("rowcolumn", xmRowColumnWidgetClass, board,
                        XmNorientation, XmVERTICAL,
                        NULL);
  /* Form1 is the row/column widget which organizes the toggle button boxes
     at the left and the sliders at the right */
  form1=XtVaCreateWidget("controlarea1", xmRowColumnWidgetClass, form,
                         XmNorientation, XmHORIZONTAL,
                         NULL);

  /* Form2 is the container for the toggle button boxes */
  form2=XtVaCreateWidget("controlarea2", xmFormWidgetClass, form1, NULL);
  sep1=XtVaCreateManagedWidget("sep1", xmSeparatorWidgetClass, form1,
                               XmNorientation, XmVERTICAL,
                               XmNtraversalOn, False,
                               XmNtopAttachment, XmATTACH_FORM,
                               XmNbottomAttachment, XmATTACH_FORM,
                               XmNleftAttachment, XmATTACH_WIDGET,
                               XmNleftWidget, form2,
                               NULL);
  /* Form3 is the container for the sliders */
  form3=XtVaCreateWidget("controlarea3", xmFormWidgetClass, form1, NULL);

  radiobox1=CreateToggleBox(form2, radiobox1_buttons, XtNumber(radiobox1_buttons),
                            XmVERTICAL, True, windows[SPECTRUM].mode-1);
  XtVaSetValues(radiobox1, XmNleftAttachment, XmATTACH_FORM,
                           XmNtopAttachment, XmATTACH_FORM,
                           XmNrightAttachment, XmATTACH_FORM,
                           NULL);
  sep2=XtVaCreateManagedWidget("sep2", xmSeparatorWidgetClass, form2,
                               XmNtraversalOn, False,
                               XmNleftAttachment, XmATTACH_FORM,
                               XmNtopAttachment, XmATTACH_WIDGET,
                               XmNtopWidget, radiobox1,
                               XmNrightAttachment, XmATTACH_FORM,
                               NULL);

  radiobox2=CreateToggleBox(form2, radiobox2_buttons, XtNumber(radiobox2_buttons),
                            XmVERTICAL, True, animate-1);
  XtVaSetValues(radiobox2, XmNleftAttachment, XmATTACH_FORM,
                           XmNtopAttachment, XmATTACH_WIDGET,
                           XmNtopWidget, sep2,
                           XmNrightAttachment, XmATTACH_FORM,
                           NULL);
  sep3=XtVaCreateManagedWidget("sep3", xmSeparatorWidgetClass, form2,
                               XmNtraversalOn, False,
                               XmNleftAttachment, XmATTACH_FORM,
                               XmNtopAttachment, XmATTACH_WIDGET,
                               XmNtopWidget, radiobox2,
                               XmNrightAttachment, XmATTACH_FORM,
                               NULL);

  radiobox3=CreateToggleBox(form2, radiobox3_buttons, XtNumber(radiobox3_buttons),
                            XmVERTICAL, True, lines ? 0 : 1);
  XtVaSetValues(radiobox3, XmNtopAttachment, XmATTACH_WIDGET,
                           XmNtopWidget, sep3,
                           XmNleftAttachment, XmATTACH_FORM,
                           XmNrightAttachment, XmATTACH_FORM,
                           NULL); 

  temperature=XtVaCreateManagedWidget("temperature", xmLabelWidgetClass, form3,
                                      XmNleftAttachment, XmATTACH_FORM,
                                      XmNtopAttachment, XmATTACH_FORM,
                                      NULL);
  slider1=XtVaCreateManagedWidget("temperatureSlider", xmScaleWidgetClass, form3,
                                  XmNorientation, XmVERTICAL,
                                  XmNprocessingDirection, XmMAX_ON_BOTTOM,
                                  XmNvalue, (int)(temp),
                                  XmNminimum, 1,
                                  XmNmaximum, 1000,
                                  XmNshowValue, True,
					    XmNsensitive, True,
                                  XmNleftAttachment, XmATTACH_FORM,
                                  XmNtopAttachment, XmATTACH_WIDGET,
                                  XmNtopWidget, temperature,
                                  XmNbottomAttachment, XmATTACH_FORM,
                                  NULL);
  tempSlider.number=&temp;
  tempSlider.decimals=0;
  tempSlider.draw=(void *)drawSpectrum;
  XtAddCallback(slider1, XmNvalueChangedCallback, (XtCallbackProc)GetSlider, &tempSlider);
  XtAddCallback(slider1, XmNdragCallback, (XtCallbackProc)GetSlider, &tempSlider);

  ampl=XtVaCreateManagedWidget("amplitude", xmLabelWidgetClass, form3,
                               XmNleftAttachment, XmATTACH_WIDGET,
                               XmNleftWidget, temperature,
                               XmNtopAttachment, XmATTACH_FORM,
                               NULL);
  slider2=XtVaCreateManagedWidget("amplitudeSlider", xmScaleWidgetClass, form3,
                                  XmNorientation, XmVERTICAL,
                                  XmNprocessingDirection, XmMAX_ON_BOTTOM,
                                  XmNvalue, namplitude,
                                  XmNshowValue, True,
					    XmNsensitive, True,
                                  XmNleftAttachment, XmATTACH_WIDGET,
                                  XmNleftWidget, temperature,
                                  XmNtopAttachment, XmATTACH_WIDGET,
                                  XmNtopWidget, ampl,
                                  XmNbottomAttachment, XmATTACH_FORM,
                                  NULL);
  XtAddCallback(slider2, XmNvalueChangedCallback, (XtCallbackProc)GetAmplitude, &namplitude);
  XtAddCallback(slider2, XmNdragCallback, (XtCallbackProc)GetAmplitude, &amplitude);

  scale=XtVaCreateManagedWidget("scale", xmLabelWidgetClass, form3,
                                XmNleftAttachment, XmATTACH_WIDGET,
                                XmNleftWidget, ampl,
                                XmNtopAttachment, XmATTACH_FORM,
                                XmNrightAttachment, XmATTACH_FORM,
                                NULL);
  slider3=XtVaCreateManagedWidget("scaleSlider", xmScaleWidgetClass, form3,
                                  XmNorientation, XmVERTICAL,
                                  XmNprocessingDirection, XmMAX_ON_BOTTOM,
                                  XmNvalue, (int)(100.*wnScale),
                                  XmNshowValue, True,
					    XmNsensitive, True,
                                  XmNleftAttachment, XmATTACH_WIDGET,
                                  XmNleftWidget, ampl,
                                  XmNtopAttachment, XmATTACH_WIDGET,
                                  XmNtopWidget, scale,
                                  XmNbottomAttachment, XmATTACH_FORM,
                                  NULL);
  XtAddCallback(slider3, XmNvalueChangedCallback, (XtCallbackProc)GetScale, &wnScale);
  XtAddCallback(slider3, XmNdragCallback, (XtCallbackProc)GetScale, &wnScale);

  sep4=XtVaCreateManagedWidget("sep4", xmSeparatorWidgetClass, form,
                               XmNtraversalOn, False,
                               XmNleftAttachment, XmATTACH_FORM,
                               XmNtopAttachment, XmATTACH_WIDGET,
                               XmNtopWidget, form1,
                               XmNrightAttachment, XmATTACH_FORM,
                               NULL);

  form4=XtVaCreateWidget("controlarea4", xmFormWidgetClass, form, NULL);
  ins=XtVaCreateManagedWidget("setins", xmToggleButtonWidgetClass, form4,
                              XmNleftAttachment, XmATTACH_FORM,
                              XmNtopAttachment, XmATTACH_FORM,
                              XmNbottomAttachment, XmATTACH_FORM,
                              NULL);
  if (setins) XtVaSetValues(ins, XmNset, True, NULL);
  XtAddCallback(ins, XmNvalueChangedCallback, (XtCallbackProc)GetIns, &setins);
  sprintf(str, "%f", weight);
  insweight=XtVaCreateManagedWidget("insweight", xmTextWidgetClass, form4,
                                    XmNvalue, str,
						XmNcolumns, 8,
                                    XmNleftAttachment, XmATTACH_WIDGET,
                                    XmNleftWidget, ins,
                                    XmNtopAttachment, XmATTACH_FORM,
                                    XmNrightAttachment, XmATTACH_FORM,
                                    XmNbottomAttachment, XmATTACH_FORM,
                                    NULL);
  XtAddCallback(insweight, XmNvalueChangedCallback, (XtCallbackProc)GetInsWeight, &weight);
  if (!setins) XtVaSetValues(insweight, XmNsensitive, False, NULL);

  sep5=XtVaCreateManagedWidget("sep5", xmSeparatorWidgetClass, form,
                               XmNtraversalOn, False,
                               XmNleftAttachment, XmATTACH_FORM,
                               XmNtopAttachment, XmATTACH_WIDGET,
                               XmNtopWidget, insweight,
                               XmNrightAttachment, XmATTACH_FORM,
                               NULL);

  XtManageChild(form1);
  XtManageChild(form2);
  XtManageChild(form3);
  XtManageChild(form4);

  CreatePushButtonRow(form, buttons, 2);
  XtAddCallback(dialog, XmNpopupCallback, (XtCallbackProc)MapBox, (XmAnyCallbackStruct *)NULL);
  XtManageChild(form);
  XtManageChild(board);
}

void GetMode(Widget button, caddr_t which, XmToggleButtonCallbackStruct *data)
{
  char t[7], *string;

  if (data->set) windows[SPECTRUM].mode=(int)which;
  sprintf(t, "title%.1d", windows[SPECTRUM].mode);
  string=getStringResource(XtParent(XtParent(windows[SPECTRUM].widget)), t);
  setWindowTitle(XtParent(windows[SPECTRUM].widget), string);
  if (mode != -1)
  {
    if ((windows[SPECTRUM].mode == SPECTRUM_IR && normal_modes[mode].ir_intensity == 0.0) ||
        (windows[SPECTRUM].mode == SPECTRUM_RAMAN && normal_modes[mode].raman_intensity == 0.0))
    {
      mode=(-1);
      if (animate == ANIMATE) setAnimation(FALSE);
      else                    restoreGeometry();
      redraw(VIEWER);
    }
  }
  drawSpectrum((Widget)0, (caddr_t)0, (GLwDrawingAreaCallbackStruct *)0);
}

void GetAnimate(Widget button, caddr_t which, XmToggleButtonCallbackStruct *data)
{
  if (data->set)
  {
    animate=(int)which;
    if (animate == ANIMATE) setAnimation(TRUE);
    else
    {
      setAnimation(FALSE);
      if (animate == DISTORT)
        distortGeometry(amplitude);
    }
    drawMolecule((Widget)0, (caddr_t)0, (GLwDrawingAreaCallbackStruct *)0);
  }
}

void GetType(Widget button, caddr_t which, XmToggleButtonCallbackStruct *data)
{
  if (data->set)
  {
    if ((int)which)
      lines=TRUE;
    else
      lines=FALSE;
    drawSpectrum((Widget)0, (caddr_t)0, (GLwDrawingAreaCallbackStruct *)0);
  }
}

void GetAmplitude(Widget button, caddr_t dummy, XmScrollBarCallbackStruct *data)
{
  amplitude=(double)(data->value)*windows[VIEWER].top/100.e0;
  restoreGeometry();
  if (animate == DISTORT) distortGeometry(amplitude);
  drawMolecule((Widget)0, (caddr_t)0, (GLwDrawingAreaCallbackStruct *)0);
}

void GetScale(Widget button, caddr_t dest, XmScrollBarCallbackStruct *data)
{
  *(double *)dest=(double)(data->value)*0.01;
  redraw(SPECTRUM);
  redraw(VIEWER);
}

void GetIns(Widget button, caddr_t dest, XmToggleButtonCallbackStruct *data)
{
  if (data->set)
  {
    *(int *)dest=TRUE;
    XtVaSetValues(insweight, XmNsensitive, True,  NULL);
  }
  else
  {
    *(int *)dest=FALSE;
    XtVaSetValues(insweight, XmNsensitive, False, NULL);
  }
}

void GetInsWeight(Widget button, caddr_t dest, XmToggleButtonCallbackStruct *data)
{
  char *str;

  str=XmTextGetString(button);
  *(double *)dest=atof(str);
}

void spectrumDialogExit(Widget button, caddr_t which, XmPushButtonCallbackStruct *data)
{
  char t[7], *string;

  if (!(int)which)
  {
    windows[SPECTRUM].mode=mode_save;
    animate=animate_save;
    lines=lines_save;
    setins=setins_save;
    weight=weight_save;
    temp=temp_save;
    amplitude=amplitude_save;
    wnScale=wnScale_save;
    restoreGeometry();
    sprintf(t, "title%.1d", windows[SPECTRUM].mode);
    string=getStringResource(XtParent(XtParent(windows[SPECTRUM].widget)), t);
    setWindowTitle(XtParent(windows[SPECTRUM].widget), string);
  }
  XtDestroyWidget(dialog);
  redraw(SPECTRUM);
  redraw(VIEWER);
}
