/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                               S P H E R E . C                                *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1996                   *
*                                                                              *
********************************************************************************
*
* $Id: sphere.c,v 1.1 1996/12/10 18:44:06 jrh Exp $
* $Log: sphere.c,v $
 * Revision 1.1  1996/12/10  18:44:06  jrh
 * Initial revision
 *
*
*/
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <GL/glu.h>

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

void hpglCylinder(GLUquadricObj *, GLdouble, GLdouble, GLdouble, GLint, GLint);
void hpglSphere(GLUquadricObj *, GLdouble, GLint, GLint);

extern void (*drawBegin)(GLenum), (*drawEnd)(void);
extern void (*drawVertex3d)(GLdouble, GLdouble, GLdouble);
extern void hpglChangeMatrix(int);

extern int primitive;

void hpglCylinder(GLUquadricObj *qobj, GLdouble baseRadius, GLdouble topRadius,
                  GLdouble height, GLint slices, GLint stacks)
{
  GLdouble da, r, dr, dz;
  register GLdouble x, y, z;
  register GLint i, j;

  hpglChangeMatrix(FALSE);

  da=2.0*M_PI/slices;
  dr=(topRadius-baseRadius)/stacks;
  dz=height/stacks;

  if (primitive == GLU_POINT)
  {
    (*drawBegin)(GL_POINTS);
    for (i=0; i<slices; i++)
    {
      x=cos(i*da);
      y=sin(i*da);
      z=0.0;
      r=baseRadius;
      for (j=0; j<=stacks; j++)
      {
        (*drawVertex3d)(x*r, y*r, z);
        z+=dz;
        r+=dr;
      }
    }
    (*drawEnd)();
  }
  else if (primitive == GLU_LINE || primitive == GLU_SILHOUETTE)
  {
    /* Draw rings */
    if (primitive == GLU_LINE)
    {
      z=0.0;
      r=baseRadius;
      for (j=0; j<=stacks; j++)
      {
        (*drawBegin)(GL_LINE_LOOP);
        for (i=0; i<slices; i++)
        {
          x=cos(i*da);
          y=sin(i*da);
          (*drawVertex3d)(x*r, y*r, z);
        }
        (*drawEnd)();
        z+=dz;
        r+=dr;
      }
    }
    else
    {
      /* draw one ring at each end */
      if (baseRadius != 0.0)
      {
        (*drawBegin)(GL_LINE_LOOP);
        for (i=0; i<slices; i++)
        {
          x=cos(i*da);
          y=sin(i*da);
          (*drawVertex3d)(x*baseRadius, y*baseRadius, 0.0);
        }
        (*drawEnd)();
        (*drawBegin)(GL_LINE_LOOP);
        for (i=0; i<slices; i++)
        {
          x=cos(i*da);
          y=sin(i*da);
          (*drawVertex3d)(x*topRadius, y*topRadius, height);
        }
        (*drawEnd)();
      }
    }
    /* draw length lines */
    (*drawBegin)(GL_LINES);
    for (i=0; i<slices; i++)
    {
      x=cos(i*da);
      y=sin(i*da);
      (*drawVertex3d)(x*baseRadius, y*baseRadius, 0.0);
      (*drawVertex3d)(x*topRadius, y*topRadius, height);
    }
    (*drawEnd)();
  }
  hpglChangeMatrix(TRUE);
}

void hpglSphere(GLUquadricObj *qobj, GLdouble radius, GLint slices, GLint stacks)
{
  GLfloat rho, drho, theta, dtheta;
  register GLdouble x, y, z;
  register GLint i, j;

  hpglChangeMatrix(FALSE);

  drho=M_PI/(GLfloat)stacks;
  dtheta=2.0*M_PI/(GLfloat)slices;

  if (primitive == GLU_LINE || primitive == GLU_SILHOUETTE)
  {
    /* draw stack lines */
    for (i=1; i<stacks-1; i++)
    {
      rho=i*drho;
      (*drawBegin)(GL_LINE_LOOP);
      for (j=0; j<slices; j++)
      {
        theta=j*dtheta;
        x=cos(theta)*sin(rho);
        y=sin(theta)*sin(rho);
        z=cos(rho);
        (*drawVertex3d)(x*radius, y*radius, z*radius);
      }
      (*drawEnd)();
    }
    /* draw slice lines */
    for (j=0; j<slices; j++)
    {
      theta=j*dtheta;
      (*drawBegin)(GL_LINE_STRIP);
      for (i=0; i<=stacks; i++)
      {
        rho=i*drho;
        x=cos(theta)*sin(rho);
        y=sin(theta)*sin(rho);
        z=cos(rho);
        (*drawVertex3d)(x*radius, y*radius, z*radius);
      }
      (*drawEnd)();
    }
  }
  else if (primitive == GLU_POINT)
  {
    /* top and bottom-most points */
    (*drawBegin)(GL_POINTS);
    (*drawVertex3d)(0.0, 0.0, radius);
    (*drawVertex3d)(0.0, 0.0, -radius);

    /* loop over stacks */
    for (i=1; i<stacks-1; i++)
    {
      rho=i*drho;
      for (j=0; j<slices; j++)
      {
        theta=j*dtheta;
        x=cos(theta)*sin(rho);
        y=sin(theta)*sin(rho);
        z=cos(rho);
        (*drawVertex3d)(x*radius, y*radius, z*radius);
      }
    }
    (*drawEnd)();
  }
  hpglChangeMatrix(TRUE);
}
