/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                                   T M . C                                    *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1996                   *
*                                                                              *
********************************************************************************
*
* $Id: tm.c,v 1.1 1996/12/10 18:44:15 jrh Exp $
* $Log: tm.c,v $
 * Revision 1.1  1996/12/10  18:44:15  jrh
 * Initial revision
 *
*
*/
#include<ctype.h>
#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<unistd.h>

#define MAXLENLINE 82
#define FALSE 0
#define TRUE  1

/* Prototypes */
void copyDataGroup(FILE *, FILE *, char *, char *);
void readDataGroup(FILE *, FILE *, char *, char *);
FILE *checkfile(FILE *, char *);
void changeDs(char *);
void eof(void);

extern void *getmem(size_t, size_t);
extern void *expmem(void *, size_t, size_t);
extern void fremem(void **);

static char *buffer=NULL;

void main(int argc, char **argv)
{
  FILE *mainfile, *file=NULL;
  char line[MAXLENLINE], copy[MAXLENLINE], *word;
  char *column[6], form[8], pointGroup[4];
  int n=0, atomsDone=FALSE;

  if ((mainfile=fopen(argv[1], "r")) == NULL)
  {
    printf("$error noFile 1 %s\n", argv[1]);
    printf("$end\n");
    exit(-1);
  }
  while (fgets(line, MAXLENLINE, mainfile) != NULL)
  {
    if (line[0] == '#')
      continue;
    else if (strstr(line, "$coord") && !strstr(line, "$coordinateupdate"))
	copyDataGroup(mainfile, file, line, "$coord 0.52917706");
    else if (strstr(line, "$title"))
      copyDataGroup(mainfile, file, line, "$title");
    else if (strstr(line, "$symmetry"))
    {
	printf("%s", line);
	word=strtok(line, " \t");
	word=strtok(NULL, " \t");
	strcpy(pointGroup, word);
	if ((word=strrchr(pointGroup, '\n')) != NULL) *word='\0';
    }
    else if (strstr(line, "$vibrational spectrum"))
    {
	if ((file=checkfile(mainfile, line)) != NULL)
	{
	  if (file != mainfile)
	  {
	    while (fgets(line, MAXLENLINE, file) != NULL)
		if (strstr(line, "$vibrational spectrum")) break;
	  }
	  printf("$vibrational spectrum\n");
	  if (fgets(line, MAXLENLINE, file) != NULL)
	  {
	    while (line[0] != '$')
	    {
 	      if (line[0] != '#')
	      {
	        column[0]=strtok(line, " \t");
	        column[1]=strtok(NULL, " \t");
	        column[2]=strtok(NULL, " \t");
	        column[3]=strtok(NULL, " \t");
	        column[4]=strtok(NULL, " \t");
	        column[5]=strtok(NULL, " \t");
	        if (*column[4] != '-')
	        {
		    column[1][0]=(char)toupper(column[1][0]);
	  	    printf("%s %s %s ", column[1], column[2], column[3]);
		    if (strstr(column[5], "NO"))
		      printf("0.0000000\n");
                else
		      printf("1.0000000\n");
	        }
	  	  else
	  	    printf("- %s %s 0.0000000\n", column[1], column[2]);
	      }
	      fgets(line, MAXLENLINE, file);
	    }
        }
	  if (file != mainfile) fclose(file);
	  fseek(file, -strlen(line), SEEK_CUR);
	}
    }
    else if (strstr(line, "$vibrational normal modes"))
	copyDataGroup(mainfile, file, line, "$vibrational normal modes");
    else if (strstr(line, "$grad"))
    {
      if ((file=checkfile(mainfile, line)) != NULL)
      {
        printf("%s", line);
        if (fgets(line, MAXLENLINE, file) == NULL) eof();
        while (line[0] != '$')
        {
          if (line[0] != '#')
	    {
		strcpy(copy, line);
		strtok(copy, " ");
		strtok(NULL, " ");
		strtok(NULL, " ");
		if (strtok(NULL, " ") == NULL)
		{
		  changeDs(line);
		  printf("%s\n", line);
		}
            else
		  printf("%s", line);
          }
          if (fgets(line, MAXLENLINE, file) == NULL) eof();
        }
        if (file != mainfile) fclose(file);
        fseek(file, -strlen(line), SEEK_CUR);
      }
    }
    else if (strstr(line, "$scfmo"))
    {
	if ((file=checkfile(mainfile, line)) != NULL)
	{
	  if (!strstr(line, "conv") && !strstr(line, "firstorder"))
	  {
	    printf("$error notConverged 0 control\n");
	    if (file != mainfile) fclose(file);
	    continue;
	  }
	  if (!strcmp(pointGroup, "c1"))
	    printf("%s", line);
        else
	  {
	    word=strrchr(line, '\n');
	    *word='\0';
	    printf("%s symmetrized\n", line);
	  }
	  if ((word=strchr(line, '.')) != NULL)
        {
	    *word--='\0';
	    while (isdigit(*word)) word--;
	    n=atoi(++word);
	    sprintf(form, "%%.%ds ", n);
	  }
	  if (fgets(line, MAXLENLINE, file) == NULL) eof();
	  while (line[0] != '$')
	  {
	    if (line[0] != '#')
	    {
		if (strstr(line, "eigenvalue"))
            {
		  changeDs(line);
		  printf("%s\n", line);
		}
		else
		{
	        changeDs(line);
		  word=line;
		  while (word-strlen(line) < line)
		  {
		    printf(form, word);
		    word+=n;
		  }
              printf("\n");
		}
	    }
	    if (fgets(line, MAXLENLINE, file) == NULL) eof();
	  }
	  if (file != mainfile) fclose(file);
        fseek(file, -strlen(line), SEEK_CUR);
	}
    }
    else if (strstr(line, "$closed shells"))
	readDataGroup(mainfile, file, line, "$closed shells");
    else if (strstr(line, "$open shells"))
	readDataGroup(mainfile, file, line, "$open shells");
    else if (strstr(line, "$atoms"))
    {
	copyDataGroup(mainfile, file, line, "$atoms");
	atomsDone=TRUE;
    }
    else if (strstr(line, "$basis"))
    {
	if (atomsDone)
	  copyDataGroup(mainfile, file, line, "$basis");
	else
	  readDataGroup(mainfile, file, line, "$basis");
    }
    else if (strstr(line, "$pople"))
    {
	if (strstr(line, "CAO")) printf("$pople 6d/10f/15g\n");
	else                     printf("$pople 5d/7f/9g\n");
    }
  }
  eof();
}

void copyDataGroup(FILE *mainfile, FILE *file, char *line, char *dataGroup)
{
  int found;
  char l[MAXLENLINE];

  if ((file=checkfile(mainfile, line)) != NULL)
  {
    strcpy(l, dataGroup);
    strtok(l, " ");
    if (file != mainfile && !strstr(line, l))
    {
	found=FALSE;
	while (fgets(line, MAXLENLINE, file) != NULL)
      {
	  if (strstr(line, dataGroup))
	  {
	    found=TRUE;
	    break;
	  }
	}
	if (!found)
	{
	  fclose(file);
	  return;
      }
    }
    printf("%s\n", dataGroup);
    if (fgets(line, MAXLENLINE, file) == NULL)
	if (file == mainfile) eof();
    while (line[0] != '$')
    {
      if (line[0] != '#') printf("%s", line);
      if (fgets(line, MAXLENLINE, file) == NULL)
	  if (file == mainfile) eof();
    }
    if (file != mainfile) fclose(file);
    else fseek(file, -strlen(line), SEEK_CUR);
  }
}

void readDataGroup(FILE *mainfile, FILE *file, char *line, char *dataGroup)
{
  static size_t bufsiz=1000;

  if (buffer == NULL) buffer=(char *)getmem(bufsiz, sizeof(char));

  if ((file=checkfile(mainfile, line)) != NULL)
  {
    strcat(buffer, dataGroup);
    strcat(buffer, "\n");
    if (fgets(line, MAXLENLINE, file) == NULL) eof();
    while (line[0] != '$')
    {
	if (line[0] != '#')
	{
        if (strlen(buffer)+strlen(line) < bufsiz)
	    strcat(buffer, line);
	  else
	  {
	    bufsiz+=1000;
	    buffer=(char *)expmem((void *)buffer, bufsiz, sizeof(char));
	    strcat(buffer, line);
	  }
      }
	if (fgets(line, MAXLENLINE, file) == NULL) eof();
    }
    if (file != mainfile) fclose(file);
    fseek(file, -strlen(line), SEEK_CUR);
  }
}

FILE *checkfile(FILE *mainfile, char *line)
{
  FILE *file;
  char *filename, l[MAXLENLINE];

  if ((filename=strrchr(line, '\n')) != NULL) *filename='\0';
  if (strstr(line, "file"))
  {
    filename=strchr(line, '=')+1;
    if ((file=fopen(filename, "r")) == NULL)
    {
	if (strstr(line, "$coord"))
 	  printf("$error noFile 1 %s\n", filename);
      else
 	  printf("$error noFile 0 %s\n", filename);
    }
    else
    {
	fgets(l, MAXLENLINE, file);
	strcpy(line, l);
    }
    return(file);
  }
  else
    return(mainfile);
}

void changeDs(char *line)
{
  char *p;

  p=line;
  while (*p != '\0')
  {
    if (*p == 'D') *p='e';
    if (*p == '\n') *p='\0';
    p++;
  }
}

void eof(void)
{
  printf("%s", buffer);
  fremem((void **)&buffer);
  printf("$end");
  exit(0);
}
