/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                            B A S I S F O R M . C                             *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1996                   *
*                                                                              *
********************************************************************************
*
* $Id: basisform.c,v 1.1 1996/12/10 18:39:41 jrh Exp $
* $Log: basisform.c,v $
* Revision 1.1  1996/12/10  18:39:41  jrh
* Initial revision
*
*
*/
#include<stdlib.h>
#include<X11/Intrinsic.h>
#include<Xm/Xm.h>
#include<Xm/DialogS.h>
#include<Xm/Form.h>
#include<Xm/Label.h>
#include<Xm/LabelG.h>
#include<Xm/MwmUtil.h>
#include<Xm/PanedW.h>
#include<Xm/PushB.h>
#include<Xm/PushBG.h>
#include<Xm/RowColumn.h>
#include<Xm/Scale.h>
#include<Xm/Separator.h>
#include<Xm/Text.h>
#include<Xm/ToggleB.h>
#include<Xm/VendorS.h>
#include "tiffio.h"
#include "viewmol.h"
#include "dialog.h"
#include "menu.h"

void basisDialog(int);
void basisDialogExit(Widget, caddr_t, XmPushButtonCallbackStruct *);
void getBasisfunction(Widget, caddr_t, XmToggleButtonCallbackStruct *);

extern void MapBox(Widget, caddr_t, XmAnyCallbackStruct *);
extern Widget CreateToggleBox(Widget, struct PushButtonRow *, int, int,
                              int, int, int);
extern char *getStringResource(Widget, char *);
extern char *bfname(int);
extern void bfnamn(int, int *, int*);
extern void *getmem(size_t, size_t);
extern void CreatePushButtonRow(Widget, struct PushButtonRow *, int);
extern void calcmo(void);
extern void redraw(int);

extern struct WINDOW windows[];
extern struct ATOM *atoms;
extern struct ORBITAL *orbitals;
extern Widget topShell;
extern int iwavef, imo, ibasfu, selectAtom;
static Widget dialog;

void basisDialog(int bfAtom)
{
  Widget board, form, form1, atomname, sep;
  Widget radiobox;
  XmString name;
  Arg args[3];
  static struct PushButtonRow buttons[] = {
    { "ok", basisDialogExit, (XtPointer)TRUE, NULL },
    { "cancel", basisDialogExit, (XtPointer)FALSE, NULL }
  };
  struct PushButtonRow *radiobox_buttons;
  int start, end;
  char *label, *word, aname[MAXLENLINE];
  register int i, j;

  /* This function creates the dialog for selecting a basis function */

  XtSetArg(args[0], XmNautoUnmanage, False);
  XtSetArg(args[1], XmNdefaultPosition, False);
  if (XmIsMotifWMRunning(topShell))
    XtSetArg(args[2], XmNmwmDecorations, MWM_DECOR_RESIZEH | MWM_DECOR_TITLE);
  else
    XtSetArg(args[2], (char *)NULL, 0);
  dialog=XmCreateDialogShell(XtParent(windows[VIEWER].widget), "basisForm_popup",
				     args, XtNumber(args));
  board=XtVaCreateWidget("basisForm", xmFormWidgetClass, dialog,
                         XmNautoUnmanage, False,
                         XmNdefaultPosition, False,
                         NULL);
  form=XtVaCreateWidget("rowcolumn", xmRowColumnWidgetClass, board,
                        XmNorientation, XmVERTICAL,
                        XmNtopAttachment, XmATTACH_FORM,
                        XmNbottomAttachment, XmATTACH_FORM,
                        XmNleftAttachment, XmATTACH_FORM,
                        XmNrightAttachment, XmATTACH_FORM,
                        NULL);
  atomname=XtVaCreateManagedWidget("atomname", xmLabelWidgetClass, form,
                                   XmNleftAttachment, XmATTACH_FORM,
                                   XmNrightAttachment, XmATTACH_FORM,
                                   XmNtopAttachment, XmATTACH_FORM,
                                   NULL);
  word=getStringResource(atomname, "labelString");
  sprintf(aname, word, atoms[bfAtom].name, bfAtom+1);
  name=XmStringCreateSimple(aname);
  XtVaSetValues(atomname, XmNlabelString, name, NULL);
  XmStringFree(name);
  form1=XtVaCreateWidget("controlarea", xmRowColumnWidgetClass, form,
                         XmNorientation, XmHORIZONTAL,
                         XmNleftAttachment, XmATTACH_FORM,
                         XmNrightAttachment, XmATTACH_FORM,
                         NULL);
  bfnamn(bfAtom, &start, &end);
  radiobox_buttons=(struct PushButtonRow *)getmem(end-start+2, sizeof(struct PushButtonRow));
  label=(char *)getmem(end-start+1, 19*sizeof(char));
  j=0;
  for (i=start; i<=end; i++)
  {
    if (iwavef == BASIS_IN_MO)
    {
      sprintf(&label[19*j], "%10.6f*%s", orbitals[imo].coeff[i], bfname(i));
      radiobox_buttons[j].label=&(label[19*j]);
    }
    else
      radiobox_buttons[j].label=bfname(i);
    radiobox_buttons[j].callback=getBasisfunction;
    radiobox_buttons[j].client_data=(XtPointer)i;
    radiobox_buttons[j++].widget=(Widget)NULL;
  }
  radiobox=CreateToggleBox(form1, radiobox_buttons, j, (int)XmVERTICAL, j/10+1,
				   True, 0);
  ibasfu=start;
  sep=XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, form1,
                              XmNorientation, XmHORIZONTAL,
                              XmNtraversalOn, False,
                              XmNleftAttachment, XmATTACH_FORM,
                              XmNrightAttachment, XmATTACH_FORM,
                              XmNtopAttachment, XmATTACH_WIDGET,
                              XmNtopWidget, radiobox,
                              NULL);
  XtManageChild(form1);

  CreatePushButtonRow(form, buttons, 2);
  XtAddCallback(dialog, XmNpopupCallback, (XtCallbackProc)MapBox, (XmAnyCallbackStruct *)NULL);
  XtManageChild(form);
  XtManageChild(board);
}

void getBasisfunction(Widget widget, caddr_t which, XmToggleButtonCallbackStruct *data)
{
  if (data->set) ibasfu=(int)which;
}

void basisDialogExit(Widget widget, caddr_t what, XmPushButtonCallbackStruct *data)
{
  XtDestroyWidget(dialog);
  selectAtom=FALSE;
  if ((int)what)
  {
    calcmo();
    redraw(VIEWER);
  }
  else
  {
    iwavef=ALL_OFF;
    ibasfu=(-1);
  }
}
