/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                             D R A W F O R M . C                              *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1996                   *
*                                                                              *
********************************************************************************
*
* $Id: drawform.c,v 1.1 1996/12/10 18:40:31 jrh Exp $
* $Log: drawform.c,v $
* Revision 1.1  1996/12/10  18:40:31  jrh
* Initial revision
*
*
*/
#include<X11/Intrinsic.h>
#include<Xm/Xm.h>
#include<Xm/BulletinB.h>
#include<Xm/DialogS.h>
#include<Xm/Form.h>
#include<Xm/Label.h>
#include<Xm/LabelG.h>
#include<Xm/MwmUtil.h>
#include<Xm/PanedW.h>
#include<Xm/PushB.h>
#include<Xm/PushBG.h>
#include<Xm/RowColumn.h>
#include<Xm/Scale.h>
#include<Xm/Separator.h>
#include<Xm/Text.h>
#include<Xm/ToggleB.h>
#include<math.h>
#include<GL/glu.h>
#ifdef __osf__
#include<X11/GLw/GLwMDrawA.h>
#else
#include<GL/GLwMDrawA.h>
#endif
#include "viewmol.h"
#include "dialog.h"

extern void GetSlider(Widget, struct SLIDER *, XmScrollBarCallbackStruct *);
extern void MapBox(Widget, caddr_t, caddr_t);
extern Widget CreateToggleBox(Widget, struct PushButtonRow *, int, int,
                              int, int, int);
extern Widget CreatePushButtonRow(Widget, struct PushButtonRow *, int);
extern void redraw(int);
extern void changeBoolean(Widget, int *, GLwDrawingAreaCallbackStruct *);
extern void drawMolecule(Widget, caddr_t, GLwDrawingAreaCallbackStruct *);

void drawingModeDialogExit(Widget, caddr_t, XmPushButtonCallbackStruct *);
void switchLight(Widget, caddr_t, XmToggleButtonCallbackStruct *);
void moveLight(Widget, caddr_t, XmToggleButtonCallbackStruct *);
void setDrawingMode(Widget, caddr_t, XmToggleButtonCallbackStruct *);

extern struct WINDOW windows[];
extern Widget topShell;
extern int primitive, lights, movelight, simplify;
extern double sphereres;
extern float xrot, yrot, zrot;

static Widget dialog, simpleRot;
static int primitive_save, lights_save, movelight_save;
static double sphereres_save;

void drawingModeDialog(Widget widget, caddr_t dummy, XmAnyCallbackStruct *data)
{
  Widget board, form, label, slider;
  Widget radiobox, checkbox, sep1, sep2, sep3, sep4;
  Arg args[3];
  static struct PushButtonRow buttons[] = {
    { "ok", drawingModeDialogExit, (XtPointer)TRUE, NULL },
    { "cancel", drawingModeDialogExit, (XtPointer)FALSE, NULL },
  };
  static struct PushButtonRow radiobox_buttons1[] = {
    { "dots", setDrawingMode, (XtPointer)GLU_POINT, NULL },
    { "lines", setDrawingMode, (XtPointer)GLU_LINE, NULL },
    { "surfaces", setDrawingMode, (XtPointer)GLU_FILL, NULL },
  };
  static struct PushButtonRow checkbox_buttons[] = {
    { "light0", switchLight, (XtPointer)0, NULL },
    { "light1", switchLight, (XtPointer)1, NULL },
  };
  static struct PushButtonRow radiobox_buttons2[] = {
    { "nomove", moveLight, (XtPointer)0, NULL },
    { "light0", moveLight, (XtPointer)1, NULL },
    { "light1", moveLight, (XtPointer)2, NULL },
  };
  static struct SLIDER spheregrid;

  primitive_save=primitive;
  lights_save=lights;
  movelight_save=movelight;
  sphereres_save=sphereres;
  spheregrid.number=&sphereres;
  spheregrid.decimals=0;
  spheregrid.draw=(void *)drawMolecule;

  XtSetArg(args[0], XmNautoUnmanage, False);
  XtSetArg(args[1], XmNdefaultPosition, False);
  if (XmIsMotifWMRunning(topShell))
    XtSetArg(args[2], XmNmwmDecorations, MWM_DECOR_RESIZEH | MWM_DECOR_TITLE);
  else
    XtSetArg(args[2], (char *)NULL, 0);
  dialog=XmCreateDialogShell(XtParent(windows[VIEWER].widget),
				     "drawingModeForm_popup", args, XtNumber(args));
  board=XtVaCreateWidget("drawingModeForm", xmBulletinBoardWidgetClass, dialog,
                         XmNautoUnmanage, False,
                         XmNdefaultPosition, False,
                         NULL);
  form=XtVaCreateWidget("rowcolumn", xmRowColumnWidgetClass, board,
                        XmNorientation, XmVERTICAL,
                        NULL);

  radiobox=CreateToggleBox(form, radiobox_buttons1, XtNumber(radiobox_buttons1),
                            XmVERTICAL, 1, True, primitive-GLU_POINT);
  XtVaSetValues(radiobox, XmNleftAttachment, XmATTACH_FORM,
                          XmNrightAttachment, XmATTACH_FORM,
                          XmNtopAttachment, XmATTACH_FORM,
                          NULL);
  simpleRot=XtVaCreateManagedWidget("simplify", xmToggleButtonWidgetClass, form,
                                    NULL);
  if (simplify) XtVaSetValues(simpleRot, XmNset, True, NULL);
  if (primitive != GLU_FILL) XtVaSetValues(simpleRot, XmNsensitive, False, NULL);
  XtAddCallback(simpleRot, XmNvalueChangedCallback, (XtCallbackProc)changeBoolean, &simplify);

  sep1=XtVaCreateManagedWidget("sep1", xmSeparatorWidgetClass, form,
                              XmNtraversalOn, False,
                              XmNleftAttachment, XmATTACH_FORM,
                              XmNrightAttachment, XmATTACH_FORM,
                              XmNtopAttachment, XmATTACH_WIDGET,
                              XmNtopWidget, radiobox,
                              NULL);

  label=XtVaCreateManagedWidget("onOffLabel", xmLabelWidgetClass, form,
                                XmNleftAttachment, XmATTACH_FORM,
                                XmNrightAttachment, XmATTACH_FORM,
                                XmNtopAttachment, XmATTACH_WIDGET,
                                XmNtopWidget, sep1,
                                NULL);
  checkbox=CreateToggleBox(form, checkbox_buttons, XtNumber(checkbox_buttons),
                           XmVERTICAL, 1, False, 0);
  if (lights & 0x1) XtVaSetValues(checkbox_buttons[0].widget, XmNset, True, NULL);
  if (lights & 0x2) XtVaSetValues(checkbox_buttons[1].widget, XmNset, True, NULL);

  sep2=XtVaCreateManagedWidget("sep2", xmSeparatorWidgetClass, form,
                              XmNtraversalOn, False,
                              XmNleftAttachment, XmATTACH_FORM,
                              XmNrightAttachment, XmATTACH_FORM,
                              XmNtopAttachment, XmATTACH_WIDGET,
                              XmNtopWidget, checkbox,
                              NULL);

  label=XtVaCreateManagedWidget("moveLabel", xmLabelWidgetClass, form,
                                XmNleftAttachment, XmATTACH_FORM,
                                XmNrightAttachment, XmATTACH_FORM,
                                XmNtopAttachment, XmATTACH_WIDGET,
                                XmNtopWidget, sep2,
                                NULL);
  radiobox=CreateToggleBox(form, radiobox_buttons2, XtNumber(radiobox_buttons2),
                           XmVERTICAL, 1, True, movelight+1);

  sep3=XtVaCreateManagedWidget("sep3", xmSeparatorWidgetClass, form,
                              XmNtraversalOn, False,
                              XmNleftAttachment, XmATTACH_FORM,
                              XmNrightAttachment, XmATTACH_FORM,
                              XmNtopAttachment, XmATTACH_WIDGET,
                              XmNtopWidget, radiobox,
                              NULL);

  label=XtVaCreateManagedWidget("sphereResolutionLabel", xmLabelWidgetClass, form,
                                XmNleftAttachment, XmATTACH_FORM,
                                XmNrightAttachment, XmATTACH_FORM,
                                XmNtopAttachment, XmATTACH_WIDGET,
                                XmNtopWidget, sep3,
                                NULL);
  slider=XtVaCreateManagedWidget("sphereResolution", xmScaleWidgetClass, form,
                                  XmNorientation, XmHORIZONTAL,
                                  XmNvalue, (int)sphereres,
                                  XmNminimum, 4,
                                  XmNmaximum, sphereres > 30. ? (int)sphereres : 30,
                                  XmNdecimalPoints, 0,
                                  XmNshowValue, True,
                                  XmNsensitive, True,
                                  XmNleftAttachment, XmATTACH_FORM,
                                  XmNrightAttachment, XmATTACH_FORM,
                                  XmNtopAttachment, XmATTACH_WIDGET,
                                  XmNtopWidget, label,
                                  NULL);
  XtAddCallback(slider, XmNvalueChangedCallback, (XtCallbackProc)GetSlider, &spheregrid);

  sep4=XtVaCreateManagedWidget("sep4", xmSeparatorWidgetClass, form,
                              XmNtraversalOn, False,
                              XmNleftAttachment, XmATTACH_FORM,
                              XmNrightAttachment, XmATTACH_FORM,
                              XmNtopAttachment, XmATTACH_WIDGET,
                              XmNtopWidget, slider,
                              NULL);

  CreatePushButtonRow(form, buttons, XtNumber(buttons));
  XtAddCallback(dialog, XmNpopupCallback, (XtCallbackProc)MapBox, (XtPointer)NULL);

  XtManageChild(form);
  XtManageChild(board);
}

void drawingModeDialogExit(Widget widget, caddr_t which, XmPushButtonCallbackStruct *data)
{
  XtDestroyWidget(dialog);
  if (!(int)which)
  {
    primitive=primitive_save;
    lights=lights_save;
    movelight=movelight_save;
    sphereres=sphereres_save;
  }
  redraw(VIEWER);
}

void setDrawingMode(Widget w, caddr_t mode, XmToggleButtonCallbackStruct *data)
{
  if (data->set)
  {
    primitive=(int)mode;
    if (primitive == GLU_FILL) XtVaSetValues(simpleRot, XmNsensitive, True, NULL);
    else                       XtVaSetValues(simpleRot, XmNsensitive, False, NULL);
    redraw(VIEWER);
  }
}

void switchLight(Widget widget, caddr_t which, XmToggleButtonCallbackStruct *data)
{
  register int i;

  i=1 << (int)which;
  if (data->set)
    lights|=i;
  else
    lights&=~i;
  redraw(VIEWER);
}

void moveLight(Widget widget, caddr_t which, XmToggleButtonCallbackStruct *data)
{
  static float xrotSave, yrotSave, zrotSave;

  if (data->set)
  {
    movelight=(int)which-1;
    if (movelight != (-1))
    {
      xrotSave=xrot;
      yrotSave=yrot;
      zrotSave=zrot;
    }
    else
    {
      xrot=xrotSave;
      yrot=yrotSave;
      zrot=zrotSave;
    }
    redraw(VIEWER);
  }
}
