/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                               D R A W O P . C                                *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1996                   *
*                                                                              *
********************************************************************************
*
* $Id: drawop.c,v 1.1 1996/12/10 18:40:36 jrh Exp $
* $Log: drawop.c,v $
* Revision 1.1  1996/12/10  18:40:36  jrh
* Initial revision
*
*
*/
#include<math.h>
#include<stdio.h>
#include<string.h>
#include<X11/Intrinsic.h>
#include<X11/StringDefs.h>
#include<X11/keysym.h>
#include<Xm/Xm.h>
#include<GL/gl.h>
#include<GL/glu.h>
#ifdef __osf__
#include<X11/GLw/GLwMDrawA.h>
#else
#include<GL/GLwMDrawA.h>
#endif
#include "viewmol.h"

void cross(double, double, double, double);

extern double makeTics(double, double, double *, char *);
extern void pixwor(Dimension, Dimension, GLdouble, GLdouble, GLdouble, GLdouble, double *, double *);
extern void drawBackground(int, Pixel, double);
extern void setWindowColor(int, Pixel, const float *);
extern int StringWidth(XFontStruct *, char *);
extern void (*drawBegin)(GLenum), (*drawEnd)(void), (*drawVertex2d)(double, double);
extern void (*drawString)(char *, double, double, double, GLuint);
extern void (*drawLineWidth)(GLfloat);
extern void printDialog(Widget, caddr_t, XmAnyCallbackStruct *);
extern char *getStringResource(Widget, char*);
extern void restoreGeometry(void);
extern void drawMolecule(Widget, caddr_t, GLwDrawingAreaCallbackStruct *);
extern void setMenuItem(int, int, int);
extern void setGeometry(int);
extern void fremem(void **);

extern struct WINDOW windows[];
extern struct OPTIMIZATION *optimization;
extern struct ATOM *atoms;
extern Widget topShell;
extern Pixel stdcol[9], historyColor;
extern double emax, emin, cycle;
extern double *coord;
extern float historyColor_rgb[4];
extern int na, nhist;
extern int swapBuffers;

void drawHistory(Widget w, caddr_t client_data, GLwDrawingAreaCallbackStruct *data)
{
  Dimension width, height;
  char line[18], form[8], *word;
  double left, right, bottom, top;
  double g, e, xpix, ypix, xpixold, ticMark, ticInc, strl;
  const float black[4] = {0.0, 0.0, 0.0, 0.0};
  register int i;

/* This subroutine draws the diagram for optimization history */

  GLwDrawingAreaMakeCurrent(windows[HISTORY].widget, windows[HISTORY].context);

  XtVaGetValues(windows[HISTORY].widget, XtNwidth, &width, XtNheight, &height, NULL);
  e=emax-emin > 0.00001e0 ? emax-emin : 0.00001e0;
  g=windows[HISTORY].top;
  left=windows[HISTORY].left;
  right=windows[HISTORY].right;
  bottom=windows[HISTORY].bottom;
  top=windows[HISTORY].top;
  xpixold=0.0e0;
  xpix=1.0e0;
  while (fabs(xpixold-xpix) > 1.0e-4)
  {
    xpixold=xpix;
    pixwor(width, height, left, right, bottom, top, &xpix, &ypix);
    left=windows[HISTORY].left-10.0e0*xpix;
    right=windows[HISTORY].right+10.0e0*xpix;
    bottom=windows[HISTORY].bottom-10.0e0*ypix;
    top=windows[HISTORY].top+10.0e0*ypix;
  }

  drawBackground(HISTORY, windows[HISTORY].background, 0.0e0);
  setWindowColor(FOREGROUND, stdcol[BLACK], black);
  glLoadIdentity();
  glOrtho(left, right, bottom, top, windows[HISTORY].near, windows[HISTORY].far);
  glShadeModel(GL_FLAT);

/* Draw tic marks */

  if (windows[HISTORY].mode & SCALES)
  {
    (*drawLineWidth)((GLfloat)1.);
    ticInc=makeTics(1.e0, (double)nhist, &ticMark, form);
    if (ticInc < 1.0e0) ticInc=1.0e0;
    if (ticMark == 1.0e0) ticMark+=ticInc;
    do
    {
      (*drawBegin)(GL_LINES);
      (*drawVertex2d)(ticMark, g);
      (*drawVertex2d)(ticMark, g+5.e0*ypix);
      (*drawEnd)();
      (*drawBegin)(GL_LINES);
      (*drawVertex2d)(ticMark, 0.0e0);
      (*drawVertex2d)(ticMark, -5.e0*ypix);
      (*drawEnd)();
      sprintf(line, "%d", (int)ticMark);
      strl=(double)StringWidth(windows[HISTORY].font, line)/2.e0*xpix;
      (*drawString)(line, ticMark-strl, g-15.e0*ypix, 0.0, windows[HISTORY].GLfontId);
      ticMark+=ticInc;
    } while (ticMark < (double)nhist);

    if (windows[HISTORY].mode & GNORM)
    {
	ticInc=makeTics(0.0e0, g, &ticMark, form);
	ticMark+=ticInc;
      do
      {
        (*drawBegin)(GL_LINES);
        (*drawVertex2d)((double)nhist, ticMark);
        (*drawVertex2d)((double)nhist+5.e0*xpix, ticMark);
	  (*drawEnd)();
        sprintf(line, form, ticMark);
        strl=(double)(StringWidth(windows[HISTORY].font, line)+4)*xpix;
        setWindowColor(FOREGROUND, historyColor, historyColor_rgb);
        (*drawString)(line, (double)nhist-strl, ticMark-5.e0*ypix, 0.0, windows[HISTORY].GLfontId);
        setWindowColor(FOREGROUND, stdcol[BLACK], black);
        ticMark+=ticInc;
      } while (ticMark < g);
    }
    if (windows[HISTORY].mode & ENERGY)
    {
	ticInc=makeTics(emin, e+emin, &ticMark, form);
      do
      {
        (*drawBegin)(GL_LINES);
        (*drawVertex2d)(1.e0-5.e0*xpix, (ticMark-emin)*g/e);
        (*drawVertex2d)(1.e0, (ticMark-emin)*g/e);
	  (*drawEnd)();
        sprintf(line, form, ticMark);
        setWindowColor(FOREGROUND, windows[HISTORY].foreground, windows[HISTORY].foreground_rgb);
        (*drawString)(line, 1.e0+3.e0*xpix, (ticMark-emin)*g/e-5.e0*ypix, 0.0, windows[HISTORY].GLfontId);
        setWindowColor(FOREGROUND, stdcol[BLACK], black);
        ticMark+=ticInc;
      } while (ticMark < e+emin);
    }
  }

/* Draw diagram frame and labels */

  (*drawLineWidth)((GLfloat)3.);
  (*drawBegin)(GL_LINE_LOOP);
  (*drawVertex2d)(1.e0, 0.0e0);
  (*drawVertex2d)(1.e0, g);
  (*drawVertex2d)((double)nhist, g);
  (*drawVertex2d)((double)nhist, 0.0e0);
  (*drawEnd)();
  if (windows[HISTORY].mode & GNORM)
  {
    setWindowColor(FOREGROUND, historyColor, historyColor_rgb);
    (*drawBegin)(GL_LINES);
    (*drawVertex2d)((double)nhist-150.e0*xpix, g-40.e0*ypix);
    (*drawVertex2d)((double)nhist-130.e0*xpix, g-40.e0*ypix);
    (*drawEnd)();
    setWindowColor(FOREGROUND, stdcol[BLACK], black);
    word=getStringResource(topShell, "gradientNorm");
    (*drawString)(word, (double)nhist-120.e0*xpix, g-40.e0*ypix, 0.0, windows[HISTORY].GLfontId);
  }
  if (windows[HISTORY].mode & ENERGY)
  {
    setWindowColor(FOREGROUND, windows[HISTORY].foreground, windows[HISTORY].foreground_rgb);
    (*drawBegin)(GL_LINES);
    (*drawVertex2d)((double)nhist-150.e0*xpix, g-60.e0*ypix);
    (*drawVertex2d)((double)nhist-130.e0*xpix, g-60.e0*ypix);
    (*drawEnd)();
    setWindowColor(FOREGROUND, stdcol[BLACK], black);
    word=getStringResource(topShell, "energy");
    (*drawString)(word, (double)nhist-120.e0*xpix, g-60.e0*ypix, 0.0, windows[HISTORY].GLfontId);
  }

/* Draw gradient norm curve */

  if (windows[HISTORY].mode & GNORM)
  {
    setWindowColor(FOREGROUND, historyColor, historyColor_rgb);
    (*drawBegin)(GL_LINE_STRIP);
    for (i=0; i<nhist; i++)
      (*drawVertex2d)((double)(i+1), optimization[i].gnorm);
    (*drawEnd)();
  }

/* Draw energy curve */

  if (windows[HISTORY].mode & ENERGY)
  {
    setWindowColor(FOREGROUND, windows[HISTORY].foreground, windows[HISTORY].foreground_rgb);
    (*drawBegin)(GL_LINE_STRIP);
    for (i=0; i<nhist; i++)
      (*drawVertex2d)((double)(i+1), (optimization[i].energy-emin)*g/e);
    (*drawEnd)();
  }
  cross(cycle, e, xpix, ypix);
  if (swapBuffers) GLwDrawingAreaSwapBuffers(windows[HISTORY].widget);
}

void cross(double cycle, double e, double xpix, double ypix)
{
  const float red[4] = {1.0, 0.0, 0.0, 0.0};
  register double a=0.0, b=0.0;
  register int c1, c2;

/* Draw a red cross at position (cycle, optimization[cycle].energy)
   if the energy curve is shown, else draw cross at position
   (cycle, optimization[cycle].gnorm) */

  c1=(int)floor(cycle);
  c2=(int)ceil(cycle);
  setWindowColor(FOREGROUND, stdcol[RED], red);
  if (windows[HISTORY].mode & ENERGY)
  {
    a=optimization[c1-1].energy-optimization[c2-1].energy;
    b=optimization[c1-1].energy-emin+a*((double)c1-cycle);
  }
  else if (windows[HISTORY].mode & GNORM)
  {
    a=optimization[c1-1].gnorm-optimization[c2-1].gnorm;
    b=optimization[c1-1].gnorm+a*((double)c1-cycle);
    e=windows[HISTORY].top;
  }
  xpix*=10.e0;
  ypix*=10.e0;
  (*drawBegin)(GL_LINES);
  (*drawVertex2d)(cycle, b*windows[HISTORY].top/e-ypix);
  (*drawVertex2d)(cycle, b*windows[HISTORY].top/e+ypix);
  (*drawEnd)();
  (*drawBegin)(GL_LINES);
  (*drawVertex2d)(cycle-xpix, b*windows[HISTORY].top/e);
  (*drawVertex2d)(cycle+xpix, b*windows[HISTORY].top/e);
  (*drawEnd)();
}

void quitHistory(Widget w, caddr_t client_data, XmAnyCallbackStruct *data)
{
  GLwDrawingAreaMakeCurrent(windows[VIEWER].widget, windows[VIEWER].context);
  fremem((void **)&windows[HISTORY].font);
  XtDestroyWidget(XtParent(XtParent(windows[HISTORY].widget)));
  windows[HISTORY].widget=0;
  restoreGeometry();
  drawMolecule((Widget)0, (caddr_t)0, (GLwDrawingAreaCallbackStruct *)0);
  setMenuItem(VIEWER, 8, True);
}

void historyKeyAction(KeySym keysym)
{
  switch (keysym)
  {
    case XK_Print: printDialog((Widget)0, (caddr_t)HISTORY, (XmAnyCallbackStruct *)0);
			 break;
    case XK_Left:  if (--cycle < 1) cycle=nhist;
		       break;
    case XK_Right: if (++cycle > nhist) cycle=1;
			 break;
  }
  setGeometry(TRUE);
}
