/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                               D R A W S P . C                                *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1996                   *
*                                                                              *
********************************************************************************
*
* $Id: drawsp.c,v 1.1 1996/12/10 18:40:41 jrh Exp $
* $Log: drawsp.c,v $
* Revision 1.1  1996/12/10  18:40:41  jrh
* Initial revision
*
*
*/
#include<math.h>
#include<stdio.h>
#include<X11/Xlib.h>
#include<X11/Intrinsic.h>
#include<X11/StringDefs.h>
#include<X11/keysym.h>
#include<Xm/Xm.h>
#ifdef __osf__
#include<X11/GLw/GLwMDrawA.h>
#else
#include<GL/GLwMDrawA.h>
#endif
#include "viewmol.h"

#define min(a, b) (a) < (b) ? (a) : (b)
#define max(a, b) (a) > (b) ? (a) : (b)

void setWindowColor(int, Pixel, const float *);
void paper(Dimension, Dimension);
void pixwor(Dimension, Dimension, GLdouble, GLdouble, GLdouble, GLdouble,
		double *, double *);

extern int StringWidth(XFontStruct *, char *);
extern int StringHeight(XFontStruct *);
extern void (*drawColor4fv)(const GLfloat *);
extern void (*drawBegin)(GLenum), (*drawEnd)(void), (*drawVertex2d)(double, double);
extern void (*drawString)(char *, double, double, double, GLuint);
extern void (*drawLineStipple)(GLint, GLushort), (*drawDisable)(GLenum);
extern void (*drawLineWidth)(GLfloat);
extern void (*drawClearColor)(GLclampf, GLclampf, GLclampf, GLclampf);
extern void printDialog(Widget, caddr_t, XmAnyCallbackStruct *);
extern char *getStringResource(Widget, char *);
extern void *getmem(size_t, size_t);
extern void fremem(void **);
extern void drawBackground(int, Pixel, float);
extern void setAnimation(int);
extern void restoreGeometry(void);
extern void drawMolecule(Widget, caddr_t, GLwDrawingAreaCallbackStruct *);
extern void setMenuItem(int, int, int);
extern void distortGeometry(double);

extern struct NORMAL_MODE *normal_modes;
extern struct WINDOW windows[];
extern struct ATOM *atoms;
extern Widget topShell;
extern int lines, mode;
extern int na, nmodes, animate;
extern double temp, wnScale, amplitude;
extern double *coord;
extern int rgbMode, picking, swapBuffers;
extern Pixel stdcol[9];

void drawSpectrum(Widget w, caddr_t client_data, GLwDrawingAreaCallbackStruct *data)
{
  const double h=6.626176e-34, c=2.99792458e10, kb=1.380662e-23;
  const float red[4] = {1.0, 0.0, 0.0, 0.0};
  Dimension width, height;
  double *scan, *s;
  double f, zz, wmax, frq, frqinc, shape, intdiff;
  register int i, j;

  f=-h*c/(kb*temp);
/*a=512.0e0*(atan(1.0e0))**3*6.022045e23/(h*c*3000.0e0*log(10.0e0)); */

  if (!picking)
  {
    GLwDrawingAreaMakeCurrent(windows[SPECTRUM].widget, windows[SPECTRUM].context);
    glLoadIdentity();
  }
  glShadeModel(GL_FLAT);
  glOrtho(windows[SPECTRUM].left, windows[SPECTRUM].right,
          windows[SPECTRUM].bottom, windows[SPECTRUM].top,
          windows[SPECTRUM].near, windows[SPECTRUM].far);
  XtVaGetValues(windows[SPECTRUM].widget, XtNwidth, &width, XtNheight, &height, NULL);
  paper(width, height);

/* Draw line spectrum */

  if (lines)
  {
/* Loop over wave numbers   */

    for (i=0; i<nmodes; i++)
    {
      if (normal_modes[i].wavenumber > windows[SPECTRUM].left &&
	    normal_modes[i].wavenumber < windows[SPECTRUM].right)
      {
        if (i == mode) continue;
        glLoadName(i+1);
	  frq=wnScale*normal_modes[i].wavenumber;
        (*drawBegin)(GL_LINES);
        (*drawVertex2d)(frq, max(0.0, windows[SPECTRUM].top));
        if (windows[SPECTRUM].mode == SPECTRUM_ALL)
          (*drawVertex2d)(frq, min(100.e0, windows[SPECTRUM].bottom));
        if (windows[SPECTRUM].mode == SPECTRUM_IR && normal_modes[i].rel_ir_intensity != 0.0e0)
          (*drawVertex2d)(frq, min(normal_modes[i].rel_ir_intensity, windows[SPECTRUM].bottom));
        if (windows[SPECTRUM].mode == SPECTRUM_RAMAN && normal_modes[i].rel_raman_intensity != 0.0e0)
          (*drawVertex2d)(frq, min(normal_modes[i].rel_raman_intensity, windows[SPECTRUM].bottom));
        if (windows[SPECTRUM].mode == SPECTRUM_INS)
          (*drawVertex2d)(frq, min(normal_modes[i].rel_ins_intensity, windows[SPECTRUM].bottom));
        (*drawEnd)();
      }
    }

/* Plot the selected wave number in red */

    if (mode > (-1) && mode <= nmodes)
    {
      setWindowColor(FOREGROUND, stdcol[RED], red);
      glLoadName(mode+1);
	frq=wnScale*normal_modes[mode].wavenumber;
      (*drawBegin)(GL_LINES);
      (*drawVertex2d)(frq, max(0.0, windows[SPECTRUM].top));
      if (windows[SPECTRUM].mode == SPECTRUM_ALL)
        (*drawVertex2d)(frq, min(100.e0, windows[SPECTRUM].bottom));
      if (windows[SPECTRUM].mode == SPECTRUM_IR && normal_modes[mode].rel_ir_intensity != 0.0e0)
        (*drawVertex2d)(frq, min(normal_modes[mode].rel_ir_intensity, windows[SPECTRUM].bottom));
      if (windows[SPECTRUM].mode == SPECTRUM_RAMAN && normal_modes[mode].rel_raman_intensity != 0.0e0)
        (*drawVertex2d)(frq, min(normal_modes[mode].rel_raman_intensity, windows[SPECTRUM].bottom));
      if (windows[SPECTRUM].mode == SPECTRUM_INS)
        (*drawVertex2d)(frq, min(normal_modes[mode].rel_ins_intensity, windows[SPECTRUM].bottom));
      (*drawEnd)();
    }
  }
  else
  {
/* Draw spectrum with gaussian functions */

   s=(double *)getmem(nmodes, sizeof(double));
   scan=(double *)getmem((size_t)width, sizeof(double));
   for (i=0; i<nmodes; i++)
   {
     if (normal_modes[i].ir_intensity > 0.0 && normal_modes[i].wavenumber > 0.0)
     {
       zz=1.0e0-exp(f*wnScale*normal_modes[i].wavenumber);
       s[i]=0.5*normal_modes[i].rel_ir_intensity*wnScale*normal_modes[i].wavenumber/zz;
     }
   }
/* Scan spectrum */

   frq=windows[SPECTRUM].left;
   frqinc=(windows[SPECTRUM].right-windows[SPECTRUM].left)/(double)width;
   for (i=0; i<width; i++)
   {
     scan[i]=0.0e0;
     for (j=0; j<nmodes; j++)
     {
       if (normal_modes[j].ir_intensity > 0.0 && normal_modes[j].wavenumber > 0.0)
       {
         shape=frq-wnScale*normal_modes[j].wavenumber;
         shape=exp(-32.e0*shape*shape/(wnScale*normal_modes[j].wavenumber));
         scan[i]+=s[j]*shape;
       }
     }
/*   scan[i]*=a; */
     frq+=frqinc;
   }

/* Scale intensities  */

    wmax=scan[0];
    for (j=1; j<i; j++)
      wmax=max(wmax, scan[j]);
    for (j=0; j<i; j++)
      scan[j]*=100.0e0/wmax;

    (*drawBegin)(GL_LINE_STRIP);
    (*drawVertex2d)(max(0.0, windows[SPECTRUM].left), max(0.0, windows[SPECTRUM].top));

/* And draw it */

    frq=windows[SPECTRUM].left;
    for (j=0; j<i; j++)
    {
	if (scan[j] > windows[SPECTRUM].bottom)
	{
	  if (scan[j-1] < windows[SPECTRUM].bottom)
	  {
	    intdiff=(scan[j-1]-scan[j])/frqinc;
	    zz=scan[j]-intdiff*frq;
	    intdiff=(windows[SPECTRUM].bottom-zz)/intdiff;
	    (*drawVertex2d)(intdiff, windows[SPECTRUM].bottom);
	    (*drawEnd)();
	  }
	}
	else
      {
	  if (scan[j-1] > windows[SPECTRUM].bottom)
	  {
	    intdiff=(scan[j-1]-scan[j])/frqinc;
	    zz=scan[j]-intdiff*frq;
	    intdiff=(windows[SPECTRUM].bottom-zz)/intdiff;
	    (*drawBegin)(GL_LINE_STRIP);
	    (*drawVertex2d)(intdiff, windows[SPECTRUM].bottom);
	  }
	  else
          (*drawVertex2d)(frq, scan[j]);
	}
      frq+=frqinc;
    }
    (*drawEnd)();
    fremem((void **)&s);
    fremem((void **)&scan);
  }
  if (swapBuffers) GLwDrawingAreaSwapBuffers(windows[SPECTRUM].widget);
}

void paper(Dimension width, Dimension height)
{
  double grid;
  double xpix, ypix;
  int swidth1, swidth2, sheight; 
  char line[6], *word;
  register int i;

  drawBackground(SPECTRUM, windows[SPECTRUM].background, 0.0e0);
  setWindowColor(FOREGROUND, windows[SPECTRUM].foreground, windows[SPECTRUM].foreground_rgb);

  pixwor(width, height, windows[SPECTRUM].left, windows[SPECTRUM].right,
         windows[SPECTRUM].bottom, windows[SPECTRUM].top, &xpix, &ypix);
  glEnable(GL_LINE_STIPPLE);                             /* Dashed lines */
  (*drawLineStipple)(1, 0xf0f0);
  (*drawLineWidth)((GLfloat)1.);

  word=getStringResource(topShell, "wavenumber");
  swidth1=StringWidth(windows[SPECTRUM].font, word)+2;   /* Write labels */
  sheight=StringHeight(windows[SPECTRUM].font)+2;
  (*drawString)(word, windows[SPECTRUM].right-(double)swidth1*xpix,
		   windows[SPECTRUM].top-(double)sheight*ypix, 0.0,
		   windows[SPECTRUM].GLfontId);
  word=getStringResource(topShell, "intensity");
  (*drawString)(word, windows[SPECTRUM].left+3.0e0*xpix, windows[SPECTRUM].bottom+3.0e0*ypix, 0.0, windows[SPECTRUM].GLfontId);

  grid=0.0e0;                                            /* Draw grid */
  for (i=0; i<10; i++)
  {
    if (grid > windows[SPECTRUM].left && grid < windows[SPECTRUM].right)
    {
      (*drawBegin)(GL_LINES);
      if (grid < windows[SPECTRUM].right-(double)swidth1*xpix)
        (*drawVertex2d)(grid, windows[SPECTRUM].top);
      else
        (*drawVertex2d)(grid, max(windows[SPECTRUM].top, 0.0));
      (*drawVertex2d)(grid, min(windows[SPECTRUM].bottom, 100.));
      (*drawEnd)();
      if (grid < windows[SPECTRUM].right-(double)swidth1*xpix && grid > 0.0)
      {
        sprintf(line, "%5d", (int)grid);
        swidth2=StringWidth(windows[SPECTRUM].font, line)+2;
        (*drawString)(line, grid-(double)swidth2*xpix, windows[SPECTRUM].top-(double)sheight*ypix, 0.0, windows[SPECTRUM].GLfontId);
      }
    }
    grid+=500.e0;
  }
  grid=0.0e0;
  for (i=0; i<5; i++)
  {
    if (grid > windows[SPECTRUM].top && grid < windows[SPECTRUM].bottom)
    {
      (*drawBegin)(GL_LINES);
      (*drawVertex2d)(windows[SPECTRUM].left, grid);
      (*drawVertex2d)(windows[SPECTRUM].right, grid);
      (*drawEnd)();
      sprintf(line, "%d", (int)grid);
      (*drawString)(line, windows[SPECTRUM].left+3.0e0*xpix, grid+3.0e0*ypix, 0.0, windows[SPECTRUM].GLfontId);
    }
    grid+=25.e0;
  }
  (*drawDisable)(GL_LINE_STIPPLE);
}

void setWindowColor(int where, Pixel color, const float *rgbColor)
{
  if (rgbMode)
  {
    switch (where)
    {
      case FOREGROUND: (*drawColor4fv)(rgbColor);
                       break;
      case BACKGROUND: (*drawClearColor)(rgbColor[0], rgbColor[1],
						     rgbColor[2], rgbColor[3]);
                       break;
    }
  }
  else
  {
    switch (where)
    {
      case FOREGROUND: glIndexi(color);
                       break;
      case BACKGROUND: glClearIndex(color);
                       break;
    }
  }
}

Pixel getPixel(int color)
{
  return(stdcol[color]);
}

void pixwor(Dimension width, Dimension height, GLdouble x1, GLdouble x2,
            GLdouble y1, GLdouble y2, double *xpix, double *ypix)
{
  *xpix=(x2-x1)/(double)width;
  *ypix=(y2-y1)/(double)height;
}

void quitSpectrum(Widget w, caddr_t client_data, XmAnyCallbackStruct *data)
{
  GLwDrawingAreaMakeCurrent(windows[VIEWER].widget, windows[VIEWER].context);
  fremem((void **)&windows[SPECTRUM].font);
  XtDestroyWidget(XtParent(XtParent(windows[SPECTRUM].widget)));
  windows[SPECTRUM].widget=NULL;
  mode=(-1);
  if (animate) setAnimation(FALSE);
  restoreGeometry();
  drawMolecule((Widget)0, (caddr_t)0, (GLwDrawingAreaCallbackStruct *)0);
  setMenuItem(VIEWER, 10, True);
}

void spectrumKeyAction(KeySym keysym)
{
  switch (keysym)
  {
    case XK_Print:  printDialog((Widget)0, (caddr_t)SPECTRUM, (XmAnyCallbackStruct *)0);
			  break;
    case XK_Left:   while (TRUE)
                    {
			    mode--;
                      if (mode < 0) mode=nmodes-1;
                      if (windows[SPECTRUM].mode == SPECTRUM_IR && normal_modes[mode].ir_intensity != 0.0e0) break;
                      if (windows[SPECTRUM].mode == SPECTRUM_RAMAN && normal_modes[mode].raman_intensity != 0.0e0) break;
                      if (windows[SPECTRUM].mode == SPECTRUM_INS && normal_modes[mode].ins_intensity != 0.0e0) break;
                      if (windows[SPECTRUM].mode == SPECTRUM_ALL && normal_modes[mode].wavenumber != 0.0e0) break;
                    }
                    break;
    case XK_Right:  while (TRUE)
                    {
			    mode++;
                      if (mode >= nmodes) mode=0;
                      if (windows[SPECTRUM].mode == SPECTRUM_IR && normal_modes[mode].ir_intensity != 0.0e0) break;
                      if (windows[SPECTRUM].mode == SPECTRUM_RAMAN && normal_modes[mode].raman_intensity != 0.0e0) break;
                      if (windows[SPECTRUM].mode == SPECTRUM_INS && normal_modes[mode].ins_intensity != 0.0e0) break;
                      if (windows[SPECTRUM].mode == SPECTRUM_ALL && normal_modes[mode].wavenumber != 0.0e0) break;
                    }
                    break;
  }
  restoreGeometry();
  if (animate == DISTORT) distortGeometry(amplitude);
}
