/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                             H A R D C O P Y . C                              *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1996                   *
*                                                                              *
********************************************************************************
*
* $Id: hardcopy.c,v 1.1 1996/12/10 18:41:06 jrh Exp $
* $Log: hardcopy.c,v $
* Revision 1.1  1996/12/10  18:41:06  jrh
* Initial revision
*
*
*/
#include<pwd.h>
#include<stdio.h>
#include<stdlib.h>
#include<unistd.h>
#include<sys/types.h>
#include<X11/Xlib.h>
#include<X11/Intrinsic.h>
#include<X11/StringDefs.h>
#include<Xm/Xm.h>
#ifdef __osf__
#include<X11/GLw/GLwMDrawA.h>
#else
#include<GL/GLwMDrawA.h>
#endif
#include "tiffio.h"
#include "viewmol.h"
#include "dialog.h"

char *saveTiff(int, char *, int);
char *saveVectorFile(int, char *, int);
void writeTiff(TIFF *, unsigned char *, int, int, XColor *);

extern void GetMessageBoxButton(Widget, XtPointer, caddr_t);
extern char *getStringResource(Widget, char *);
extern char *selectFile(char *, char *);
extern FILE *hpglInit(char *, double, double, double, double, double, double,
                      Dimension, int);
extern FILE *PostscriptInit(char *, double, double, double, double, double,
				    double, int);
extern void PostscriptClose(void);
extern FILE *raytraceInit(char *, Dimension, Dimension);
extern void raytraceClose(void);
extern void setDrawingDevice(int);
extern void *getmem(size_t, size_t);
extern void redraw(int);
extern void hpglClose(void);
extern int  messgb(Widget, int, char *, struct PushButtonRow *, int);
extern int  StringWidth(XFontStruct *, char *);
extern int  StringHeight(XFontStruct *);
extern void (*drawString)(char *, double, double, double, int);
extern void (*drawOrtho)(GLdouble, GLdouble, GLdouble, GLdouble, GLdouble, GLdouble);
extern void setWindowColor(int, Pixel, const float *);

extern Widget topShell;
extern struct WINDOW windows[];
extern Pixel stdcol[9];
extern double paperWidth, paperHeight;
extern char title[];
extern int rgbMode, swapBuffers;

char *saveTiff(int window, char *file, int compression)
{
  static struct PushButtonRow buttons[] = {{"continue", GetMessageBoxButton, (XtPointer)0, NULL}};
  FILE *f;
  TIFF *tif;
  struct passwd *entry;
  Dimension width, height;
  Colormap colormap;
  XColor *colors=NULL;
  XVisualInfo *vi;
  unsigned char *data;
  char str[MAXLENLINE], *word;
  int ncolors;
  register long rps;
  register int i;

/* Try to open file to catch possible problems with permissions
   before using TIFF library to open file */

  if ((f=fopen(file, "w")) == NULL)
  {
    word=getStringResource(topShell, "unableToOpen");
    sprintf(str, word, file);
    messgb(topShell, 1, str, buttons, 1);
    return(NULL);
  }
  else
  {
    fclose(f);
    if ((tif=TIFFOpen(file, "w")) == NULL)
    {
      word=getStringResource(topShell, "unableToOpen");
      sprintf(str, word, file);
      messgb(topShell, 1, str, buttons, 1);
      return(NULL);
    }
  }

  XtVaGetValues(windows[window].widget, XmNwidth, &width, XmNheight, &height,
		    XmNcolormap, &colormap, GLwNvisualInfo, &vi, NULL);
  ncolors=vi->colormap_size;
  TIFFSetField(tif, TIFFTAG_IMAGEWIDTH, width);
  TIFFSetField(tif, TIFFTAG_IMAGELENGTH, height);
  TIFFSetField(tif, TIFFTAG_COMPRESSION, compression);
  rps=(long)8*1024/TIFFScanlineSize(tif);
  TIFFSetField(tif, TIFFTAG_ROWSPERSTRIP, rps == 0 ? 1L : rps);
  TIFFSetField(tif, TIFFTAG_XRESOLUTION, 1.0);
  TIFFSetField(tif, TIFFTAG_YRESOLUTION, 1.0);
  TIFFSetField(tif, TIFFTAG_RESOLUTIONUNIT, 1);
  TIFFSetField(tif, TIFFTAG_PLANARCONFIG, PLANARCONFIG_CONTIG);
  TIFFSetField(tif, TIFFTAG_ORIENTATION, ORIENTATION_BOTLEFT);
  entry=getpwuid(getuid());
  TIFFSetField(tif, TIFFTAG_ARTIST, entry->pw_gecos);
  TIFFSetField(tif, TIFFTAG_IMAGEDESCRIPTION, title);
  strcpy(str, PROGRAM);
  strcat(str, " ");
  strcat(str, VERSION);
  TIFFSetField(tif, TIFFTAG_SOFTWARE, str);
  TIFFSetField(tif, TIFFTAG_BITSPERSAMPLE, 8);
  TIFFSetField(tif, TIFFTAG_SAMPLESPERPIXEL, 3);
  TIFFSetField(tif, TIFFTAG_PHOTOMETRIC, PHOTOMETRIC_RGB);

  GLwDrawingAreaMakeCurrent(windows[window].widget, windows[window].context);
  if (rgbMode)
  {
    data=(unsigned char *)getmem((width+1)*(height+1), 3*sizeof(unsigned char));
    glReadPixels((GLint)0, (GLint)0, (GLsizei)width, (GLsizei)height, GL_RGB,
		     GL_UNSIGNED_BYTE, data);
  }
  else
  {
    data=(unsigned char *)getmem((width+1)*(height+1), sizeof(unsigned int));
    glReadPixels((GLint)0, (GLint)0, (GLsizei)width, (GLsizei)height,
		     GL_COLOR_INDEX, GL_UNSIGNED_INT, data);
    colors=(XColor *)getmem(ncolors, sizeof(XColor));
    for (i=0; i<ncolors; i++)
      colors[i].pixel=(long)i;
    XQueryColors(XtDisplay(windows[window].widget), colormap, colors, ncolors);
    for (i=0; i<ncolors; i++)
    {
      colors[i].red >>= 8;
      colors[i].green >>= 8;
      colors[i].blue >>= 8;
    }
  }
  writeTiff(tif, data, width, height, colors);
  TIFFClose(tif);
  if (colors != NULL) free((void *)colors);
  free((void *)data);
  word=getStringResource(topShell, "TIFFSaved");
  return(word);
}

void writeTiff(TIFF *tif, unsigned char *data, int width, int height,
               XColor *colors)
{
  unsigned char *scanline=NULL;
  unsigned char *ssc=NULL;
  unsigned int  *ssi=NULL;
  register unsigned int v;
  register int i, j;
  register unsigned char *pp;

  if (colors)
    ssi=(unsigned int *)data;
  else
    ssc=data;

  for (j = 0; j < height; j++)
  {
    if (!colors)
    {
      scanline=(unsigned char *)ssc;
      ssc += 3*width;
    }
    else
    {
      scanline=(unsigned char *)malloc(TIFFScanlineSize(tif));
      pp = scanline;
      for (i = 0; i < width; i++)
      {
	  v = *ssi;
        pp[0]=(char)colors[v].red;
        pp[1]=(char)colors[v].green;
        pp[2]=(char)colors[v].blue;
        pp += 3;
        ssi++;
      }
    }
    if (TIFFWriteScanline(tif, scanline, j, 0) < 0) break;
  }
  if (colors) free(scanline);
}

char *saveVectorFile(int window, char *file, int format)
{
  static struct PushButtonRow buttons[] = {{"continue", GetMessageBoxButton, (XtPointer)0, NULL}};
  FILE *f=NULL;
  Dimension width, height;
  int rgbModesave=rgbMode, modeSave=windows[window].mode;
  double ratio, xs, ys, fontSizeX, fontSizeY;
  const float black[4]   = {0.0, 0.0, 0.0, 0.0};
  int portrait, matrixMode;
  char *word=NULL, str[MAXLENLINE];

  GLwDrawingAreaMakeCurrent(windows[window].widget, windows[window].context);
  rgbMode=TRUE;
  swapBuffers=FALSE;
  XtVaGetValues(windows[window].widget,
		    XtNwidth, &width,
	          XtNheight, &height,
		    NULL);
  portrait=paperWidth < paperHeight ? TRUE : FALSE;
  ratio=(double)width/(double)height;

/* Keep 1 cm margin at each side */

  if (paperHeight*ratio > paperWidth)
  {
    xs=paperWidth/(paperWidth-20.);
    ys=xs*paperHeight*ratio/paperWidth;
  }
  else
  {
    ys=paperHeight/(paperHeight-20.);
    xs=ys*paperWidth/(paperHeight*ratio);
  }
  fontSizeX=(double)StringWidth(windows[window].font, "1000.")/(double)width;
  fontSizeY=(double)StringHeight(windows[window].font)/(double)height;
  setDrawingDevice(format);
  switch (format)
  {
    case HPGL:       f=hpglInit(file, -xs, xs, -ys, ys, fontSizeX/55., fontSizeY/20., 
					  width, portrait);
                     break;
    case POSTSCRIPT: if (width > height)
                       f=PostscriptInit(file, paperWidth, paperHeight, xs, ys,
                                       (double)fontSizeX*ratio/5., (double)fontSizeY/ratio,
						   portrait);
			   else
                       f=PostscriptInit(file, paperWidth, paperHeight, xs, ys,
                                       (double)fontSizeY, (double)fontSizeX/5.,
				  		   portrait);
                     break;
    case RAYTRACER:  f=raytraceInit(file, width, height);
			   if (windows[window].mode == WIREMODEL) windows[window].mode=STICKMODEL;
                     break;
  }
  if (f != NULL)
    redraw(window);
  else
  {
    word=getStringResource(topShell, "unableToOpen");
    sprintf(str, word, file);
    messgb(topShell, 1, str, buttons, 1);
    rgbMode=rgbModesave;
    swapBuffers=TRUE;
    setDrawingDevice(SCREEN);
    return(NULL);
  }
  strcpy(str, PROGRAM);
  strcat(str, " ");
  strcat(str, VERSION);
  strcat(str, ": ");
  strcat(str, title);
  setWindowColor(FOREGROUND, stdcol[BLACK], black);
  glGetIntegerv(GL_MATRIX_MODE, &matrixMode);
  glMatrixMode(GL_PROJECTION);
  glPushMatrix();
  glLoadIdentity();
  (*drawOrtho)(0.0, (double)width, 0.0, (double)height, 0.0, 1.0);
  switch (format)
  {
    case HPGL:       (*drawString)(str, 5.0, -10., 0.0, 0);
                     hpglClose();
                     word=getStringResource(topShell, "HPGLSaved");
                     break;
    case POSTSCRIPT: (*drawString)(str, 5.0, -10., 0.0, 0);
                     PostscriptClose();
                     word=getStringResource(topShell, "PostscriptSaved");
                     break;
    case RAYTRACER:  raytraceClose();
                     word=getStringResource(topShell, "RaytracerSaved");
			   windows[window].mode=modeSave;
                     break;
  }
  glPopMatrix();
  glMatrixMode(matrixMode);
  setDrawingDevice(SCREEN);
  rgbMode=rgbModesave;
  swapBuffers=TRUE;
  return(word);
}
