/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                                I N P U T . C                                 *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1996                   *
*                                                                              *
********************************************************************************
*
* $Id: input.c,v 1.1 1996/12/10 18:41:26 jrh Exp $
* $Log: input.c,v $
* Revision 1.1  1996/12/10  18:41:26  jrh
* Initial revision
*
*
*/
#include<ctype.h>
#include<stdlib.h>
#include<stdio.h>
#include<string.h>
#include<X11/Intrinsic.h>
#include "viewmol.h"
#include "dialog.h"

#define MAX(a, b) (a) > (b) ? (a) : (b)
#define MIN(a, b) (a) < (b) ? (a) : (b)

void relint(void);
void assignBasisset(struct BASISSET *, char *);
void moveBasissetData(struct BASISSET *, struct BASISSET *, int, int);
void changeExponentPointers(struct BASISSET *, long, int);
void sortBasis(void);
int  compar(const void *, const void *);
void saveGeometry(void);
void wrbas(int);

extern void GetMessageBoxButton(Widget, XtPointer, caddr_t);
extern char *getStringResource(Widget, char *);
extern int messgb(Widget, int, char *, struct PushButtonRow *, int);
extern void *getmem(size_t, size_t);
extern void *expmem(void *, size_t, size_t);
extern void fremem(void **);
extern int makeUnitCell(double, double, double, double, double, double, int);
extern int getNumber(char *, int *);
extern void cnorm(int);
extern void modcmo(struct ORBITAL *, int, int, int, int, int, int);
extern void assignBasisName(int, int);
extern int checkFile(char **);

extern struct ATOM *atoms;
extern struct NORMAL_MODE *normal_modes;
extern struct OPTION *options;
extern struct COORDS *history;
extern struct OPTIMIZATION *optimization;
extern struct ORBITAL *orbitals;
extern struct WINDOW windows[];
extern struct BASISSET *basisset;
extern double *cnm, *exponents, *coord;
extern char title[MAXLENLINE];
extern int na, nmodes, nopt, nhist;
extern int nbasfu, imag;
extern int existsUnitCell;
extern int debug;
extern double radfac, bndfac;
extern double emax, emin, cycle;
extern Widget topShell;
extern int needMoloch, gaussian;

int input(int argc, char **argv)
{
  static struct PushButtonRow buttons1[] = {{"exit", GetMessageBoxButton, (XtPointer)0, NULL}};
  static struct PushButtonRow buttons2[] = {{"exit", GetMessageBoxButton, (XtPointer)0, NULL},
                                            {"continue", GetMessageBoxButton, (XtPointer)1, NULL}};
  FILE *file;
  struct BASISSET *oldbasisset;
  char command[MAXLENLINE], line[MAXLENLINE], label[MAXLENLINE];
  char sym[4], *word, *w;
  GLdouble x, y, z;
  GLdouble energy;
  double *cmo=NULL, gmax, occ, *coeff, *oldexponents, *oldcmo;
  double a=0.0, b=0.0, c=0.0, alpha=0.0, beta=0.0, gamma=0.0;
  double aopt=0.0, bopt=0.0, copt=0.0, alphaopt=0.0, betaopt=0.0, gammaopt=0.0;
  register double e;
  size_t mna=20, mnn=60, mnh=50, mno=100, mnc=2000, mns=100, mnp=200;
  long offset;
  int readNext, n=0, ncoeff=0, *help, shell, primitive;
  int pured=TRUE, puref=TRUE, pureg=TRUE, frac=FALSE;
  int namax=0;
  register int i, j, k, l, m;

  if (argc > 1)
  {
    if (*argv[1] == '-')
    {
      argv[1]++;
      readNext=TRUE;
      for (i=0; i<nopt; i++)
      {
          if (!strcmp(options[i].flag, argv[1]))
        {
          sprintf(command, options[i].command, argv[2]);
          readNext=FALSE;
          break;
        }
      }
      if (readNext)
      {
	  word=getStringResource(topShell, "unknownParameter");
        sprintf(line, word, --argv[1]);
        messgb(topShell, 3, line, buttons1, 1);
        exit(-1);
      }
    }
    else
    {
	word=getStringResource(topShell, "unknownParameter");
      sprintf(line, word, argv[1]);
      messgb(topShell, 3, line, buttons1, 1);
      exit(-1);
    }
  }
  else
  {
    readNext=TRUE;
    for (i=0; i<nopt; i++)
    {
      if (!strcmp(options[i].flag, "default"))
      {
        strcpy(command, options[i].command);
        readNext=FALSE;
        break;
      }
    }
    if (readNext)
    {
	word=getStringResource(topShell, "noDefaultFilter");
      messgb(topShell, 3, word, buttons1, 1);
      exit(-1);
    }
  }
  word=command;
  if (!checkFile(&word))
  {
    word=getStringResource(topShell, "noFile");
    strtok(command, " \t");
    sprintf(line, word, command);
    messgb(topShell, 3, line, buttons1, 1);
    exit(-1);
  }
  if ((file=popen(command, "r")) == NULL)
  {
    word=getStringResource(topShell, "cannotExecute");
    sprintf(line, word, command);
    messgb(topShell, 3, line, buttons1, 1);
    exit(-1);
  }

  atoms=(struct ATOM *)getmem(mna, sizeof(struct ATOM));
  word=fgets(line, MAXLENLINE, file);
  while (word != NULL)
  {
    if (strstr(line, "$coord"))
    {
      i=0;
      word=strtok(line, " \t");
      if ((word=strtok(NULL, " \t")) != NULL)
	{
	  if (!strcmp(word, "fractional"))
        {
	    frac=TRUE;
	    if ((word=strtok(NULL, " \t")) != NULL)
		radfac=atof(word);
          else
		radfac=1.0e0;
	  }
        else
          radfac=atof(word);
	}
      else
        radfac=1.0e0;
      bndfac*=radfac;
      while (fgets(line, MAXLENLINE, file) != NULL)
      {
        if (strchr(line, '$')) break;
        sscanf(line, "%lf%lf%lf%s", &atoms[i].x, &atoms[i].y, &atoms[i].z, atoms[i].name);
        atoms[i].name[0]=toupper(atoms[i].name[0]);
        atoms[i].name[1]=tolower(atoms[i].name[1]);
        if (++i >= mna)
        {
          mna+=20;
          atoms=(struct ATOM *)expmem((void *)atoms, mna, sizeof(struct ATOM));
        }
      }
      na=i;
      mna=i;
      atoms=(struct ATOM *)expmem((void *)atoms, na+1, sizeof(struct ATOM));
      readNext=FALSE;
    }
    else if (strstr(line, "$title"))
    {
      fgets(title, MAXLENLINE, file);
      if ((word=strrchr(title, '\n')) != NULL)
        *word='\0';
      readNext=TRUE;
    }
    else if (strstr(line, "$vibrational normal modes"))
    {
      cnm=(double *)getmem(mnn*mnn, sizeof(double));
      i=0;
      while (fgets(line, MAXLENLINE, file) != NULL)
      {
        if (strchr(line, '$')) break;
        word=strtok(line, " \t");
        word=strtok(NULL, " \t");
        while ((word=strtok(NULL, " \t")) != NULL)
        {
          cnm[i]=atof(word); 
          if (++i >= mnn*mnn)
          {
            mnn+=60;
            cnm=(double *)expmem(cnm, mnn*mnn, sizeof(double));
          }
        }
      }
      readNext=FALSE;
    }
    else if (strstr(line, "$vibrational spectrum"))
    {
      normal_modes=(struct NORMAL_MODE *)getmem(mnn, sizeof(struct NORMAL_MODE));
      i=0;
      while (fgets(line, MAXLENLINE, file) != NULL)
      {
        if (strchr(line, '$')) break;
        sscanf(line, "%s%lf%lf%lf", normal_modes[i].sym, &normal_modes[i].wavenumber,
                                    &normal_modes[i].ir_intensity, &normal_modes[i].raman_intensity);
        if (++i >= mnn)
        {
          mnn+=60;
          normal_modes=(struct NORMAL_MODE *)expmem((void *)normal_modes, mnn, sizeof(struct NORMAL_MODE));
        }
      }
      nmodes=i;
      if (nmodes > 0)
      {
        normal_modes=(struct NORMAL_MODE *)expmem((void *)normal_modes, nmodes, sizeof(struct NORMAL_MODE));
        relint();
      }
      readNext=FALSE;
    }
    else if (strstr(line, "$grad"))
    {
      history=(struct COORDS *)getmem(mnh*mna, sizeof(struct COORDS));
      optimization=(struct OPTIMIZATION *)getmem(mnh, sizeof(struct OPTIMIZATION));
      i=j=k=0;
	namax=0;
	m=0;
      while (fgets(line, MAXLENLINE, file) != NULL)
      {
        if (strchr(line, '$')) break;
        if (strstr(line, "cycle"))
        {
          strtok(line, "=");
          strtok(NULL, "=");
          optimization[i].energy=atof(strtok(NULL, "="));
          optimization[i].gnorm=atof(strtok(NULL, "="));
	    optimization[i].coords=j;
	    if (namax < m)
	    {
		namax=m;
		cycle=i;
          }
          if (i > 0) optimization[i-1].natoms=m;
	    m=0;
          if (++i >= mnh)
          {
            mnh+=50;
            history=(struct COORDS *)expmem((void *)history, mnh*mna, sizeof(struct COORDS));
            optimization=(struct OPTIMIZATION *)expmem((void *)optimization, mnh,
                          sizeof(struct OPTIMIZATION));
          }
        }
	  else if (strstr(line, "unitcell"))
	  {
	    if (aopt != 0.0)
	    {
            makeUnitCell(aopt, bopt, copt, alphaopt, betaopt, gammaopt, FALSE);
            if (na > mna)
		{
		  mna=na;
		  history=(struct COORDS *)expmem((void *)history, mnh*mna, sizeof(struct COORDS));
		}
		na-=8;
		for (l=na; l<na+8; l++)
		{
		  history[j].x=atoms[l].x;
		  history[j].y=atoms[l].y;
		  history[j++].z=atoms[l].z;
		}
	    }
	    word=strtok(line, " \t");
          aopt=atof(strtok(NULL, " \t"));
          bopt=atof(strtok(NULL, " \t"));
          copt=atof(strtok(NULL, " \t"));
          alphaopt=atof(strtok(NULL, " \t"));
          betaopt=atof(strtok(NULL, " \t"));
          gammaopt=atof(strtok(NULL, " \t"));
	    optimization[i-1].coords=j;
	  }
        else
        {
          sscanf(line, "%lf%lf%lf", &x, &y, &z);
          strtok(line, " \t");
          strtok(NULL, " \t");
          strtok(NULL, " \t");
          if (strtok(NULL, " \t") != NULL)
          {
            history[j].x=x;
            history[j].y=y;
            history[j].z=z;
		m++;
		if (++j >= mnh*mna)
		{
		  mna+=20;
		  history=(struct COORDS *)expmem((void *)history, mnh*mna, sizeof(struct COORDS));
		}
          }
          else
          {
            history[k].gx=x;
            history[k].gy=y;
            history[k++].gz=z;
          }
        }
      }
      nhist=i;
      cycle=(double)i;
	optimization[i-1].natoms=m;
	if (namax < m)
	{
	  namax=m;
	  cycle=i;
      }
      atoms=(struct ATOM *)expmem((void *)atoms, namax+1, sizeof(struct ATOM));
      if (j > 0)
        history=(struct COORDS *)expmem((void *)history, j, sizeof(struct COORDS));
	if (nhist > 0)
        optimization=(struct OPTIMIZATION *)expmem((void *)optimization, nhist,
                      sizeof(struct OPTIMIZATION));
      emax=emin=optimization[0].energy;
      gmax=optimization[0].gnorm;
      for (i=1; i<nhist; i++)
      {
        emax=MAX(emax, optimization[i].energy);
        emin=MIN(emin, optimization[i].energy);
        gmax=MAX(gmax, optimization[i].gnorm);
      }
      readNext=FALSE;
      windows[HISTORY].right=(double)(nhist);
      windows[HISTORY].top=gmax == 0.0 ? 0.01 : gmax;
	if (gmax == 0.0) windows[HISTORY].mode=SCALES | ENERGY;
    }
    else if (strstr(line, "$scfmo"))
    {
      if (strstr(line, "symmetrized")) needMoloch=TRUE;
      if (strstr(line, "gaussian")) gaussian=TRUE;
      orbitals=(struct ORBITAL *)getmem(mno, sizeof(struct ORBITAL));
      cmo=(double *)getmem(mnc, sizeof(double));
      ncoeff=i=j=0;
      while (TRUE)
      {
        fgets(line, MAXLENLINE, file);
        if (line[0] == '$')
        {
          readNext=FALSE;
          break;
        }
        if ((word=strtok(line, " \t")) != NULL)
        {
          word=strtok(NULL, " \t");
          strcpy(orbitals[i].symmetry, word);
          word=strtok(NULL, "=");
          word=strtok(NULL, " \t");
          orbitals[i].energy=atof(word);
          word=strtok(NULL, "=");
          word=strtok(NULL, " \t");
          n=atoi(word);
          ncoeff+=n;
        }
        if (n != 0)
        {
          orbitals[i].coeff=&cmo[j];
          do
          {
            fgets(line, MAXLENLINE, file);
            if ((word=strrchr(line, '\n')) != NULL) *word='\0';
            if ((word=strtok(line, " \t")) != NULL)
            {
              cmo[j]=atof(word);
              n--;
              if (++j >= mnc)
              {
                mnc+=2000;
                oldcmo=cmo;
                cmo=(double *)expmem(cmo, mnc, sizeof(double));
                if (oldcmo != cmo)
                {
                  offset=(char *)cmo-(char *)oldcmo;
                  for (l=0; l<=i; l++)
                  {
                    w=(char *)orbitals[l].coeff+offset;
                    orbitals[l].coeff=(double *)w;
                  }
                }
              }
            }
            while ((word=strtok(NULL, " \t")) != NULL)
            {
              cmo[j]=atof(word);
              n--;
              if (++j >= mnc)
              {
                mnc+=2000;
                oldcmo=cmo;
                cmo=(double *)expmem(cmo, mnc, sizeof(double));
                if (oldcmo != cmo)
                {
                  offset=(char *)cmo-(char *)oldcmo;
                  for (l=0; l<=i; l++)
                  {
                    w=(char *)orbitals[l].coeff+offset;
                    orbitals[l].coeff=(double *)w;
                  }
                }
              }
            }
          } while (n > 0);
        }
        if (++i >= mno)
        {
          mno+=100;
          orbitals=(struct ORBITAL *)expmem(orbitals, mno, sizeof(struct ORBITAL));
        }
      }  /* end of "while (TRUE)" */
      nbasfu=i;
      if (nbasfu > 0)
        orbitals=(struct ORBITAL *)expmem(orbitals, nbasfu, sizeof(struct ORBITAL));
      oldcmo=cmo;
      cmo=(double *)expmem(cmo, mnc, sizeof(double));
      if (oldcmo != cmo)
      {
        k=(char *)cmo-(char *)oldcmo;
        for (l=0; l<i; l++)
        {
          m=(int)orbitals[l].coeff+k;
          orbitals[l].coeff=(double *)m;
        }
      }
      for (i=0; i<nbasfu; i++)
      {
        e=orbitals[i].energy;
        k=i;
        for (j=i+1; j<nbasfu; j++)
        {
          if (orbitals[j].energy < e)
          {
            e=orbitals[j].energy;
            k=j;
          }
        }
        if (k != i)
        {
          energy=orbitals[k].energy;
          occ=orbitals[k].occupation;
          coeff=orbitals[k].coeff;
          strcpy(sym, orbitals[k].symmetry);
          orbitals[k].energy=orbitals[i].energy;
          orbitals[k].occupation=orbitals[i].occupation;
          orbitals[k].coeff=orbitals[i].coeff;
          strcpy(orbitals[k].symmetry, orbitals[i].symmetry);
          orbitals[i].energy=energy;
          orbitals[i].occupation=occ;
          orbitals[i].coeff=coeff;
          strcpy(orbitals[i].symmetry, sym);
        }
      }
	if ((word=getStringResource(topShell, "MO-energy")) == NULL)
	{
        windows[MO].bottom=1.05*orbitals[0].energy;
        windows[MO].top=1.05*orbitals[nbasfu-1].energy;
      }
	else
	{
	  windows[MO].bottom=atof(strtok(word, ":")); 
	  windows[MO].top=atof(strtok(NULL, ":")); 
	}
    }  /* end of "else if (strstr(line, "$scfmo"))" */
    else if (strstr(line, "$closed shells"))
    {
      if (nbasfu == 0)
      {
        word=fgets(line, MAXLENLINE, file);
        continue;
      }
      help=(int *)getmem(nbasfu, sizeof(int));
      while (fgets(line, MAXLENLINE, file) != NULL)
      {
        if (strchr(line, '$')) break;
        word=strtok(line, " \t");
        w=strtok(NULL, " \t");
        i=getNumber(w, help);
        for (j=0; j<nbasfu; j++)
        {
          if (!strcmp(orbitals[j].symmetry, word))
          {
            orbitals[j].occupation=2.0;
            if (--i == 0) break;
          }
        }
      }
      fremem((void **)&help);
    }
    else if (strstr(line, "$atoms"))
    {
      while (fgets(line, MAXLENLINE, file) != NULL)
      {
        if (strchr(line, '$')) break;
        word=strtok(line, " \t");
        word=strtok(NULL, " \t");
        help=(int *)getmem(mna, sizeof(int));
        i=getNumber(word, help);
        fgets(line, MAXLENLINE, file);
        while (strstr(line, "basis") == NULL && !strchr(line, '$'))
          fgets(line, MAXLENLINE, file);
        word=strtok(line, "=");
        word=strtok(NULL, "\\\n");
        for (j=0; j<i; j++)
          strncpy(atoms[help[j]-1].basisname, word, MAXLENBASISNAME-1);
        fremem((void **)&help);
      }
      readNext=FALSE;
    }
    else if (strstr(line, "$basis"))
    {
      if (basisset == NULL)
        basisset=(struct BASISSET *)getmem(mns, sizeof(struct BASISSET));
      if (exponents == NULL)
        exponents=(double *)getmem(mnp, 2*sizeof(double));
      shell=0;
      primitive=0;

      while (fgets(line, MAXLENLINE, file) != NULL)
      {
        if (strchr(line, '*'))
        {
          if (shell != 0) basisset[shell-1].next=(struct BASISSET *)NULL;
          fgets(line, MAXLENLINE, file);
          if (strchr(line, '$')) break;
          assignBasisset(&basisset[shell], line);
          fgets(line, MAXLENLINE, file);
          fgets(line, MAXLENLINE, file);
        }
        basisset[shell].first=&exponents[primitive];
        word=strtok(line, " \t");
        basisset[shell].nprim=atoi(word);
        word=strtok(NULL, " \t");
        if (isdigit(*word))
          basisset[shell].ang=atoi(word);
        else
        {
          switch (*word)
          {
            case 's': basisset[shell].ang=0;
                      break;
            case 'p': basisset[shell].ang=1;
                      break;
            case 'd': basisset[shell].ang=2;
                      break;
            default:  basisset[shell].ang=(*word)-'c';
                      break;
          }
        }
        for (j=0; j<basisset[shell].nprim; j++)
        {
          fgets(line, MAXLENLINE, file);
          word=strtok(line, " \t");
          exponents[primitive++]=atof(word);
          word=strtok(NULL, " \t");
          exponents[primitive++]=atof(word);
          if (primitive >= mnp)
          {
            mnp+=100;
            oldexponents=exponents;
            exponents=(double *)expmem((void *)exponents, mnp, 2*sizeof(double));
            if (exponents != oldexponents)
              changeExponentPointers(basisset, exponents-oldexponents, shell);
          }
        }
        if (++shell >= mns)
        {
          mns+=100;
          oldbasisset=basisset;
          basisset=(struct BASISSET *)getmem(mns, sizeof(struct BASISSET));
          moveBasissetData(basisset, oldbasisset, shell, na);
	    fremem((void **)&oldbasisset);
        }
        basisset[shell-1].next=&basisset[shell];
      }
      readNext=FALSE;
      oldexponents=exponents;
      if (primitive > 0)
        exponents=(double *)expmem((void *)exponents, primitive, sizeof(double));
      if (exponents != oldexponents)
        changeExponentPointers(basisset, exponents-oldexponents, shell);
      oldbasisset=basisset;
      if (shell > 0)
      {
        basisset=(struct BASISSET *)getmem(shell, sizeof(struct BASISSET));
        moveBasissetData(basisset, oldbasisset, shell, na);
	  fremem((void **)&oldbasisset);
	}
      if (debug == 2) wrbas(na);
      cnorm(na);
    }
    else if (strstr(line, "$unitcell"))
    {
	word=strtok(line, " \t");
      a=atof(strtok(NULL, " \t"));
      b=atof(strtok(NULL, " \t"));
      c=atof(strtok(NULL, " \t"));
      alpha=atof(strtok(NULL, " \t"));
      beta=atof(strtok(NULL, " \t"));
      gamma=atof(strtok(NULL, " \t"));
      readNext=TRUE;
    }
    else if (strstr(line, "$pople"))
    {
	if (strstr(line, "6d"))  pured=FALSE;
	if (strstr(line, "10f")) puref=FALSE;
	if (strstr(line, "15g")) pureg=FALSE;
	readNext=TRUE;
    }
    else if (strstr(line, "$error"))
    {
      word=strtok(line, " \t");
      word=strtok(NULL, " \t");
      if ((w=getStringResource(topShell, word)) == NULL)
      {
        w=getStringResource(topShell, "unknownErrorMessage");
        i=TRUE;
      }
      else
      {
        i=atoi(strtok(NULL, " \t"));
        word=strtok(NULL, " \t\n");
      }
      sprintf(label, w, word);
      if (i)
      {
        messgb(topShell, 3, label, buttons1, 1);
	  exit(-1);
      }
      else
        if (!messgb(topShell, 3, label, buttons2, 2)) exit(-1);
      readNext=TRUE;
    }
    else if (strstr(line, "$end"))
    {
	pclose(file);
      if (basisset != NULL)
	{
	  if (!gaussian) sortBasis();
	  assignBasisName(na, nbasfu);
      }
      if (orbitals != NULL && ncoeff != 0)
      {
        if (basisset != NULL)
	  {
	    modcmo(orbitals, pured, puref, pureg, na, nbasfu, gaussian);
          fremem((void **)&cmo);
	  }
      }
      if (a != 0.0) existsUnitCell=makeUnitCell(a, b, c, alpha, beta, gamma, frac);
/*    if (na != namax && namax != 0) setGeometry(FALSE); */
      return(TRUE);
    }
    else
      readNext=TRUE;

    if (readNext)
      word=fgets(line, MAXLENLINE, file);
    else
      word=line;
  }   /* end of "while (word != ..." */
  if (na == 0)
  {
    word=getStringResource(topShell, "noCoordinates");
    sprintf(label, word, argv[2]);
    messgb(topShell, 3, label, buttons1, 1);
    exit(-1);
  }
  return(TRUE);
}

void relint(void)
{
  double wimax=0.0, rmimax=0.0;
  register int i;

/* Compute relative intensities (0 - 100 %) */
  for (i=0; i<nmodes; i++)
  {
    if (normal_modes[i].ir_intensity < 0.0e0) normal_modes[i].ir_intensity=0.0e0;
    if (normal_modes[i].raman_intensity < 0.0e0) normal_modes[i].raman_intensity=0.0e0;
    wimax=MAX(wimax, normal_modes[i].ir_intensity);
    rmimax=MAX(rmimax, normal_modes[i].raman_intensity);
    if (normal_modes[i].wavenumber < 0.0e0) imag++;
  }
  if (wimax > 0.0)
    wimax=100./wimax;
  else
    wimax=1.0;
  if (rmimax > 0.0)
    rmimax=100./rmimax;
  else
    rmimax=1.0;
  for (i=0; i<nmodes; i++)
  {
    normal_modes[i].rel_ir_intensity=normal_modes[i].ir_intensity*wimax;
    normal_modes[i].rel_raman_intensity=normal_modes[i].raman_intensity*rmimax;
  }
}

int getNumber(char *str, int *array)
{
  register int i=0, j, cont=FALSE;
  register char *start, *p;

  start=p=str;
  while (*p)
  {
    if (*p == '-')
    {
      cont=TRUE;
      *p='\0';
      array[i++]=atoi(start);
      start=p+1;
    }
    else if (*p == ',')
    {
      *p='\0';
      if (cont)
      {
        for (j=array[i-1]+1; j<=atoi(start); j++)
          array[i++]=j;
        cont=FALSE;
      }
      else
        array[i++]=atoi(start);
      start=p+1;
    }
    p++;
  }
  if (cont)
  {
    for (j=array[i-1]+1; j<=atoi(start); j++)
      array[i++]=j;
  }
  else
    array[i++]=atoi(start);
  return(i);
}

void assignBasisset(struct BASISSET *basisset, char *label)
{
  register int i, j;

  for (i=0; i<na; i++)
  {
    j=strlen(atoms[i].basisname);
    if (j && !strncmp(atoms[i].basisname, label, j))
    {
      atoms[i].basis=basisset;
      *atoms[i].basisname='\0';
    }
  }
}

void moveBasissetData(struct BASISSET *new, struct BASISSET *old, int shell,
			    int na)
{
  register long offset;
  register int i;
  register char *p;

  offset=(char *)new-(char *)old;
  for (i=0; i<na; i++)
  {
    if (atoms[i].basis != NULL)
    {
      p=(char *)atoms[i].basis+offset;
	atoms[i].basis=(struct BASISSET *)p;
    }
  }
  for (i=0; i<shell; i++)
  {
    new[i].first=old[i].first;
    new[i].nprim=old[i].nprim;
    new[i].ang=old[i].ang;
    new[i].next=old[i].next;
    if (new[i].next != NULL)
    {
	p=(char *)new[i].next+offset;
	new[i].next=(struct BASISSET *)p;
    }
  }
}

void changeExponentPointers(struct BASISSET *basisset, long offset, int shell)
{
  register int i;

  for (i=0; i<=shell; i++)
    basisset[i].first+=offset;
}

void sortBasis(void)
{
  struct BASISSET *shell1, *shell2, *sorted;
  int type;
  register int i, j, k;

  for (i=0; i<na; i++)
  {
    j=0;
    shell1=atoms[i].basis;
    while (shell1 != NULL)
    {
      j++;
      shell1=shell1->next;
    }
    sorted=(struct BASISSET *)getmem(j, sizeof(struct BASISSET));
    k=0;
    shell1=atoms[i].basis;
    while (shell1 != NULL)
    {
	type=shell1->ang;
	if (type != -1)
	{
        shell2=shell1;
  	  while (shell2 != NULL)
  	  {
	    if (shell2->ang == type)
	    {
	      sorted[k].first=shell2->first;
	      sorted[k].ang=shell2->ang;
	      sorted[k++].nprim=shell2->nprim;
	      shell2->ang=(-1);
	    }
	    shell2=shell2->next;
	  }
	}
	shell1=shell1->next;
    }
    k=0;
    shell1=atoms[i].basis;
    while (shell1 != NULL)
    {
	shell1->first=sorted[k].first;
	shell1->ang=sorted[k].ang;
	shell1->nprim=sorted[k++].nprim;
	shell1=shell1->next;
    }
    free(sorted);
  }
}

int compar(const void *first, const void *second)
{
  struct BASISSET *f=(struct BASISSET *)first, *s=(struct BASISSET *)second;

  return(f->ang - s->ang);
}

void saveGeometry(void)
{
  register int i, j;

  coord=(double *)getmem(3*na, sizeof(double));
  j=0;
  for (i=0; i<na; i++)
  {
    coord[j++]=atoms[i].x;
    coord[j++]=atoms[i].y;
    coord[j++]=atoms[i].z;
  }
}

void wrbas(int na)
{                                    /* dump basis set for debugging */
  struct BASISSET *shell;
  int *done;
  register int i, j;
  register char ang;
  register double *p;

  done=(int *)getmem((size_t)na, sizeof(int));

  for (i=0; i<na; i++)
  {
    if (done[i]) continue;
    printf("Atom(s) %d", i+1);
    done[i]=TRUE;
    shell=atoms[i].basis;
    for (j=i+1; j<na; j++)
    {
      if (atoms[j].basis == shell)
      {
        printf(", %d", j+1);
        done[j]=TRUE;
      }
    }
    printf("\n");
    do
    {
      switch (shell->ang)
      {
        case 0:  ang='s';
                 break;
        case 1:  ang='p';
                 break;
        case 2:  ang='d';
                 break;
        default: ang=shell->ang+'c';
                 break;
      }
      printf("%4d  %c\n", shell->nprim, ang);
      p=shell->first;
      for (j=0; j<shell->nprim; j++)
      {
        printf("%f  %f\n", *p, *(p+1));
        p+=2;
      }
      shell=shell->next;
    } while (shell != NULL);
  }
  fremem((void **)&done);
}
