/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                               M K C O N N . C                                *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1996                   *
*                                                                              *
********************************************************************************
*
* $Id: mkconn.c,v 1.1 1996/12/10 18:42:09 jrh Exp $
* $Log: mkconn.c,v $
 * Revision 1.1  1996/12/10  18:42:09  jrh
 * Initial revision
 *
*
*/
#include<math.h>
#include<stdio.h>
#include<X11/Intrinsic.h>
#include<Xm/Xm.h>
#include "viewmol.h"
#include "dialog.h"

extern struct ATOM *atoms;
extern struct BOND *bonds;
extern struct ORBITAL *orbitals;
extern struct BASISSET *basisset;
extern struct WINDOW windows[];
extern double amplitude, forceScale;
extern double transx, transy, transz;
extern int na, nb, ne;
extern int debug, needMoloch;
extern Widget topShell;

extern void saveGeometry(void);
extern double bondLength(int, int);
extern void GetMessageBoxButton(Widget, XtPointer, caddr_t);
extern char *getStringResource(Widget, char *);
extern void *getmem(size_t, size_t);
extern void *expmem(void *, size_t, size_t);
extern void fremem(void **);
extern int messgb(Widget, int, char *, struct PushButtonRow *, int);

int makeConnectivity(int uc)
{
  static struct PushButtonRow buttons[] = {{"exit", GetMessageBoxButton, (XtPointer)0, NULL}};
  double r1, r2, box;
  int *connectivity;
  char line[MAXLENLINE], *word;
  size_t mnb=20;
  register int i, j, k;

  transx=0.0e0;
  transy=0.0e0;
  transz=0.0e0;
  for (i=0; i<na; i++)
  {
    transx+=atoms[i].x;
    transy+=atoms[i].y;
    transz+=atoms[i].z;
  }
  transx=-transx/(double)(na);
  transy=-transy/(double)(na);
  transz=-transz/(double)(na);
  for (i=0; i<na; i++)
  {
    atoms[i].x+=transx;
    atoms[i].y+=transy;
    atoms[i].z+=transz;
  }
  saveGeometry();

  connectivity=(int *)getmem((size_t)(8*na), sizeof(int));
  box=0.0e0;
  for (i=0; i<na; i++)
  {
    atoms[i].nbonds=0;
    if (strncmp(atoms[i].name, "Uc", 2))
    {
      for (j=0; j<na; j++)
      {
        if (i != j && strncmp(atoms[j].name, "Uc", 2))
        {
          r1=bondLength(i, j);
          r2=atoms[i].rad+atoms[j].rad;
          box=box > r1+r2 ? box : r1+r2;
          if (r1 < r2)
          {
            atoms[i].nbonds++;
            if (atoms[i].nbonds > 8)
            {
		  word=getStringResource(topShell, "tooManyBonds");
              sprintf(line, word, i);
	  	  messgb(topShell, 3, line, buttons, 1);
              exit(-1);
            }
            connectivity[8*i+atoms[i].nbonds-1]=j;
          }
        }
      }
    }
    else
    {
	uc=i;
	atoms[i].nbonds=3;
    }
  }
  amplitude=box=forceScale=1.05*box/sqrt(3.);
  windows[VIEWER].left=(-box);
  windows[VIEWER].right=box;
  windows[VIEWER].bottom=(-box);
  windows[VIEWER].top=box;
  windows[VIEWER].near=(-box);
  windows[VIEWER].far=box;

  bonds=(struct BOND *)getmem(mnb, sizeof(struct BOND));
  nb=0;
  for (i=0; i<na; i++)
  {
    for (j=0; j<atoms[i].nbonds; j++)
    {
      k=connectivity[8*i+j];
      if (i < k)
      {
        bonds[nb].first=i;
        bonds[nb].second=k;
	  bonds[nb].order=(struct BONDORDER *)NULL;
        bonds[nb++].frac=atoms[i].rad/bondLength(i, k);
      }
      if (nb >= mnb)
      {
        mnb+=20;
        bonds=(struct BOND *)expmem((void *)bonds, mnb, sizeof(struct BOND));
      }
    }
  }
  fremem((void **)&connectivity);
  if (nb > 0)
    bonds=(struct BOND *)expmem((void *)bonds, nb, sizeof(struct BOND));
  if (uc)
  {
    bonds=(struct BOND *)expmem((void *)bonds, nb+12, sizeof(struct BOND));
    bonds[nb].first=uc-7;
    bonds[nb++].second=uc-6;
    bonds[nb].first=uc-7;
    bonds[nb++].second=uc-5;
    bonds[nb].first=uc-7;
    bonds[nb++].second=uc-4;
    bonds[nb].first=uc-6;
    bonds[nb++].second=uc-3;
    bonds[nb].first=uc-6;
    bonds[nb++].second=uc;
    bonds[nb].first=uc-5;
    bonds[nb++].second=uc-1;
    bonds[nb].first=uc-5;
    bonds[nb++].second=uc;
    bonds[nb].first=uc-4;
    bonds[nb++].second=uc-3;
    bonds[nb].first=uc-4;
    bonds[nb++].second=uc-1;
    bonds[nb].first=uc-3;
    bonds[nb++].second=uc-2;
    bonds[nb].first=uc-2;
    bonds[nb++].second=uc-1;
    bonds[nb].first=uc-2;
    bonds[nb++].second=uc;
    for (i=nb-12; i<nb; i++)
    {
	bonds[i].order=(struct BONDORDER *)NULL;
      bonds[i].frac=0.5;
    }
  }
  if (debug == 1)
  {
    printf("Bonds:\n");
    for (i=0; i<nb; i++)
    {
      printf("%d: %s(%d)-%s(%d)\n", i, atoms[bonds[i].first].name, bonds[i].first,
             atoms[bonds[i].second].name, bonds[i].second);
    }
  }
  return(TRUE);
}
