/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                           P O S T S C R I P T . C                            *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1996                   *
*                                                                              *
********************************************************************************
*
* $Id: postscript.c,v 1.1 1996/12/10 18:43:12 jrh Exp $
* $Log: postscript.c,v $
* Revision 1.1  1996/12/10  18:43:12  jrh
* Initial revision
*
*/
#include<pwd.h>
#include<stdio.h>
#include<time.h>
#include<unistd.h>
#include<sys/types.h>
#include<X11/Xlib.h>
#include<GL/gl.h>
#include "viewmol.h"
#include "dialog.h"

#define TOPSUNIT 72./25.4

extern struct WINDOW windows[4];
extern char title[MAXLENLINE];
extern double tmat[4][4], prmat[4][4];
static FILE *file=NULL;
static double xnull, ynull, znull, xlast, ylast;
static int what, portrait;
static int psWidth, psHeight;
static char *op, moveto[]="moveto";

extern void getMatrix(double matrix[4][4]);
extern void multMatrix(double matrix1[4][4], double matrix2[4][4], double matrix3[4][4]);

FILE *PostscriptInit(char *, double, double, double, double, double, double,
			   int);
void PostscriptClose(void);
void PostscriptBegin(int);
void PostscriptEnd(void);
void PostscriptVertex3d(double, double, double);
void PostscriptVertex2d(double, double);
void PostscriptNormal3d(double, double, double);
void PostscriptColor4fv(const GLfloat *);
void PostscriptString(char *, double, double, double, GLuint);
void PostscriptLineStipple(GLint, GLushort);
void PostscriptLineWidth(GLfloat);
void PostscriptDisable(GLenum);
void PostscriptClearColor(GLclampf, GLclampf, GLclampf, GLclampf);
void PostscriptOrtho(GLdouble, GLdouble, GLdouble, GLdouble, GLdouble, GLdouble);
void PostscriptPopMatrix(void);

FILE *PostscriptInit(char *filename, double paperWidth, double paperHeight,
			   double xs, double ys, double fsx, double fsy,
			   int rotate)
{
  time_t now;
  struct passwd *entry;
  double matrix[4][4];
  register int i, j;

  if (file == NULL)
  {
    psWidth=(int)(paperWidth*TOPSUNIT);
    psHeight=(int)(paperHeight*TOPSUNIT);
    if ((file=fopen(filename, "w")) == NULL) return(NULL);
    fprintf(file, "%%!PS-Adobe-3.0\n");
    fprintf(file, "%%%%BoundingBox: 0 0 %d %d\n", psWidth, psHeight);
    fprintf(file, "%%%%Creator: %s %s\n", PROGRAM, VERSION);
    now=time((time_t *)NULL);
    fprintf(file, "%%%%CreationDate: %s", ctime(&now));
    entry=getpwuid(getuid());
    fprintf(file, "%%%%For: %s\n", entry->pw_gecos);
    if (rotate)
      fprintf(file, "%%%%Orientation: Portrait\n");
    else
      fprintf(file, "%%%%Orientation: Landscape\n");
    fprintf(file, "%%%%Pages: 1\n");
    fprintf(file, "%%%%Title: %s\n", title);
    fprintf(file, "%%%%EndComments\n");
    fprintf(file, "%%%%Page: 0 1\n");
    fprintf(file, "/Times-Roman findfont dup length dict begin\n");
    fprintf(file, "{1 index /FID ne {def} {pop pop} ifelse} forall\n");
    fprintf(file, "/Encoding ISOLatin1Encoding def currentdict end\n");
    fprintf(file, "/Times-Roman-ISOLatin1 exch definefont pop\n");
    fprintf(file, "/Times-Roman-ISOLatin1 findfont [%f 0 0 %f 0 0] makefont setfont\n", fsx*psWidth, fsy*psHeight);
    portrait=rotate;
    getMatrix(matrix);
    for (i=0; i<4; i++)
    {
	for (j=0; j<4; j++)
        prmat[i][j]=0.0;
    }
    prmat[0][0]=psWidth/(2.*xs);
    prmat[1][1]=psHeight/(2.*ys);
    prmat[3][0]=psWidth*0.5;
    if (portrait)
      prmat[3][1]=psHeight*0.5;
    else
      prmat[3][1]=(-psHeight*0.5);
    multMatrix(matrix, prmat, tmat);
  }
  return(file);
}

void PostscriptClose(void)
{
  fprintf(file, "showpage\n%%%%EOF\n");
  fclose(file);
  file=NULL;
}

void PostscriptBegin(int mode)
{
  what=mode;
  op=moveto;
}

void PostscriptEnd()
{
  if ((-what) == GL_LINE_LOOP) PostscriptVertex3d(xnull, ynull, znull);
  fprintf(file, "stroke\n");
}

void PostscriptVertex3d(double x, double y, double z)
{
  double t[3];
  static char lineto[]="lineto";

  t[0]=x*tmat[0][0]+y*tmat[1][0]+z*tmat[2][0]+tmat[3][0];
  t[1]=x*tmat[0][1]+y*tmat[1][1]+z*tmat[2][1]+tmat[3][1];
/*t[2]=x*tmat[0][2]+y*tmat[1][2]+z*tmat[2][2]+tmat[3][2];*/
  if (portrait)
  {
    fprintf(file, "%f %f %s\n", t[0], t[1], op);
    xlast=t[0];
    ylast=t[1];
  }
  else
  {
    fprintf(file, "%f %f %s\n", -t[1], t[0], op);
    xlast=(-t[1]);
    ylast=t[0];
  }

  if (what == GL_LINE_LOOP)
  {
    xnull=x;
    ynull=y;
    znull=z;
    what=(-what);
  }
  
  if (what == GL_LINES && op == lineto)
    op=moveto;
  else
    op=lineto;
}

void PostscriptVertex2d(double x, double y)
{
  PostscriptVertex3d(x, y, 0.0);
}

void PostscriptNormal3d(double x, double y, double z)
{
}

void PostscriptColor4fv(const GLfloat *color)
{
  fprintf(file, "stroke\n%f %f %f setrgbcolor\n", color[0], color[1], color[2]);
  if (op != moveto) fprintf(file, "%f %f moveto\n", xlast, ylast);
}

void PostscriptString(char *str, double x, double y, double z, GLuint dummy)
{
  char *opsave;

  opsave=op;
  op=moveto;
  PostscriptVertex3d(x, y, z);
  if (portrait)
  {
    fprintf(file, "(%s) show\n", str);
  }
  else
  {
    fprintf(file, "gsave 90 rotate (%s) show grestore\n", str);
  }
  op=opsave;
}

void PostscriptLineStipple(GLint line, GLushort style)
{
  int count;
  register int i, j, k;

  fprintf(file, "[");
  j=style & 1;
  count=1;
  for (i=1; i<sizeof(GLushort)*8; i++)
  {
    k=(style & (1 << i)) >> i;
    if (k != j)
    {
	fprintf(file, "%d ", count);
	j=k;
	count=1;
    }
    else
	count++;
  }
  fprintf(file, "] 0 setdash\n");
}

void PostscriptLineWidth(GLfloat lineWidth)
{
  fprintf(file, "%f setlinewidth\n", lineWidth);
}

void PostscriptDisable(GLenum what)
{
  if (what == GL_LINE_STIPPLE)
    fprintf(file, "[] 0 setdash\n");
}

void PostscriptClearColor(GLclampf red, GLclampf green, GLclampf blue,
				  GLclampf alpha)
{
  fprintf(file, "%f %f %f setrgbcolor\n", red, green, blue);
  if (portrait)
    fprintf(file, "0 0 moveto %d 0 lineto %d %d lineto 0 %d lineto closepath fill\n", psWidth, psWidth, psHeight, psHeight);
  else
    fprintf(file, "0 0 moveto %d 0 lineto %d %d lineto 0 %d lineto closepath fill\n", psHeight, psHeight, psWidth, psWidth);
}

void PostscriptOrtho(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble near,
                     GLdouble far)
{
  double matrix[4][4];

  glOrtho(left, right, bottom, top, near, far);
  glGetDoublev(GL_PROJECTION_MATRIX, &matrix[0][0]);
  multMatrix(matrix, prmat, tmat);
}

void PostscriptPopMatrix(void)
{
  double matrix[4][4];

  glPopMatrix();
  glGetDoublev(GL_PROJECTION_MATRIX, &matrix[0][0]);
  multMatrix(matrix, prmat, tmat);
}
