/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                                  R A Y . C                                   *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1996                   *
*                                                                              *
********************************************************************************
*
* $Id: ray.c,v 1.1 1996/12/10 18:43:24 jrh Exp $
* $Log: ray.c,v $
* Revision 1.1  1996/12/10  18:43:24  jrh
* Initial revision
*
*
*/
#include<stdio.h>
#include<unistd.h>
#include<GL/glu.h>
#include "viewmol.h"
#include "dialog.h"

extern void getMatrix(double matrix[4][4]);
extern void *getmem(size_t, size_t);
extern void fremem(void **);

static FILE *file=NULL;

extern struct WINDOW windows[4];
extern struct ATOM *atoms;
extern struct ELEMENT *elements;
extern double tmat[4][4];
extern int na, ne, iwavef;

static struct ELEMENT *material;
static double n[3], ortho[3];
static int printNormal;

FILE *raytraceInit(char *filename, Dimension width, Dimension height)
{
  struct ELEMENT *element;
  int *done;
  register int i, j;

  if (file == NULL)
  {
    if ((file=fopen(filename, "w")) == NULL) return(NULL);
    fprintf(file, "screen %d %d\n", width, height);
    getMatrix(tmat);
    fprintf(file, "eyep 0.0 0.0 %12.7f\n", windows[VIEWER].far/0.41421356);
    fprintf(file, "up 0 1 0\n");
    fprintf(file, "background %6.3f %6.3f %6.3f\n", windows[VIEWER].background_rgb[0],
            windows[VIEWER].background_rgb[1], windows[VIEWER].background_rgb[2]);
    fprintf(file, "light 0.5 directional 0.2 0.1 1. noshadow\n");
    fprintf(file, "light 1.0 directional -1. 1. 1.\n");
    done=(int *)getmem(na, sizeof(int));
    for (i=0; i<na; i++)
    {
      if (!done[i])
      {
        element=atoms[i].element;
        fprintf(file, "surface %s\n", element->symbol);
        fprintf(file, "  diffuse %5.3f %5.3f %5.3f\n",
                (element->dark[0]+element->light[0])*0.5,
		    (element->dark[1]+element->light[1])*0.5,
		    (element->dark[2]+element->light[2])*0.5);
        fprintf(file, "  ambient %5.3f %5.3f %5.3f\n", element->ambient[0], element->ambient[1],
		    element->ambient[2]);
        fprintf(file, "  specular %5.3f %5.3f %5.3f\n", element->specular[0], element->specular[1],
		    element->specular[2]);
        fprintf(file, "  specpow %7.3f\n", element->shininess);
	  fprintf(file, "  transp  %7.3f\n", element->alpha);
        for (j=i; j<na; j++)
        {
          if (atoms[j].element == element) done[j]=TRUE;
        }
      }
    }
    if (iwavef != ALL_OFF)
    {
	for (i=0; i<ne; i++)
	{
	  if (!strcmp(elements[i].symbol, "Ps") || !strcmp(elements[i].symbol, "Ms"))
	  {
          fprintf(file, "surface %s\n", elements[i].symbol);
          fprintf(file, "  diffuse %5.3f %5.3f %5.3f\n",
                  (elements[i].dark[0]+elements[i].light[0])*0.5,
	  	      (elements[i].dark[1]+elements[i].light[1])*0.5,
	  	      (elements[i].dark[2]+elements[i].light[2])*0.5);
          fprintf(file, "  ambient %5.3f %5.3f %5.3f\n", elements[i].ambient[0], elements[i].ambient[1],
	  	      elements[i].ambient[2]);
          fprintf(file, "  specular %5.3f %5.3f %5.3f\n", elements[i].specular[0], elements[i].specular[1],
		      elements[i].specular[2]);
          fprintf(file, "  specpow %7.3f\n", elements[i].shininess);
	    fprintf(file, "  transp  %7.3f\n", elements[i].alpha);
	  }
	}
    }
    fremem((void **)&done);
    fprintf(file, "name molecule list\n");
    ortho[0]=0.5*(windows[VIEWER].right-windows[VIEWER].left);
    ortho[1]=0.5*(windows[VIEWER].top-windows[VIEWER].bottom);
    ortho[2]=-0.5*(windows[VIEWER].far-windows[VIEWER].near);
  }
  return(file);
}

void raytraceClose()
{
  fprintf(file, "end\n");
  fprintf(file, "object molecule\n");
  fclose(file);
  file=NULL;
}

void raytracerBegin(GLenum what)
{
  fprintf(file, "triangle %s ", material->symbol);
}

void raytracerEnd()
{
  fprintf(file, "\n");
}

void raytracerVertex3d(double vx, double vy, double vz)
{
  double t[3];

  t[0]=ortho[0]*vx*tmat[0][0]+ortho[0]*vy*tmat[0][1]+ortho[0]*vz*tmat[0][2]+tmat[0][3];
  t[1]=ortho[1]*vx*tmat[1][0]+ortho[1]*vy*tmat[1][1]+ortho[1]*vz*tmat[1][2]+tmat[1][3];
  t[2]=ortho[2]*vx*tmat[2][0]+ortho[2]*vy*tmat[2][1]+ortho[2]*vz*tmat[2][2]+tmat[2][3];
  fprintf(file, "%10.6f %10.6f %10.6f ", t[0], t[1], t[2]);

  if (printNormal)
  {
    t[0]=ortho[0]*n[0]*tmat[0][0]+ortho[0]*n[1]*tmat[0][1]+ortho[0]*n[2]*tmat[0][2]+tmat[0][3];
    t[1]=ortho[1]*n[0]*tmat[1][0]+ortho[1]*n[1]*tmat[1][1]+ortho[1]*n[2]*tmat[1][2]+tmat[1][3];
    t[2]=ortho[2]*n[0]*tmat[2][0]+ortho[2]*n[1]*tmat[2][1]+ortho[2]*n[2]*tmat[2][2]+tmat[2][3];
    fprintf(file, "%10.6f %10.6f %10.6f ", t[0], t[1], t[2]);
  }
}

void raytracerNormal3d(double vx, double vy, double vz)
{
  n[0]=vx;
  n[1]=vy;
  n[2]=vz;
  printNormal=TRUE;
}

void raytracerSphere(GLUquadricObj *object, GLdouble radius, GLint dummy1,
			   GLint dummy2)
{
  getMatrix(tmat);
  fprintf(file, "sphere %s %f %10.6f %10.6f %10.6f\n", material->symbol, radius,
          ortho[0]*tmat[3][0], ortho[1]*tmat[3][1], ortho[2]*tmat[3][2]);
}

void raytracerCylinder(GLUquadricObj *object, GLdouble top, GLdouble bottom,
                       GLdouble height, GLint dummy1, GLint dummy2)
{
  getMatrix(tmat);
  fprintf(file, "cylinder %s %f %10.6f %10.6f %10.6f %10.6f %10.6f %10.6f\n",
          material->symbol, bottom, ortho[0]*tmat[3][0], ortho[1]*tmat[3][1],
          ortho[2]*tmat[3][2], ortho[0]*(height*tmat[2][0]+tmat[3][0]),
          ortho[1]*(height*tmat[2][1]+tmat[3][1]), ortho[2]*(height*tmat[2][2]+tmat[3][2]));
}

void raytracerColor4fv(const GLfloat *color)
{
}

void raytracerClearColor(GLclampf red, GLclampf green , GLclampf blue, GLclampf alpha)
{
}

void raytracerMaterial(struct ELEMENT *e)
{
  material=e;
}
