/*******************************************************************************
*                                                                              *
*                                   Viewmol                                    *
*                                                                              *
*                                 Z O O M . C                                  *
*                                                                              *
*                 Copyright (c) Joerg-R. Hill, December 1996                   *
*                                                                              *
********************************************************************************
*
* $Id: zoom.c,v 1.1 1996/12/10 18:44:37 jrh Exp $
* $Log: zoom.c,v $
 * Revision 1.1  1996/12/10  18:44:37  jrh
 * Initial revision
 *
*
*/
#include<X11/Xlib.h>
#include<X11/Intrinsic.h>
#ifdef __osf__
#include<X11/GLw/GLwDrawA.h>
#else
#include<GL/GLwDrawA.h>
#endif
#include "viewmol.h"

extern void drawSpectrum(Widget, caddr_t, caddr_t);
extern void drawMODiagram(Widget, caddr_t, caddr_t);
extern void setWindowColor(int, Pixel, const float *);
extern void pixwor(Dimension, Dimension, GLdouble, GLdouble, GLdouble, GLdouble, double *, double *);
extern void *getmem(size_t, size_t);
extern void *expmem(void *, size_t, size_t);
extern void fremem(void **);
extern void setMenuItem(int, int, int);
extern void redraw(int);

extern struct WINDOW windows[];
extern int swapBuffers;
static int mouseInitX, mouseInitY, window, zoomRec=0;
static struct ZOOM *zoomOld=NULL;

void zoomIn(Widget widget, GLwDrawingAreaCallbackStruct *data)
{
/* This subroutine is called when the user wants to zoom
   into the spectrum or into the MO diagram. It is called
   when the middle mouse button is hold down and the mouse
   is moved. */

  swapBuffers=FALSE;
  if (widget == windows[SPECTRUM].widget)
  {
    drawSpectrum((Widget)0, (caddr_t)0, (caddr_t)0);
    window=SPECTRUM;
  }
  else if (widget == windows[MO].widget)
  {
    drawMODiagram((Widget)0, (caddr_t)0, (caddr_t)0);
    window=MO;
  }
  swapBuffers=TRUE;

  glEnable(GL_LINE_STIPPLE);                             /* Dotted lines */
  glLineStipple(1, 0x5555);
  glLineWidth((GLfloat)1.);
  setWindowColor(FOREGROUND, windows[window].foreground, windows[window].foreground_rgb);
  glPushMatrix();
  glLoadIdentity();
  glOrtho(0.0e0, (double)data->width, 0.0e0, (double)data->height, 0.0e0, 1.0e0);
  glBegin(GL_LINE_LOOP);
  glVertex2i(mouseInitX, mouseInitY);
  glVertex2i(mouseInitX, data->height-data->event->xmotion.y);
  glVertex2i(data->event->xmotion.x, data->height-data->event->xmotion.y);
  glVertex2i(data->event->xmotion.x, mouseInitY);
  glEnd();
  GLwDrawingAreaSwapBuffers(windows[window].widget);
  glPopMatrix();
}

void initZoom(GLwDrawingAreaCallbackStruct *data)
{
  mouseInitX=data->event->xbutton.x;
  mouseInitY=data->height-data->event->xbutton.y;
}

void endZoom(int width, int height, int x, int y)
{
  double xpix, ypix, save;

/* Copy final values and be careful that these are not
   equal to the start values. */

  pixwor(width, height, windows[window].left, windows[window].right,
	   windows[window].bottom, windows[window].top, &xpix, &ypix);

  if (zoomOld == NULL)
    zoomOld=(struct ZOOM *)getmem(zoomRec+1, sizeof(struct ZOOM));
  else
    zoomOld=(struct ZOOM *)expmem((void *)zoomOld, zoomRec+1, sizeof(struct ZOOM));

  zoomOld[zoomRec].window=window;
  zoomOld[zoomRec].left=windows[window].left;
  zoomOld[zoomRec].right=windows[window].right;
  zoomOld[zoomRec].bottom=windows[window].bottom;
  zoomOld[zoomRec++].top=windows[window].top;

  if (window == SPECTRUM)
  {
    save=windows[window].left;
    if (mouseInitX < x)
    {
      windows[window].left=mouseInitX*xpix+save;
      windows[window].right=x*xpix+save;
    }
    else if (mouseInitX == x)
    {
      windows[window].left=mouseInitX*xpix+save;
      windows[window].right=(mouseInitX+1)*xpix+save;
    }
    else
    {
      windows[window].left=x*xpix+save;
      windows[window].right=mouseInitX*xpix+save;
    }
  }
  y=height-y;
  save=windows[window].bottom;
  if (mouseInitY < y)
  {
    windows[window].top=y*ypix+save;
    windows[window].bottom=mouseInitY*ypix+save;
  }
  else if (mouseInitY == y)
  {
    windows[window].top=(mouseInitY+1)*ypix+save;
    windows[window].bottom=mouseInitY*ypix+save;
  }
  else
  {
    windows[window].top=mouseInitY*ypix+save;
    windows[window].bottom=y*ypix+save;
  }

  if (window == SPECTRUM)
  {
    drawSpectrum((Widget)0, (caddr_t)0, (caddr_t)0);
    setMenuItem(SPECTRUM, 2, True);
  }
  else if (window == MO)
  {
    drawMODiagram((Widget)0, (caddr_t)0, (caddr_t)0);
    setMenuItem(MO, 2, True);
  }
}

void zoomOut(Widget widget, caddr_t window, GLwDrawingAreaCallbackStruct *data)
{
  register int i, j, w;

  w=(int)window;
  for (i=zoomRec-1; i>=0; i--)
  {
    if (zoomOld[i].window == w)
    {
	windows[w].left=zoomOld[i].left;
	windows[w].right=zoomOld[i].right;
	windows[w].bottom=zoomOld[i].bottom;
	windows[w].top=zoomOld[i].top;
	for (j=i+1; j<zoomRec; j++)
	{
	  zoomOld[i].window=zoomOld[j].window;
	  zoomOld[i].left=zoomOld[j].left;
	  zoomOld[i].right=zoomOld[j].right;
	  zoomOld[i].bottom=zoomOld[j].bottom;
	  zoomOld[i].top=zoomOld[j].top;
	  i++;
	}
	zoomRec--;
	if (zoomRec == 0)
	{
	  fremem((void **)&zoomOld);
	  setMenuItem(w, 2, False);
	}
	else
	  zoomOld=(struct ZOOM *)expmem((void *)zoomOld, zoomRec, sizeof(struct ZOOM));
	break;
    }
  }
  redraw(w);
}
